/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.function.LongPredicate;
import net.minecraft.util.MathHelper;

public abstract class LightEngineGraph {
    private static final int a = 255;
    private final int b;
    private final LongLinkedOpenHashSet[] c;
    private final Long2ByteMap d;
    private int e;
    private volatile boolean f;

    protected LightEngineGraph(int levelCount, final int expectedLevelSize, final int expectedTotalSize) {
        if (levelCount >= 254) {
            throw new IllegalArgumentException("Level count must be < 254.");
        }
        this.b = levelCount;
        this.c = new LongLinkedOpenHashSet[levelCount];
        for (int i2 = 0; i2 < levelCount; ++i2) {
            this.c[i2] = new LongLinkedOpenHashSet(expectedLevelSize, 0.5f){

                protected void rehash(int i2) {
                    if (i2 > expectedLevelSize) {
                        super.rehash(i2);
                    }
                }
            };
        }
        this.d = new Long2ByteOpenHashMap(expectedTotalSize, 0.5f){

            protected void rehash(int i2) {
                if (i2 > expectedTotalSize) {
                    super.rehash(i2);
                }
            }
        };
        this.d.defaultReturnValue((byte)-1);
        this.e = levelCount;
    }

    private int a(int a2, int b2) {
        int i2 = a2;
        if (i2 > b2) {
            i2 = b2;
        }
        if (i2 > this.b - 1) {
            i2 = this.b - 1;
        }
        return i2;
    }

    private void a(int maxLevel) {
        int i2 = this.e;
        this.e = maxLevel;
        for (int j2 = i2 + 1; j2 < maxLevel; ++j2) {
            if (this.c[j2].isEmpty()) continue;
            this.e = j2;
            break;
        }
    }

    protected void e(long id) {
        int i2 = this.d.get(id) & 0xFF;
        if (i2 == 255) {
            return;
        }
        int j2 = this.c(id);
        int k2 = this.a(j2, i2);
        this.a(id, k2, this.b, true);
        this.f = this.e < this.b;
    }

    public void a(LongPredicate predicate) {
        LongArrayList longList = new LongArrayList();
        this.d.keySet().forEach(arg_0 -> LightEngineGraph.a(predicate, (LongList)longList, arg_0));
        longList.forEach(this::e);
    }

    private void a(long id, int level, int levelCount, boolean removeFully) {
        if (removeFully) {
            this.d.remove(id);
        }
        this.c[level].remove(id);
        if (this.c[level].isEmpty() && this.e == level) {
            this.a(levelCount);
        }
    }

    private void a(long id, int level, int targetLevel) {
        this.d.put(id, (byte)level);
        this.c[targetLevel].add(id);
        if (this.e > targetLevel) {
            this.e = targetLevel;
        }
    }

    protected void f(long id) {
        this.a(id, id, this.b - 1, false);
    }

    protected void a(long sourceId, long id, int level, boolean decrease) {
        this.a(sourceId, id, level, this.c(id), this.d.get(id) & 0xFF, decrease);
        this.f = this.e < this.b;
    }

    private void a(long sourceId, long id, int level, int currentLevel, int pendingLevel, boolean decrease) {
        int j2;
        boolean bl2;
        if (this.a(id)) {
            return;
        }
        level = MathHelper.a(level, 0, this.b - 1);
        currentLevel = MathHelper.a(currentLevel, 0, this.b - 1);
        if (pendingLevel == 255) {
            boolean bl = true;
            pendingLevel = currentLevel;
        } else {
            bl2 = false;
        }
        if (decrease) {
            int i2 = Math.min(pendingLevel, level);
        } else {
            j2 = MathHelper.a(this.a(id, sourceId, level), 0, this.b - 1);
        }
        int k2 = this.a(currentLevel, pendingLevel);
        if (currentLevel != j2) {
            int l2 = this.a(currentLevel, j2);
            if (k2 != l2 && !bl2) {
                this.a(id, k2, l2, false);
            }
            this.a(id, j2, l2);
        } else if (!bl2) {
            this.a(id, k2, this.b, true);
        }
    }

    protected final void b(long sourceId, long targetId, int level, boolean decrease) {
        int i2 = this.d.get(targetId) & 0xFF;
        int j2 = MathHelper.a(this.b(sourceId, targetId, level), 0, this.b - 1);
        if (decrease) {
            this.a(sourceId, targetId, j2, this.c(targetId), i2, true);
        } else {
            boolean bl2;
            int l2;
            if (i2 == 255) {
                boolean bl = true;
                int k2 = MathHelper.a(this.c(targetId), 0, this.b - 1);
            } else {
                l2 = i2;
                bl2 = false;
            }
            if (j2 == l2) {
                this.a(sourceId, targetId, this.b - 1, bl2 ? l2 : this.c(targetId), i2, false);
            }
        }
    }

    protected final boolean b() {
        return this.f;
    }

    protected final int b(int maxSteps) {
        if (this.e >= this.b) {
            return maxSteps;
        }
        while (this.e < this.b && maxSteps > 0) {
            int j2;
            --maxSteps;
            LongLinkedOpenHashSet longLinkedOpenHashSet = this.c[this.e];
            long l2 = longLinkedOpenHashSet.removeFirstLong();
            int i2 = MathHelper.a(this.c(l2), 0, this.b - 1);
            if (longLinkedOpenHashSet.isEmpty()) {
                this.a(this.b);
            }
            if ((j2 = this.d.remove(l2) & 0xFF) < i2) {
                this.a(l2, j2);
                this.a(l2, j2, true);
                continue;
            }
            if (j2 <= i2) continue;
            this.a(l2, j2, this.a(this.b - 1, j2));
            this.a(l2, this.b - 1);
            this.a(l2, i2, false);
        }
        this.f = this.e < this.b;
        return maxSteps;
    }

    public int c() {
        return this.d.size();
    }

    protected abstract boolean a(long var1);

    protected abstract int a(long var1, long var3, int var5);

    protected abstract void a(long var1, int var3, boolean var4);

    protected abstract int c(long var1);

    protected abstract void a(long var1, int var3);

    protected abstract int b(long var1, long var3, int var5);

    private static /* synthetic */ void a(LongPredicate longPredicate, LongList longList, long l2) {
        if (longPredicate.test(l2)) {
            longList.add(l2);
        }
    }
}

