/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.LightEngineGraphSection;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.LightEngineLayer;
import net.minecraft.world.level.lighting.LightEngineStorageArray;

public abstract class LightEngineStorage<M extends LightEngineStorageArray<M>>
extends LightEngineGraphSection {
    protected static final int a = 0;
    protected static final int b = 1;
    protected static final int c = 2;
    protected static final NibbleArray d = new NibbleArray();
    private static final EnumDirection[] n = EnumDirection.values();
    private final EnumSkyBlock o;
    private final ILightAccess p;
    protected final LongSet e = new LongOpenHashSet();
    protected final LongSet f = new LongOpenHashSet();
    protected final LongSet g = new LongOpenHashSet();
    protected volatile M e_visible;
    protected final Object visibleUpdateLock = new Object();
    protected final M i;
    protected final LongSet j = new LongOpenHashSet();
    protected final LongSet k = new LongOpenHashSet();
    protected final Long2ObjectMap<NibbleArray> l = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap());
    private final LongSet q = new LongOpenHashSet();
    private final LongSet r = new LongOpenHashSet();
    private final LongSet s = new LongOpenHashSet();
    protected volatile boolean m;

    protected LightEngineStorage(EnumSkyBlock lightType, ILightAccess chunkProvider, M lightData) {
        super(3, 16, 256);
        this.o = lightType;
        this.p = chunkProvider;
        this.i = lightData;
        this.e_visible = ((LightEngineStorageArray)lightData).b();
        ((LightEngineStorageArray)this.e_visible).d();
    }

    protected boolean g(long sectionPos) {
        return this.a(sectionPos, true) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected NibbleArray a(long sectionPos, boolean cached) {
        if (cached) {
            return this.a(this.i, sectionPos);
        }
        Object object = this.visibleUpdateLock;
        synchronized (object) {
            return this.a(this.e_visible, sectionPos);
        }
    }

    @Nullable
    protected NibbleArray a(M storage, long sectionPos) {
        return ((LightEngineStorageArray)storage).c(sectionPos);
    }

    @Nullable
    public NibbleArray h(long sectionPos) {
        NibbleArray dataLayer = (NibbleArray)this.l.get(sectionPos);
        return dataLayer != null ? dataLayer : this.a(sectionPos, false);
    }

    protected abstract int d(long var1);

    protected int i(long blockPos) {
        long l2 = SectionPosition.e(blockPos);
        NibbleArray dataLayer = this.a(l2, true);
        return dataLayer.a(SectionPosition.b(BlockPosition.a(blockPos)), SectionPosition.b(BlockPosition.b(blockPos)), SectionPosition.b(BlockPosition.c(blockPos)));
    }

    protected void b(long blockPos, int value) {
        long l2 = SectionPosition.e(blockPos);
        if (this.j.add(l2)) {
            ((LightEngineStorageArray)this.i).a(l2);
        }
        NibbleArray dataLayer = this.a(l2, true);
        dataLayer.a(SectionPosition.b(BlockPosition.a(blockPos)), SectionPosition.b(BlockPosition.b(blockPos)), SectionPosition.b(BlockPosition.c(blockPos)), value);
        SectionPosition.a(blockPos, arg_0 -> ((LongSet)this.k).add(arg_0));
    }

    @Override
    protected int c(long id) {
        if (id == Long.MAX_VALUE) {
            return 2;
        }
        if (this.e.contains(id)) {
            return 0;
        }
        return !this.s.contains(id) && ((LightEngineStorageArray)this.i).b(id) ? 1 : 2;
    }

    @Override
    protected int b(long id) {
        if (this.f.contains(id)) {
            return 2;
        }
        return !this.e.contains(id) && !this.g.contains(id) ? 2 : 0;
    }

    @Override
    protected void a(long id, int level) {
        int i2 = this.c(id);
        if (i2 != 0 && level == 0) {
            this.e.add(id);
            this.g.remove(id);
        }
        if (i2 == 0 && level != 0) {
            this.e.remove(id);
            this.f.remove(id);
        }
        if (i2 >= 2 && level != 2) {
            if (this.s.contains(id)) {
                this.s.remove(id);
            } else {
                ((LightEngineStorageArray)this.i).a(id, this.j(id));
                this.j.add(id);
                this.k(id);
                int j2 = SectionPosition.b(id);
                int k2 = SectionPosition.c(id);
                int l2 = SectionPosition.d(id);
                for (int m2 = -1; m2 <= 1; ++m2) {
                    for (int n2 = -1; n2 <= 1; ++n2) {
                        for (int o2 = -1; o2 <= 1; ++o2) {
                            this.k.add(SectionPosition.b(j2 + n2, k2 + o2, l2 + m2));
                        }
                    }
                }
            }
        }
        if (i2 != 2 && level >= 2) {
            this.s.add(id);
        }
        this.m = !this.s.isEmpty();
    }

    protected NibbleArray j(long sectionPos) {
        NibbleArray dataLayer = (NibbleArray)this.l.get(sectionPos);
        return dataLayer != null ? dataLayer : new NibbleArray();
    }

    protected void a(LightEngineLayer<?, ?> storage, long sectionPos) {
        if (storage.c() != 0) {
            if (storage.c() < 8192) {
                storage.a(mx -> SectionPosition.e(mx) == sectionPos);
            } else {
                int i2 = SectionPosition.c(SectionPosition.b(sectionPos));
                int j2 = SectionPosition.c(SectionPosition.c(sectionPos));
                int k2 = SectionPosition.c(SectionPosition.d(sectionPos));
                for (int l2 = 0; l2 < 16; ++l2) {
                    for (int m2 = 0; m2 < 16; ++m2) {
                        for (int n2 = 0; n2 < 16; ++n2) {
                            long o2 = BlockPosition.a(i2 + l2, j2 + m2, k2 + n2);
                            storage.e(o2);
                        }
                    }
                }
            }
        }
    }

    protected boolean a() {
        return this.m;
    }

    protected void a(LightEngineLayer<M, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        if (this.a() || !this.l.isEmpty()) {
            LongIterator longIterator = this.s.iterator();
            while (longIterator.hasNext()) {
                long l2 = (Long)longIterator.next();
                this.a(lightProvider, l2);
                NibbleArray dataLayer = (NibbleArray)this.l.remove(l2);
                NibbleArray dataLayer2 = ((LightEngineStorageArray)this.i).d(l2);
                if (!this.r.contains(SectionPosition.f(l2))) continue;
                if (dataLayer != null) {
                    this.l.put(l2, (Object)dataLayer);
                    continue;
                }
                if (dataLayer2 == null) continue;
                this.l.put(l2, (Object)dataLayer2);
            }
            ((LightEngineStorageArray)this.i).c();
            longIterator = this.s.iterator();
            while (longIterator.hasNext()) {
                long m2 = (Long)longIterator.next();
                this.l(m2);
            }
            this.s.clear();
            this.m = false;
            for (Long2ObjectMap.Entry entry : this.l.long2ObjectEntrySet()) {
                long n2 = entry.getLongKey();
                if (!this.g(n2)) continue;
                NibbleArray dataLayer3 = (NibbleArray)entry.getValue();
                if (((LightEngineStorageArray)this.i).c(n2) == dataLayer3) continue;
                this.a(lightProvider, n2);
                ((LightEngineStorageArray)this.i).a(n2, dataLayer3);
                this.j.add(n2);
            }
            ((LightEngineStorageArray)this.i).c();
            if (!skipEdgeLightPropagation) {
                longIterator = this.l.keySet().iterator();
                while (longIterator.hasNext()) {
                    long o2 = (Long)longIterator.next();
                    this.b(lightProvider, o2);
                }
            } else {
                longIterator = this.q.iterator();
                while (longIterator.hasNext()) {
                    long p2 = (Long)longIterator.next();
                    this.b(lightProvider, p2);
                }
            }
            this.q.clear();
            ObjectIterator objectIterator = this.l.long2ObjectEntrySet().iterator();
            while (objectIterator.hasNext()) {
                Long2ObjectMap.Entry entry2 = (Long2ObjectMap.Entry)objectIterator.next();
                long q2 = entry2.getLongKey();
                if (!this.g(q2)) continue;
                objectIterator.remove();
            }
        }
    }

    private void b(LightEngineLayer<M, ?> lightProvider, long sectionPos) {
        if (this.g(sectionPos)) {
            int i2 = SectionPosition.c(SectionPosition.b(sectionPos));
            int j2 = SectionPosition.c(SectionPosition.c(sectionPos));
            int k2 = SectionPosition.c(SectionPosition.d(sectionPos));
            for (EnumDirection direction : n) {
                long l2 = SectionPosition.a(sectionPos, direction);
                if (this.l.containsKey(l2) || !this.g(l2)) continue;
                for (int m2 = 0; m2 < 16; ++m2) {
                    for (int n2 = 0; n2 < 16; ++n2) {
                        long o2;
                        long p2 = switch (direction) {
                            case EnumDirection.a -> {
                                o2 = BlockPosition.a(i2 + n2, j2, k2 + m2);
                                yield BlockPosition.a(i2 + n2, j2 - 1, k2 + m2);
                            }
                            case EnumDirection.b -> {
                                o2 = BlockPosition.a(i2 + n2, j2 + 16 - 1, k2 + m2);
                                yield BlockPosition.a(i2 + n2, j2 + 16, k2 + m2);
                            }
                            case EnumDirection.c -> {
                                o2 = BlockPosition.a(i2 + m2, j2 + n2, k2);
                                yield BlockPosition.a(i2 + m2, j2 + n2, k2 - 1);
                            }
                            case EnumDirection.d -> {
                                o2 = BlockPosition.a(i2 + m2, j2 + n2, k2 + 16 - 1);
                                yield BlockPosition.a(i2 + m2, j2 + n2, k2 + 16);
                            }
                            case EnumDirection.e -> {
                                o2 = BlockPosition.a(i2, j2 + m2, k2 + n2);
                                yield BlockPosition.a(i2 - 1, j2 + m2, k2 + n2);
                            }
                            default -> {
                                o2 = BlockPosition.a(i2 + 16 - 1, j2 + m2, k2 + n2);
                                yield BlockPosition.a(i2 + 16, j2 + m2, k2 + n2);
                            }
                        };
                        lightProvider.a(o2, p2, lightProvider.b(o2, p2, lightProvider.c(o2)), false);
                        lightProvider.a(p2, o2, lightProvider.b(p2, o2, lightProvider.c(p2)), false);
                    }
                }
            }
        }
    }

    protected void k(long sectionPos) {
    }

    protected void l(long sectionPos) {
    }

    protected void b(long columnPos, boolean enabled) {
    }

    public void c(long sectionPos, boolean retain) {
        if (retain) {
            this.r.add(sectionPos);
        } else {
            this.r.remove(sectionPos);
        }
    }

    protected void a(long sectionPos, @Nullable NibbleArray array, boolean nonEdge) {
        if (array != null) {
            this.l.put(sectionPos, (Object)array);
            if (!nonEdge) {
                this.q.add(sectionPos);
            }
        } else {
            this.l.remove(sectionPos);
        }
    }

    protected void d(long sectionPos, boolean notReady) {
        boolean bl = this.e.contains(sectionPos);
        if (!bl && !notReady) {
            this.g.add(sectionPos);
            this.a(Long.MAX_VALUE, sectionPos, 0, true);
        }
        if (bl && notReady) {
            this.f.add(sectionPos);
            this.a(Long.MAX_VALUE, sectionPos, 2, false);
        }
    }

    protected void d() {
        if (this.b()) {
            this.b(Integer.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void e() {
        if (!this.j.isEmpty()) {
            Object object = this.visibleUpdateLock;
            synchronized (object) {
                Object dataLayerStorageMap = ((LightEngineStorageArray)this.i).b();
                ((LightEngineStorageArray)dataLayerStorageMap).d();
                this.e_visible = dataLayerStorageMap;
            }
            this.j.clear();
        }
        if (!this.k.isEmpty()) {
            LongIterator longIterator = this.k.iterator();
            while (longIterator.hasNext()) {
                long l2 = longIterator.nextLong();
                this.p.a(this.o, SectionPosition.a(l2));
            }
            this.k.clear();
        }
    }
}

