/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.destroystokyo.paper.util.map.QueuedChangesMapLong2Object;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.level.chunk.NibbleArray;

public abstract class LightEngineStorageArray<M extends LightEngineStorageArray<M>> {
    private static final int b = 2;
    private final long[] c = new long[2];
    private final NibbleArray[] d = new NibbleArray[2];
    private boolean e;
    protected final QueuedChangesMapLong2Object<NibbleArray> data;
    protected final boolean isVisible;
    Function<Long, NibbleArray> lookup;

    protected LightEngineStorageArray(QueuedChangesMapLong2Object<NibbleArray> data, boolean isVisible) {
        if (isVisible) {
            data.performUpdatesLockMap();
        }
        this.data = data;
        this.isVisible = isVisible;
        this.lookup = isVisible ? data::getVisibleAsync : data::getUpdating;
        this.c();
        this.e = true;
    }

    public abstract M b();

    public void a(long pos) {
        if (this.isVisible) {
            throw new IllegalStateException("writing to visible data");
        }
        this.data.queueUpdate(pos, this.data.getUpdating(pos).b());
        this.c();
    }

    public boolean b(long chunkPos) {
        return this.lookup.apply(chunkPos) != null;
    }

    @Nullable
    public final NibbleArray c(long chunkPos) {
        NibbleArray dataLayer;
        if (this.e) {
            for (int i2 = 0; i2 < 2; ++i2) {
                if (chunkPos != this.c[i2]) continue;
                return this.d[i2];
            }
        }
        if ((dataLayer = this.lookup.apply(chunkPos)) == null) {
            return null;
        }
        if (this.e) {
            for (int j2 = 1; j2 > 0; --j2) {
                this.c[j2] = this.c[j2 - 1];
                this.d[j2] = this.d[j2 - 1];
            }
            this.c[0] = chunkPos;
            this.d[0] = dataLayer;
        }
        return dataLayer;
    }

    @Nullable
    public NibbleArray d(long chunkPos) {
        if (this.isVisible) {
            throw new IllegalStateException("writing to visible data");
        }
        return this.data.queueRemove(chunkPos);
    }

    public void a(long pos, NibbleArray data) {
        if (this.isVisible) {
            throw new IllegalStateException("writing to visible data");
        }
        this.data.queueUpdate(pos, data);
    }

    public void c() {
        for (int i2 = 0; i2 < 2; ++i2) {
            this.c[i2] = Long.MAX_VALUE;
            this.d[i2] = null;
        }
    }

    public void d() {
        this.e = false;
    }
}

