/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.portal.ShapeDetectorShape;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftPortalEvent;
import org.bukkit.craftbukkit.v1_19_R3.util.BlockStateListPopulator;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class BlockPortalShape {
    private static final int c = 2;
    public static final int a = 21;
    private static final int d = 3;
    public static final int b = 21;
    private static final BlockBase.f e = (iblockdata, iblockaccess, blockposition) -> iblockdata.a(Blocks.cn);
    private static final float f = 4.0f;
    private static final double g = 1.0;
    private final GeneratorAccess h;
    private final EnumDirection.EnumAxis i;
    private final EnumDirection j;
    private int k;
    @Nullable
    private BlockPosition l;
    private int m;
    private final int n;
    BlockStateListPopulator blocks;

    public static Optional<BlockPortalShape> a(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxis axis) {
        return BlockPortalShape.a(world, pos, (BlockPortalShape blockportalshape) -> blockportalshape.a() && blockportalshape.k == 0, axis);
    }

    public static Optional<BlockPortalShape> a(GeneratorAccess world, BlockPosition pos, Predicate<BlockPortalShape> validator, EnumDirection.EnumAxis axis) {
        Optional<BlockPortalShape> optional = Optional.of(new BlockPortalShape(world, pos, axis)).filter(validator);
        if (optional.isPresent()) {
            return optional;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = axis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        return Optional.of(new BlockPortalShape(world, pos, enumdirection_enumaxis1)).filter(validator);
    }

    public BlockPortalShape(GeneratorAccess world, BlockPosition pos, EnumDirection.EnumAxis axis) {
        this.blocks = new BlockStateListPopulator(world.getMinecraftWorld());
        this.h = world;
        this.i = axis;
        this.j = axis == EnumDirection.EnumAxis.a ? EnumDirection.e : EnumDirection.d;
        this.l = this.a(pos);
        if (this.l == null) {
            this.l = pos;
            this.n = 1;
            this.m = 1;
        } else {
            this.n = this.d();
            if (this.n > 0) {
                this.m = this.e();
            }
        }
    }

    @Nullable
    private BlockPosition a(BlockPosition pos) {
        int i2 = Math.max(this.h.v_(), pos.v() - 21);
        while (pos.v() > i2 && BlockPortalShape.a(this.h.a_(pos.d()))) {
            pos = pos.d();
        }
        EnumDirection enumdirection = this.j.g();
        int j2 = this.a(pos, enumdirection) - 1;
        return j2 < 0 ? null : pos.a(enumdirection, j2);
    }

    private int d() {
        int i2 = this.a(this.l, this.j);
        return i2 >= 2 && i2 <= 21 ? i2 : 0;
    }

    private int a(BlockPosition pos, EnumDirection direction) {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 <= 21; ++i2) {
            blockposition_mutableblockposition.g(pos).c(direction, i2);
            IBlockData iblockdata = this.h.a_(blockposition_mutableblockposition);
            if (!BlockPortalShape.a(iblockdata)) {
                if (!e.test(iblockdata, this.h, blockposition_mutableblockposition)) break;
                this.blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata, 18);
                return i2;
            }
            IBlockData iblockdata1 = this.h.a_(blockposition_mutableblockposition.c(EnumDirection.a));
            if (!e.test(iblockdata1, this.h, blockposition_mutableblockposition)) break;
            this.blocks.a((BlockPosition)blockposition_mutableblockposition, iblockdata1, 18);
        }
        return 0;
    }

    private int e() {
        BlockPosition.MutableBlockPosition blockposition_mutableblockposition = new BlockPosition.MutableBlockPosition();
        int i2 = this.a(blockposition_mutableblockposition);
        return i2 >= 3 && i2 <= 21 && this.a(blockposition_mutableblockposition, i2) ? i2 : 0;
    }

    private boolean a(BlockPosition.MutableBlockPosition pos, int height) {
        for (int j2 = 0; j2 < this.n; ++j2) {
            BlockPosition.MutableBlockPosition blockposition_mutableblockposition1 = pos.g(this.l).c(EnumDirection.b, height).c(this.j, j2);
            if (!e.test(this.h.a_(blockposition_mutableblockposition1), this.h, blockposition_mutableblockposition1)) {
                return false;
            }
            this.blocks.a((BlockPosition)blockposition_mutableblockposition1, this.h.a_(blockposition_mutableblockposition1), 18);
        }
        return true;
    }

    private int a(BlockPosition.MutableBlockPosition pos) {
        for (int i2 = 0; i2 < 21; ++i2) {
            pos.g(this.l).c(EnumDirection.b, i2).c(this.j, -1);
            if (!e.test(this.h.a_(pos), this.h, pos)) {
                return i2;
            }
            pos.g(this.l).c(EnumDirection.b, i2).c(this.j, this.n);
            if (!e.test(this.h.a_(pos), this.h, pos)) {
                return i2;
            }
            for (int j2 = 0; j2 < this.n; ++j2) {
                pos.g(this.l).c(EnumDirection.b, i2).c(this.j, j2);
                IBlockData iblockdata = this.h.a_(pos);
                if (!BlockPortalShape.a(iblockdata)) {
                    return i2;
                }
                if (!iblockdata.a(Blocks.ed)) continue;
                ++this.k;
            }
            this.blocks.a((BlockPosition)pos.g(this.l).c(EnumDirection.b, i2).c(this.j, -1), this.h.a_(pos), 18);
            this.blocks.a((BlockPosition)pos.g(this.l).c(EnumDirection.b, i2).c(this.j, this.n), this.h.a_(pos), 18);
        }
        return 21;
    }

    private static boolean a(IBlockData state) {
        return state.h() || state.a(TagsBlock.aH) || state.a(Blocks.ed);
    }

    public boolean a() {
        return this.l != null && this.n >= 2 && this.n <= 21 && this.m >= 3 && this.m <= 21;
    }

    @Deprecated
    public boolean createPortalBlocks() {
        return this.createPortalBlocks(null);
    }

    public boolean createPortalBlocks(ItemActionContext itemActionContext) {
        CraftWorld bworld = this.h.getMinecraftWorld().getWorld();
        IBlockData iblockdata = (IBlockData)Blocks.ed.o().a(BlockPortal.a, this.i);
        BlockPosition.a(this.l, this.l.a(EnumDirection.b, this.m - 1).a(this.j, this.n - 1)).forEach(blockposition -> this.blocks.a((BlockPosition)blockposition, iblockdata, 18));
        PortalCreateEvent event = new PortalCreateEvent(this.blocks.getList(), (World)bworld, itemActionContext == null || itemActionContext.o() == null ? null : itemActionContext.o().getBukkitEntity(), PortalCreateEvent.CreateReason.FIRE);
        this.h.getMinecraftWorld().n().server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        BlockPosition.a(this.l, this.l.a(EnumDirection.b, this.m - 1).a(this.j, this.n - 1)).forEach(blockposition -> this.h.a((BlockPosition)blockposition, iblockdata, 18));
        return true;
    }

    public boolean c() {
        return this.a() && this.k == this.n * this.m;
    }

    public static Vec3D a(BlockUtil.Rectangle portalRect, EnumDirection.EnumAxis portalAxis, Vec3D entityPos, EntitySize entityDimensions) {
        double d3;
        double d2;
        double d0 = (double)portalRect.b - (double)entityDimensions.a;
        double d1 = (double)portalRect.c - (double)entityDimensions.b;
        BlockPosition blockposition = portalRect.a;
        if (d0 > 0.0) {
            float f2 = (float)blockposition.a(portalAxis) + entityDimensions.a / 2.0f;
            d2 = MathHelper.a(MathHelper.c(entityPos.a(portalAxis) - (double)f2, 0.0, d0), 0.0, 1.0);
        } else {
            d2 = 0.5;
        }
        if (d1 > 0.0) {
            EnumDirection.EnumAxis enumdirection_enumaxis1 = EnumDirection.EnumAxis.b;
            d3 = MathHelper.a(MathHelper.c(entityPos.a(enumdirection_enumaxis1) - (double)blockposition.a(enumdirection_enumaxis1), 0.0, d1), 0.0, 1.0);
        } else {
            d3 = 0.0;
        }
        EnumDirection.EnumAxis enumdirection_enumaxis1 = portalAxis == EnumDirection.EnumAxis.a ? EnumDirection.EnumAxis.c : EnumDirection.EnumAxis.a;
        double d4 = entityPos.a(enumdirection_enumaxis1) - ((double)blockposition.a(enumdirection_enumaxis1) + 0.5);
        return new Vec3D(d2, d3, d4);
    }

    public static ShapeDetectorShape createPortalInfo(WorldServer worldserver, BlockUtil.Rectangle blockutil_rectangle, EnumDirection.EnumAxis enumdirection_enumaxis, Vec3D vec3d, Entity entity, Vec3D vec3d1, float f2, float f1, CraftPortalEvent portalEventInfo) {
        BlockPosition blockposition = blockutil_rectangle.a;
        IBlockData iblockdata = worldserver.a_(blockposition);
        EnumDirection.EnumAxis enumdirection_enumaxis1 = iblockdata.d(BlockProperties.H).orElse(EnumDirection.EnumAxis.a);
        double d0 = blockutil_rectangle.b;
        double d1 = blockutil_rectangle.c;
        EntitySize entitysize = entity.a(entity.al());
        int i2 = enumdirection_enumaxis == enumdirection_enumaxis1 ? 0 : 90;
        Vec3D vec3d2 = enumdirection_enumaxis == enumdirection_enumaxis1 ? vec3d1 : new Vec3D(vec3d1.e, vec3d1.d, -vec3d1.c);
        double d2 = (double)entitysize.a / 2.0 + (d0 - (double)entitysize.a) * vec3d.a();
        double d3 = (d1 - (double)entitysize.b) * vec3d.b();
        double d4 = 0.5 + vec3d.c();
        boolean flag = enumdirection_enumaxis1 == EnumDirection.EnumAxis.a;
        Vec3D vec3d3 = new Vec3D((double)blockposition.u() + (flag ? d2 : d4), (double)blockposition.v() + d3, (double)blockposition.w() + (flag ? d4 : d2));
        Vec3D vec3d4 = BlockPortalShape.a(vec3d3, worldserver, entity, entitysize);
        return new ShapeDetectorShape(vec3d4, vec3d2, f2 + (float)i2, f1, worldserver, portalEventInfo);
    }

    private static Vec3D a(Vec3D fallback, WorldServer world, Entity entity, EntitySize dimensions) {
        if (dimensions.a <= 4.0f && dimensions.b <= 4.0f) {
            double d0 = (double)dimensions.b / 2.0;
            Vec3D vec3d1 = fallback.b(0.0, d0, 0.0);
            VoxelShape voxelshape = VoxelShapes.a(AxisAlignedBB.a(vec3d1, dimensions.a, 0.0, dimensions.a).b(0.0, 1.0, 0.0).g(1.0E-6));
            Optional<Vec3D> optional = world.a(entity, voxelshape, vec3d1, (double)dimensions.a, (double)dimensions.b, (double)dimensions.a);
            Optional<Vec3D> optional1 = optional.map(vec3d2 -> vec3d2.a(0.0, d0, 0.0));
            return optional1.orElse(fallback);
        }
        return fallback;
    }
}

