/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBanner;
import net.minecraft.world.level.saveddata.maps.MapIcon;

public class MapIconBanner {
    private final BlockPosition a;
    private final EnumColor b;
    @Nullable
    private final IChatBaseComponent c;

    public MapIconBanner(BlockPosition pos, EnumColor dyeColor, @Nullable IChatBaseComponent name) {
        this.a = pos;
        this.b = dyeColor;
        this.c = name;
    }

    public static MapIconBanner a(NBTTagCompound nbt) {
        BlockPosition blockPos = GameProfileSerializer.b(nbt.p("Pos"));
        EnumColor dyeColor = EnumColor.a(nbt.l("Color"), EnumColor.a);
        IChatMutableComponent component = nbt.e("Name") ? IChatBaseComponent.ChatSerializer.a(nbt.l("Name")) : null;
        return new MapIconBanner(blockPos, dyeColor, component);
    }

    @Nullable
    public static MapIconBanner a(IBlockAccess blockView, BlockPosition blockPos) {
        TileEntity blockEntity = blockView.c_(blockPos);
        if (blockEntity instanceof TileEntityBanner) {
            TileEntityBanner bannerBlockEntity = (TileEntityBanner)blockEntity;
            EnumColor dyeColor = bannerBlockEntity.g();
            IChatBaseComponent component = bannerBlockEntity.aa() ? bannerBlockEntity.ab() : null;
            return new MapIconBanner(blockPos, dyeColor, component);
        }
        return null;
    }

    public BlockPosition a() {
        return this.a;
    }

    public EnumColor b() {
        return this.b;
    }

    public MapIcon.Type c() {
        switch (this.b) {
            case a: {
                return MapIcon.Type.k;
            }
            case b: {
                return MapIcon.Type.l;
            }
            case c: {
                return MapIcon.Type.m;
            }
            case d: {
                return MapIcon.Type.n;
            }
            case e: {
                return MapIcon.Type.o;
            }
            case f: {
                return MapIcon.Type.p;
            }
            case g: {
                return MapIcon.Type.q;
            }
            case h: {
                return MapIcon.Type.r;
            }
            case i: {
                return MapIcon.Type.s;
            }
            case j: {
                return MapIcon.Type.t;
            }
            case k: {
                return MapIcon.Type.u;
            }
            case l: {
                return MapIcon.Type.v;
            }
            case m: {
                return MapIcon.Type.w;
            }
            case n: {
                return MapIcon.Type.x;
            }
            case o: {
                return MapIcon.Type.y;
            }
        }
        return MapIcon.Type.z;
    }

    @Nullable
    public IChatBaseComponent d() {
        return this.c;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapIconBanner mapBanner = (MapIconBanner)object;
        return Objects.equals(this.a, mapBanner.a) && this.b == mapBanner.b && Objects.equals(this.c, mapBanner.c);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.a, this.b, this.c);
    }

    public NBTTagCompound e() {
        NBTTagCompound compoundTag = new NBTTagCompound();
        compoundTag.a("Pos", GameProfileSerializer.a(this.a));
        compoundTag.a("Color", this.b.b());
        if (this.c != null) {
            compoundTag.a("Name", IChatBaseComponent.ChatSerializer.a(this.c));
        }
        return compoundTag;
    }

    public String f() {
        return "banner-" + this.a.u() + "," + this.a.v() + "," + this.a.w();
    }
}

