/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.saveddata.maps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.decoration.EntityItemFrame;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.saveddata.PersistentBase;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.MapIconBanner;
import net.minecraft.world.level.saveddata.maps.WorldMapFrame;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.map.CraftMapRenderer;
import org.bukkit.craftbukkit.v1_19_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_19_R3.map.RenderData;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCursor;
import org.slf4j.Logger;

public class WorldMap
extends PersistentBase {
    private static final Logger i = LogUtils.getLogger();
    private static final int j = 128;
    private static final int k = 64;
    public static final int a = 4;
    public static final int b = 256;
    public int c;
    public int d;
    public ResourceKey<World> e;
    public boolean l;
    public boolean m;
    public byte f;
    public byte[] g = new byte[16384];
    public boolean h;
    public final List<WorldMapHumanTracker> n = Lists.newArrayList();
    public final Map<EntityHuman, WorldMapHumanTracker> o = Maps.newHashMap();
    private final Map<String, MapIconBanner> p = Maps.newHashMap();
    public final Map<String, MapIcon> q = Maps.newLinkedHashMap();
    private final Map<String, WorldMapFrame> r = Maps.newHashMap();
    private int s;
    private RenderData vanillaRender = new RenderData();
    public final CraftMapView mapView;
    private CraftServer server;
    public UUID uniqueId = null;
    public String id;

    private WorldMap(int centerX, int centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, boolean locked, ResourceKey<World> dimension) {
        this.f = scale;
        this.c = centerX;
        this.d = centerZ;
        this.e = dimension;
        this.l = showIcons;
        this.m = unlimitedTracking;
        this.h = locked;
        this.b();
        this.mapView = new CraftMapView(this);
        this.server = (CraftServer)Bukkit.getServer();
        this.vanillaRender.buffer = this.g;
    }

    public static WorldMap a(double centerX, double centerZ, byte scale, boolean showIcons, boolean unlimitedTracking, ResourceKey<World> dimension) {
        int i2 = 128 * (1 << scale);
        int j2 = MathHelper.a((centerX + 64.0) / (double)i2);
        int k2 = MathHelper.a((centerZ + 64.0) / (double)i2);
        int l2 = j2 * i2 + i2 / 2 - 64;
        int i1 = k2 * i2 + i2 / 2 - 64;
        return new WorldMap(l2, i1, scale, showIcons, unlimitedTracking, false, dimension);
    }

    public static WorldMap a(byte scale, boolean locked, ResourceKey<World> dimension) {
        return new WorldMap(0, 0, scale, false, false, locked, dimension);
    }

    public static WorldMap b(NBTTagCompound nbt) {
        NBTBase dimension = nbt.c("dimension");
        if (dimension instanceof NBTNumber && ((NBTNumber)dimension).g() >= 10) {
            UUID uuid;
            CraftWorld world;
            long least = nbt.i("UUIDLeast");
            long most = nbt.i("UUIDMost");
            dimension = least != 0L && most != 0L ? ((world = (CraftWorld)Bukkit.getWorld((UUID)(uuid = new UUID(most, least)))) != null ? NBTTagString.a("minecraft:" + world.getName().toLowerCase(Locale.ENGLISH)) : NBTTagString.a("bukkit:_invalidworld_")) : NBTTagString.a("bukkit:_invalidworld_");
        }
        DataResult<ResourceKey<World>> dataresult = DimensionManager.a(new Dynamic<NBTBase>(DynamicOpsNBT.a, dimension));
        Logger logger = i;
        Objects.requireNonNull(logger);
        ResourceKey resourcekey = dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).orElseGet(() -> {
            UUID uniqueId;
            CraftWorld world;
            long least = nbt.i("UUIDLeast");
            long most = nbt.i("UUIDMost");
            if (least != 0L && most != 0L && (world = (CraftWorld)Bukkit.getWorld((UUID)(uniqueId = new UUID(most, least)))) != null) {
                return world.getHandle().ab();
            }
            throw new IllegalArgumentException("Invalid map dimension: " + nbt.c("dimension"));
        });
        int i2 = nbt.h("xCenter");
        int j2 = nbt.h("zCenter");
        byte b0 = (byte)MathHelper.a((int)nbt.f("scale"), 0, 4);
        boolean flag = !nbt.b("trackingPosition", 1) || nbt.q("trackingPosition");
        boolean flag1 = nbt.q("unlimitedTracking");
        boolean flag2 = nbt.q("locked");
        WorldMap worldmap = new WorldMap(i2, j2, b0, flag, flag1, flag2, resourcekey);
        byte[] abyte = nbt.m("colors");
        if (abyte.length == 16384) {
            worldmap.g = abyte;
        }
        worldmap.vanillaRender.buffer = abyte;
        NBTTagList nbttaglist = nbt.c("banners", 10);
        for (int k2 = 0; k2 < nbttaglist.size(); ++k2) {
            MapIconBanner mapiconbanner = MapIconBanner.a(nbttaglist.a(k2));
            worldmap.p.put(mapiconbanner.f(), mapiconbanner);
            worldmap.a(mapiconbanner.c(), null, mapiconbanner.f(), mapiconbanner.a().u(), mapiconbanner.a().w(), 180.0, mapiconbanner.d());
        }
        NBTTagList nbttaglist1 = nbt.c("frames", 10);
        for (int l2 = 0; l2 < nbttaglist1.size(); ++l2) {
            WorldMapFrame worldmapframe = WorldMapFrame.a(nbttaglist1.a(l2));
            worldmap.r.put(worldmapframe.e(), worldmapframe);
            worldmap.a(MapIcon.Type.b, null, "frame-" + worldmapframe.d(), worldmapframe.b().u(), worldmapframe.b().w(), worldmapframe.c(), null);
        }
        return worldmap;
    }

    @Override
    public NBTTagCompound a(NBTTagCompound nbt) {
        DataResult dataresult = MinecraftKey.a.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.e.a());
        Logger logger = i;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(arg_0 -> ((Logger)logger).error(arg_0)).ifPresent(nbtbase -> nbt.a("dimension", (NBTBase)nbtbase));
        if (this.uniqueId == null) {
            for (org.bukkit.World world : this.server.getWorlds()) {
                CraftWorld cWorld = (CraftWorld)world;
                if (cWorld.getHandle().ab() != this.e) continue;
                this.uniqueId = cWorld.getUID();
                break;
            }
        }
        if (this.uniqueId != null) {
            nbt.a("UUIDLeast", this.uniqueId.getLeastSignificantBits());
            nbt.a("UUIDMost", this.uniqueId.getMostSignificantBits());
        }
        nbt.a("xCenter", this.c);
        nbt.a("zCenter", this.d);
        nbt.a("scale", this.f);
        nbt.a("colors", this.g);
        nbt.a("trackingPosition", this.l);
        nbt.a("unlimitedTracking", this.m);
        nbt.a("locked", this.h);
        NBTTagList nbttaglist = new NBTTagList();
        for (MapIconBanner mapiconbanner : this.p.values()) {
            nbttaglist.add(mapiconbanner.e());
        }
        nbt.a("banners", nbttaglist);
        NBTTagList nbttaglist1 = new NBTTagList();
        for (WorldMapFrame worldmapframe : this.r.values()) {
            nbttaglist1.add(worldmapframe.a());
        }
        nbt.a("frames", nbttaglist1);
        return nbt;
    }

    public WorldMap a() {
        WorldMap worldmap = new WorldMap(this.c, this.d, this.f, this.l, this.m, true, this.e);
        worldmap.p.putAll(this.p);
        worldmap.q.putAll(this.q);
        worldmap.s = this.s;
        System.arraycopy(this.g, 0, worldmap.g, 0, this.g.length);
        worldmap.b();
        return worldmap;
    }

    public WorldMap a(int zoomOutScale) {
        return WorldMap.a(this.c, this.d, (byte)MathHelper.a(this.f + zoomOutScale, 0, 4), this.l, this.m, this.e);
    }

    public void a(EntityHuman player, ItemStack stack) {
        NBTTagCompound nbttagcompound;
        if (!this.o.containsKey(player)) {
            WorldMapHumanTracker worldmap_worldmaphumantracker = new WorldMapHumanTracker(player);
            this.o.put(player, worldmap_worldmaphumantracker);
            this.n.add(worldmap_worldmaphumantracker);
        }
        if (!player.fJ().h(stack)) {
            this.a(player.Z().getString());
        }
        for (int i2 = 0; i2 < this.n.size(); ++i2) {
            WorldMapHumanTracker worldmap_worldmaphumantracker1 = this.n.get(i2);
            String s2 = worldmap_worldmaphumantracker1.a.Z().getString();
            if (!worldmap_worldmaphumantracker1.a.dB() && (worldmap_worldmaphumantracker1.a.fJ().h(stack) || stack.E())) {
                if (stack.E() || worldmap_worldmaphumantracker1.a.H.ab() != this.e || !this.l) continue;
                this.a(MapIcon.Type.a, worldmap_worldmaphumantracker1.a.H, s2, worldmap_worldmaphumantracker1.a.dl(), worldmap_worldmaphumantracker1.a.dr(), worldmap_worldmaphumantracker1.a.dw(), null);
                continue;
            }
            this.o.remove(worldmap_worldmaphumantracker1.a);
            this.n.remove(worldmap_worldmaphumantracker1);
            this.a(s2);
        }
        if (stack.E() && this.l) {
            EntityItemFrame entityitemframe = stack.F();
            BlockPosition blockposition = entityitemframe.x();
            WorldMapFrame worldmapframe = this.r.get(WorldMapFrame.a(blockposition));
            if (worldmapframe != null && entityitemframe.af() != worldmapframe.d() && this.r.containsKey(worldmapframe.e())) {
                this.a("frame-" + worldmapframe.d());
            }
            WorldMapFrame worldmapframe1 = new WorldMapFrame(blockposition, entityitemframe.cA().e() * 90, entityitemframe.af());
            if (this.q.size() < player.H.paperConfig().maps.itemFrameCursorLimit) {
                this.a(MapIcon.Type.b, player.H, "frame-" + entityitemframe.af(), blockposition.u(), blockposition.w(), entityitemframe.cA().e() * 90, null);
                this.r.put(worldmapframe1.e(), worldmapframe1);
            }
        }
        if ((nbttagcompound = stack.u()) != null && nbttagcompound.b("Decorations", 9)) {
            NBTTagList nbttaglist = nbttagcompound.c("Decorations", 10);
            for (int j2 = 0; j2 < nbttaglist.size(); ++j2) {
                NBTTagCompound nbttagcompound1 = nbttaglist.a(j2);
                if (this.q.containsKey(nbttagcompound1.l("id"))) continue;
                this.a(MapIcon.Type.a(nbttagcompound1.f("type")), player.H, nbttagcompound1.l("id"), nbttagcompound1.k("x"), nbttagcompound1.k("z"), nbttagcompound1.k("rot"), null);
            }
        }
    }

    private void a(String id) {
        MapIcon mapicon = this.q.remove(id);
        if (mapicon != null && mapicon.b().e()) {
            --this.s;
        }
        this.g();
    }

    public static void a(ItemStack stack, BlockPosition pos, String id, MapIcon.Type type) {
        NBTTagList nbttaglist;
        if (stack.t() && stack.u().b("Decorations", 9)) {
            nbttaglist = stack.u().c("Decorations", 10);
        } else {
            nbttaglist = new NBTTagList();
            stack.a("Decorations", nbttaglist);
        }
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.a("type", type.a());
        nbttagcompound.a("id", id);
        nbttagcompound.a("x", (double)pos.u());
        nbttagcompound.a("z", (double)pos.w());
        nbttagcompound.a("rot", 180.0);
        nbttaglist.add(nbttagcompound);
        if (type.c()) {
            NBTTagCompound nbttagcompound1 = stack.a("display");
            nbttagcompound1.a("MapColor", type.d());
        }
    }

    private void a(MapIcon.Type type, @Nullable GeneratorAccess world, String key, double x2, double z2, double rotation, @Nullable IChatBaseComponent text) {
        MapIcon mapicon1;
        MapIcon mapicon;
        byte b2;
        int i2 = 1 << this.f;
        float f2 = (float)(x2 - (double)this.c) / (float)i2;
        float f1 = (float)(z2 - (double)this.d) / (float)i2;
        byte b0 = (byte)((double)(f2 * 2.0f) + 0.5);
        byte b1 = (byte)((double)(f1 * 2.0f) + 0.5);
        boolean flag = true;
        if (f2 >= -63.0f && f1 >= -63.0f && f2 <= 63.0f && f1 <= 63.0f) {
            b2 = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.e == World.i && world != null) {
                int j2 = (int)(world.n_().f() / 10L);
                b2 = (byte)(j2 * j2 * 34187121 + j2 * 121 >> 15 & 0xF);
            }
        } else {
            if (type != MapIcon.Type.a) {
                this.a(key);
                return;
            }
            boolean flag1 = true;
            if (Math.abs(f2) < 320.0f && Math.abs(f1) < 320.0f) {
                type = MapIcon.Type.g;
            } else {
                if (!this.m) {
                    this.a(key);
                    return;
                }
                type = MapIcon.Type.h;
            }
            b2 = 0;
            if (f2 <= -63.0f) {
                b0 = -128;
            }
            if (f1 <= -63.0f) {
                b1 = -128;
            }
            if (f2 >= 63.0f) {
                b0 = 127;
            }
            if (f1 >= 63.0f) {
                b1 = 127;
            }
        }
        if (!(mapicon = new MapIcon(type, b0, b1, b2, text)).equals(mapicon1 = this.q.put(key, mapicon))) {
            if (mapicon1 != null && mapicon1.b().e()) {
                --this.s;
            }
            if (type.e()) {
                ++this.s;
            }
            this.g();
        }
    }

    @Nullable
    public Packet<?> a(int id, EntityHuman player) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.o.get(player);
        return worldmap_worldmaphumantracker == null ? null : worldmap_worldmaphumantracker.a(id);
    }

    public void a(int x2, int z2) {
        this.b();
        for (WorldMapHumanTracker worldmap_worldmaphumantracker : this.n) {
            worldmap_worldmaphumantracker.a(x2, z2);
        }
    }

    public void g() {
        this.b();
        this.n.forEach(WorldMapHumanTracker::b);
    }

    public WorldMapHumanTracker a(EntityHuman player) {
        WorldMapHumanTracker worldmap_worldmaphumantracker = this.o.get(player);
        if (worldmap_worldmaphumantracker == null) {
            worldmap_worldmaphumantracker = new WorldMapHumanTracker(player);
            this.o.put(player, worldmap_worldmaphumantracker);
            this.n.add(worldmap_worldmaphumantracker);
        }
        return worldmap_worldmaphumantracker;
    }

    public boolean a(GeneratorAccess world, BlockPosition pos) {
        double d0 = (double)pos.u() + 0.5;
        double d1 = (double)pos.w() + 0.5;
        int i2 = 1 << this.f;
        double d2 = (d0 - (double)this.c) / (double)i2;
        double d3 = (d1 - (double)this.d) / (double)i2;
        boolean flag = true;
        if (d2 >= -63.0 && d3 >= -63.0 && d2 <= 63.0 && d3 <= 63.0) {
            MapIconBanner mapiconbanner = MapIconBanner.a(world, pos);
            if (mapiconbanner == null) {
                return false;
            }
            if (this.p.remove(mapiconbanner.f(), mapiconbanner)) {
                this.a(mapiconbanner.f());
                return true;
            }
            if (!this.b(256)) {
                this.p.put(mapiconbanner.f(), mapiconbanner);
                this.a(mapiconbanner.c(), world, mapiconbanner.f(), d0, d1, 180.0, mapiconbanner.d());
                return true;
            }
        }
        return false;
    }

    public void a(IBlockAccess world, int x2, int z2) {
        Iterator<MapIconBanner> iterator = this.p.values().iterator();
        while (iterator.hasNext()) {
            MapIconBanner mapiconbanner1;
            MapIconBanner mapiconbanner = iterator.next();
            if (mapiconbanner.a().u() != x2 || mapiconbanner.a().w() != z2 || mapiconbanner.equals(mapiconbanner1 = MapIconBanner.a(world, mapiconbanner.a()))) continue;
            iterator.remove();
            this.a(mapiconbanner.f());
        }
    }

    public Collection<MapIconBanner> d() {
        return this.p.values();
    }

    public void a(BlockPosition pos, int id) {
        this.a("frame-" + id);
        this.r.remove(WorldMapFrame.a(pos));
    }

    public boolean a(int x2, int z2, byte color) {
        byte b1 = this.g[x2 + z2 * 128];
        if (b1 != color) {
            this.b(x2, z2, color);
            return true;
        }
        return false;
    }

    public void b(int x2, int z2, byte color) {
        this.g[x2 + z2 * 128] = color;
        this.a(x2, z2);
    }

    public boolean e() {
        MapIcon mapicon;
        Iterator<MapIcon> iterator = this.q.values().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while ((mapicon = iterator.next()).b() != MapIcon.Type.i && mapicon.b() != MapIcon.Type.j);
        return true;
    }

    public void a(List<MapIcon> icons) {
        this.q.clear();
        this.s = 0;
        for (int i2 = 0; i2 < icons.size(); ++i2) {
            MapIcon mapicon = icons.get(i2);
            this.q.put("icon-" + i2, mapicon);
            if (!mapicon.b().e()) continue;
            ++this.s;
        }
    }

    public Iterable<MapIcon> f() {
        return this.q.values();
    }

    public boolean b(int iconCount) {
        return this.s >= iconCount;
    }

    public class WorldMapHumanTracker {
        public final EntityHuman a;
        private boolean d = true;
        private int e;
        private int f;
        private int g = 127;
        private int h = 127;
        private boolean i = true;
        private int j;
        public int b;

        private void addSeenPlayers(Collection<MapIcon> icons) {
            Player player = (Player)this.a.getBukkitEntity();
            WorldMap.this.q.forEach((name, mapIcon) -> {
                Player other = Bukkit.getPlayerExact((String)name);
                if (other == null || player.canSee(other)) {
                    icons.add((MapIcon)mapIcon);
                }
            });
        }

        private boolean shouldUseVanillaMap() {
            return WorldMap.this.mapView.getRenderers().size() == 1 && WorldMap.this.mapView.getRenderers().get(0).getClass() == CraftMapRenderer.class;
        }

        WorldMapHumanTracker(EntityHuman entityhuman) {
            this.a = entityhuman;
        }

        private b createPatch(byte[] buffer) {
            int i2 = this.e;
            int j2 = this.f;
            int k2 = this.g + 1 - this.e;
            int l2 = this.h + 1 - this.f;
            byte[] abyte = new byte[k2 * l2];
            for (int i1 = 0; i1 < k2; ++i1) {
                for (int j1 = 0; j1 < l2; ++j1) {
                    abyte[i1 + j1 * k2] = buffer[i2 + i1 + (j2 + j1) * 128];
                }
            }
            return new b(i2, j2, k2, l2, abyte);
        }

        @Nullable
        Packet<?> a(int mapId) {
            ArrayList<MapIcon> collection;
            b worldmap_b;
            RenderData render;
            if (!this.d && this.j % 5 != 0) {
                ++this.j;
                return null;
            }
            boolean vanillaMaps = this.shouldUseVanillaMap();
            RenderData renderData = render = !vanillaMaps ? WorldMap.this.mapView.render((CraftPlayer)this.a.getBukkitEntity()) : WorldMap.this.vanillaRender;
            if (this.d) {
                this.d = false;
                worldmap_b = this.createPatch(render.buffer);
            } else {
                worldmap_b = null;
            }
            if (this.j++ % 5 == 0) {
                this.i = false;
                ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
                if (vanillaMaps) {
                    this.addSeenPlayers(icons);
                }
                for (MapCursor cursor : render.cursors) {
                    if (!cursor.isVisible()) continue;
                    icons.add(new MapIcon(MapIcon.Type.a(cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), PaperAdventure.asVanilla(cursor.caption())));
                }
                collection = icons;
            } else {
                collection = null;
            }
            return collection == null && worldmap_b == null ? null : new PacketPlayOutMap(mapId, WorldMap.this.f, WorldMap.this.h, collection, worldmap_b);
        }

        void a(int startX, int startZ) {
            if (this.d) {
                this.e = Math.min(this.e, startX);
                this.f = Math.min(this.f, startZ);
                this.g = Math.max(this.g, startX);
                this.h = Math.max(this.h, startZ);
            } else {
                this.d = true;
                this.e = startX;
                this.f = startZ;
                this.g = startX;
                this.h = startZ;
            }
        }

        private void b() {
            this.i = true;
        }
    }

    public static class b {
        public final int a;
        public final int b;
        public final int c;
        public final int d;
        public final byte[] e;

        public b(int startX, int startZ, int width, int height, byte[] colors) {
            this.a = startX;
            this.b = startZ;
            this.c = width;
            this.d = height;
            this.e = colors;
        }

        public void a(WorldMap mapState) {
            for (int i2 = 0; i2 < this.c; ++i2) {
                for (int j2 = 0; j2 < this.d; ++j2) {
                    mapState.b(this.a + i2, this.b + j2, this.e[i2 + j2 * this.c]);
                }
            }
        }
    }
}

