/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.GeneratorSettings;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.LevelVersion;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimerQueue;
import net.minecraft.world.level.timers.CustomFunctionCallbackTimers;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.slf4j.Logger;

public class WorldDataServer
implements IWorldDataServer,
SaveData {
    private static final Logger e = LogUtils.getLogger();
    protected static final String a = "Player";
    protected static final String b = "WorldGenSettings";
    public WorldSettings f;
    private final WorldOptions g;
    private final a h;
    private final Lifecycle i;
    private int j;
    private int k;
    private int l;
    private float m;
    private long n;
    private long o;
    @Nullable
    private final DataFixer p;
    private final int q;
    private boolean r;
    @Nullable
    private NBTTagCompound s;
    private final int t;
    private int u;
    private boolean v;
    private int w;
    private boolean x;
    private int y;
    private boolean z;
    private boolean A;
    private WorldBorder.c B;
    private NBTTagCompound C;
    @Nullable
    private NBTTagCompound D;
    private int E;
    private int F;
    @Nullable
    private UUID G;
    private final Set<String> H;
    private boolean I;
    private final CustomFunctionCallbackTimerQueue<MinecraftServer> J;
    public IRegistry<WorldDimension> customDimensions;
    private WorldServer world;
    protected NBTBase pdc;

    public void setWorld(WorldServer world) {
        if (this.world != null) {
            return;
        }
        this.world = world;
        world.getWorld().readBukkitValues(this.pdc);
        this.pdc = null;
    }

    private WorldDataServer(@Nullable DataFixer dataFixer, int dataVersion, @Nullable NBTTagCompound playerData, boolean modded, int spawnX, int spawnY, int spawnZ, float spawnAngle, long time, long timeOfDay, int version, int clearWeatherTime, int rainTime, boolean raining, int thunderTime, boolean thundering, boolean initialized, boolean difficultyLocked, WorldBorder.c worldBorder, int wanderingTraderSpawnDelay, int wanderingTraderSpawnChance, @Nullable UUID wanderingTraderId, Set<String> serverBrands, CustomFunctionCallbackTimerQueue<MinecraftServer> scheduledEvents, @Nullable NBTTagCompound customBossEvents, NBTTagCompound dragonFight, WorldSettings levelInfo, WorldOptions generatorOptions, a specialProperty, Lifecycle lifecycle) {
        this.p = dataFixer;
        this.I = modded;
        this.j = spawnX;
        this.k = spawnY;
        this.l = spawnZ;
        this.m = spawnAngle;
        this.n = time;
        this.o = timeOfDay;
        this.t = version;
        this.u = clearWeatherTime;
        this.w = rainTime;
        this.v = raining;
        this.y = thunderTime;
        this.x = thundering;
        this.z = initialized;
        this.A = difficultyLocked;
        this.B = worldBorder;
        this.E = wanderingTraderSpawnDelay;
        this.F = wanderingTraderSpawnChance;
        this.G = wanderingTraderId;
        this.H = serverBrands;
        this.s = playerData;
        this.q = dataVersion;
        this.J = scheduledEvents;
        this.D = customBossEvents;
        this.C = dragonFight;
        this.f = levelInfo;
        this.g = generatorOptions;
        this.h = specialProperty;
        this.i = lifecycle;
    }

    public WorldDataServer(WorldSettings levelInfo, WorldOptions generatorOptions, a worlddataserver_a, Lifecycle lifecycle) {
        this(null, SharedConstants.b().d().c(), null, false, 0, 0, 0, 0.0f, 0L, 0L, 19133, 0, 0, false, 0, false, false, false, WorldBorder.e, 0, 0, null, Sets.newLinkedHashSet(), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a), null, new NBTTagCompound(), levelInfo.h(), generatorOptions, worlddataserver_a, lifecycle);
    }

    public static <T> WorldDataServer a(Dynamic<T> dynamic, DataFixer dataFixer, int dataVersion, @Nullable NBTTagCompound playerData, WorldSettings levelInfo, LevelVersion saveVersionInfo, a specialProperty, WorldOptions generatorOptions, Lifecycle lifecycle) {
        long j2 = dynamic.get("Time").asLong(0L);
        NBTTagCompound nbttagcompound1 = (NBTTagCompound)dynamic.get("DragonFight").result().orElseGet(() -> dynamic.get("DimensionData").get("1").get("DragonFight").orElseEmptyMap()).convert(DynamicOpsNBT.a).getValue();
        return new WorldDataServer(dataFixer, dataVersion, playerData, dynamic.get("WasModded").asBoolean(false), dynamic.get("SpawnX").asInt(0), dynamic.get("SpawnY").asInt(0), dynamic.get("SpawnZ").asInt(0), dynamic.get("SpawnAngle").asFloat(0.0f), j2, dynamic.get("DayTime").asLong(j2), saveVersionInfo.a(), dynamic.get("clearWeatherTime").asInt(0), dynamic.get("rainTime").asInt(0), dynamic.get("raining").asBoolean(false), dynamic.get("thunderTime").asInt(0), dynamic.get("thundering").asBoolean(false), dynamic.get("initialized").asBoolean(true), dynamic.get("DifficultyLocked").asBoolean(false), WorldBorder.c.a(dynamic, WorldBorder.e), dynamic.get("WanderingTraderSpawnDelay").asInt(0), dynamic.get("WanderingTraderSpawnChance").asInt(0), dynamic.get("WanderingTraderId").read(UUIDUtil.a).result().orElse(null), dynamic.get("ServerBrands").asStream().flatMap(dynamic1 -> dynamic1.asString().result().stream()).collect(Collectors.toCollection(Sets::newLinkedHashSet)), new CustomFunctionCallbackTimerQueue<MinecraftServer>(CustomFunctionCallbackTimers.a, dynamic.get("ScheduledEvents").asStream()), (NBTTagCompound)dynamic.get("CustomBossEvents").orElseEmptyMap().getValue(), nbttagcompound1, levelInfo, generatorOptions, specialProperty, lifecycle);
    }

    @Override
    public NBTTagCompound a(IRegistryCustom registryManager, @Nullable NBTTagCompound playerNbt) {
        this.M();
        if (playerNbt == null) {
            playerNbt = this.s;
        }
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        this.a(registryManager, nbttagcompound1, playerNbt);
        return nbttagcompound1;
    }

    private void a(IRegistryCustom registryManager, NBTTagCompound levelNbt, @Nullable NBTTagCompound playerNbt) {
        NBTTagList nbttaglist = new NBTTagList();
        Stream<NBTTagString> stream = this.H.stream().map(NBTTagString::a);
        Objects.requireNonNull(nbttaglist);
        stream.forEach(nbttaglist::add);
        levelNbt.a("ServerBrands", nbttaglist);
        levelNbt.a("WasModded", this.I);
        NBTTagCompound nbttagcompound2 = new NBTTagCompound();
        nbttagcompound2.a("Name", SharedConstants.b().c());
        nbttagcompound2.a("Id", SharedConstants.b().d().c());
        nbttagcompound2.a("Snapshot", !SharedConstants.b().g());
        nbttagcompound2.a("Series", SharedConstants.b().d().b());
        levelNbt.a("Version", nbttagcompound2);
        GameProfileSerializer.g(levelNbt);
        RegistryOps<NBTBase> dynamicops = RegistryOps.a(DynamicOpsNBT.a, registryManager);
        DataResult<NBTBase> dataresult = GeneratorSettings.a(dynamicops, this.g, new WorldDimensions(this.customDimensions != null ? this.customDimensions : registryManager.d(Registries.aG)));
        Logger logger = e;
        Objects.requireNonNull(logger);
        dataresult.resultOrPartial(SystemUtils.a("WorldGenSettings: ", arg_0 -> ((Logger)logger).error(arg_0))).ifPresent(nbtbase -> levelNbt.a(b, (NBTBase)nbtbase));
        levelNbt.a("GameType", this.f.b().a());
        levelNbt.a("SpawnX", this.j);
        levelNbt.a("SpawnY", this.k);
        levelNbt.a("SpawnZ", this.l);
        levelNbt.a("SpawnAngle", this.m);
        levelNbt.a("Time", this.n);
        levelNbt.a("DayTime", this.o);
        levelNbt.a("LastPlayed", SystemUtils.d());
        levelNbt.a("LevelName", this.f.a());
        levelNbt.a("version", 19133);
        levelNbt.a("clearWeatherTime", this.u);
        levelNbt.a("rainTime", this.w);
        levelNbt.a("raining", this.v);
        levelNbt.a("thunderTime", this.y);
        levelNbt.a("thundering", this.x);
        levelNbt.a("hardcore", this.f.c());
        levelNbt.a("allowCommands", this.f.e());
        levelNbt.a("initialized", this.z);
        this.B.a(levelNbt);
        levelNbt.a("Difficulty", (byte)this.f.d().a());
        levelNbt.a("DifficultyLocked", this.A);
        levelNbt.a("GameRules", this.f.f().a());
        levelNbt.a("DragonFight", this.C);
        if (playerNbt != null) {
            levelNbt.a(a, playerNbt);
        }
        DataResult dataresult1 = WorldDataConfiguration.b.encodeStart((DynamicOps)DynamicOpsNBT.a, (Object)this.f.g());
        dataresult1.get().ifLeft(nbtbase -> levelNbt.a((NBTTagCompound)nbtbase)).ifRight(partialresult -> e.warn("Failed to encode configuration {}", (Object)partialresult.message()));
        if (this.D != null) {
            levelNbt.a("CustomBossEvents", this.D);
        }
        levelNbt.a("ScheduledEvents", this.J.b());
        levelNbt.a("WanderingTraderSpawnDelay", this.E);
        levelNbt.a("WanderingTraderSpawnChance", this.F);
        if (this.G != null) {
            levelNbt.a("WanderingTraderId", this.G);
        }
        levelNbt.a("Bukkit.Version", Bukkit.getName() + "/" + Bukkit.getVersion() + "/" + Bukkit.getBukkitVersion());
        this.world.getWorld().storeBukkitValues(levelNbt);
    }

    @Override
    public int a() {
        return this.j;
    }

    @Override
    public int b() {
        return this.k;
    }

    @Override
    public int c() {
        return this.l;
    }

    @Override
    public float d() {
        return this.m;
    }

    @Override
    public long e() {
        return this.n;
    }

    @Override
    public long f() {
        return this.o;
    }

    private void M() {
        if (!this.r && this.s != null) {
            if (this.q < SharedConstants.b().d().c()) {
                if (this.p == null) {
                    throw SystemUtils.b(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
                }
                this.s = DataFixTypes.b.a(this.p, this.s, this.q);
            }
            this.r = true;
        }
    }

    @Override
    public NBTTagCompound y() {
        this.M();
        return this.s;
    }

    @Override
    public void b(int spawnX) {
        this.j = spawnX;
    }

    @Override
    public void c(int spawnY) {
        this.k = spawnY;
    }

    @Override
    public void d(int spawnZ) {
        this.l = spawnZ;
    }

    @Override
    public void a(float spawnAngle) {
        this.m = spawnAngle;
    }

    @Override
    public void a(long time) {
        this.n = time;
    }

    @Override
    public void b(long timeOfDay) {
        this.o = timeOfDay;
    }

    @Override
    public void a(BlockPosition pos, float angle) {
        this.j = pos.u();
        this.k = pos.v();
        this.l = pos.w();
        this.m = angle;
    }

    @Override
    public String g() {
        return this.f.a();
    }

    @Override
    public int z() {
        return this.t;
    }

    @Override
    public int h() {
        return this.u;
    }

    @Override
    public void a(int clearWeatherTime) {
        this.u = clearWeatherTime;
    }

    @Override
    public boolean i() {
        return this.x;
    }

    @Override
    public void a(boolean thundering) {
        this.setThundering(thundering, ThunderChangeEvent.Cause.UNKNOWN);
    }

    public void setThundering(boolean thundering, ThunderChangeEvent.Cause cause) {
        if (this.x == thundering) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            ThunderChangeEvent thunder = new ThunderChangeEvent(world, thundering, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)thunder);
            if (thunder.isCancelled()) {
                return;
            }
        }
        this.x = thundering;
    }

    @Override
    public int j() {
        return this.y;
    }

    @Override
    public void e(int thunderTime) {
        this.y = thunderTime;
    }

    @Override
    public boolean k() {
        return this.v;
    }

    @Override
    public void b(boolean raining) {
        this.setRaining(raining, WeatherChangeEvent.Cause.UNKNOWN);
    }

    public void setRaining(boolean raining, WeatherChangeEvent.Cause cause) {
        if (this.v == raining) {
            return;
        }
        World world = Bukkit.getWorld((String)this.g());
        if (world != null) {
            WeatherChangeEvent weather = new WeatherChangeEvent(world, raining, cause);
            Bukkit.getServer().getPluginManager().callEvent((Event)weather);
            if (weather.isCancelled()) {
                return;
            }
        }
        this.v = raining;
    }

    @Override
    public int l() {
        return this.w;
    }

    @Override
    public void f(int rainTime) {
        this.w = rainTime;
    }

    @Override
    public EnumGamemode m() {
        return this.f.b();
    }

    @Override
    public void a(EnumGamemode gameMode) {
        this.f = this.f.a(gameMode);
    }

    @Override
    public boolean n() {
        return this.f.c();
    }

    @Override
    public boolean o() {
        return this.f.e();
    }

    @Override
    public boolean p() {
        return this.z;
    }

    @Override
    public void c(boolean initialized) {
        this.z = initialized;
    }

    @Override
    public GameRules q() {
        return this.f.f();
    }

    @Override
    public WorldBorder.c r() {
        return this.B;
    }

    @Override
    public void a(WorldBorder.c worldBorder) {
        this.B = worldBorder;
    }

    @Override
    public EnumDifficulty s() {
        return this.f.d();
    }

    @Override
    public void a(EnumDifficulty difficulty) {
        this.f = this.f.a(difficulty);
        PacketPlayOutServerDifficulty packet = new PacketPlayOutServerDifficulty(this.s(), this.t());
        for (EntityPlayer player : this.world.v()) {
            player.b.a(packet);
        }
    }

    @Override
    public boolean t() {
        return this.A;
    }

    @Override
    public void d(boolean difficultyLocked) {
        this.A = difficultyLocked;
    }

    @Override
    public CustomFunctionCallbackTimerQueue<MinecraftServer> u() {
        return this.J;
    }

    @Override
    public void a(CrashReportSystemDetails reportSection, LevelHeightAccessor world) {
        IWorldDataServer.super.a(reportSection, world);
        SaveData.super.a(reportSection);
    }

    @Override
    public WorldOptions A() {
        return this.g;
    }

    @Override
    public boolean B() {
        return this.h == net.minecraft.world.level.storage.WorldDataServer$a.b;
    }

    @Override
    public boolean C() {
        return this.h == net.minecraft.world.level.storage.WorldDataServer$a.c;
    }

    @Override
    public Lifecycle D() {
        return this.i;
    }

    @Override
    public NBTTagCompound E() {
        return this.C;
    }

    @Override
    public void a(NBTTagCompound dragonFight) {
        this.C = dragonFight;
    }

    @Override
    public WorldDataConfiguration F() {
        return this.f.g();
    }

    @Override
    public void a(WorldDataConfiguration dataConfiguration) {
        this.f = this.f.a(dataConfiguration);
    }

    @Override
    @Nullable
    public NBTTagCompound G() {
        return this.D;
    }

    @Override
    public void b(@Nullable NBTTagCompound customBossEvents) {
        this.D = customBossEvents;
    }

    @Override
    public int v() {
        return this.E;
    }

    @Override
    public void g(int wanderingTraderSpawnDelay) {
        this.E = wanderingTraderSpawnDelay;
    }

    @Override
    public int w() {
        return this.F;
    }

    @Override
    public void h(int wanderingTraderSpawnChance) {
        this.F = wanderingTraderSpawnChance;
    }

    @Override
    @Nullable
    public UUID x() {
        return this.G;
    }

    @Override
    public void a(UUID wanderingTraderId) {
        this.G = wanderingTraderId;
    }

    @Override
    public void a(String brand, boolean modded) {
        this.H.add(brand);
        this.I |= modded;
    }

    @Override
    public boolean H() {
        return this.I;
    }

    @Override
    public Set<String> I() {
        return ImmutableSet.copyOf(this.H);
    }

    @Override
    public IWorldDataServer J() {
        return this;
    }

    @Override
    public WorldSettings K() {
        return this.f.h();
    }

    public void checkName(String name) {
        if (!this.f.a.equals(name)) {
            this.f.a = name;
        }
    }

    @Deprecated
    public static enum a {
        a,
        b,
        c;

    }
}

