/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceDataJson;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootPredicateManager;
import net.minecraft.world.level.storage.loot.LootSerialization;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.LootTableRegistry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class ItemModifierManager
extends ResourceDataJson {
    private static final Logger a = LogUtils.getLogger();
    private static final Gson b = LootSerialization.b().create();
    private final LootPredicateManager c;
    private final LootTableRegistry d;
    private Map<MinecraftKey, LootItemFunction> e = ImmutableMap.of();

    public ItemModifierManager(LootPredicateManager lootConditionManager, LootTableRegistry lootManager) {
        super(b, "item_modifiers");
        this.c = lootConditionManager;
        this.d = lootManager;
    }

    @Nullable
    public LootItemFunction a(MinecraftKey id) {
        return this.e.get(id);
    }

    public LootItemFunction a(MinecraftKey id, LootItemFunction fallback) {
        return this.e.getOrDefault(id, fallback);
    }

    @Override
    @Override
    protected void a(Map<MinecraftKey, JsonElement> prepared, IResourceManager manager, GameProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        prepared.forEach((id, json) -> {
            try {
                if (json.isJsonArray()) {
                    LootItemFunction[] lootItemFunctions = (LootItemFunction[])b.fromJson(json, LootItemFunction[].class);
                    builder.put(id, (Object)new a(lootItemFunctions));
                } else {
                    LootItemFunction lootItemFunction = (LootItemFunction)b.fromJson(json, LootItemFunction.class);
                    builder.put(id, (Object)lootItemFunction);
                }
            }
            catch (Exception exception) {
                a.error("Couldn't parse item modifier {}", id, (Object)exception);
            }
        });
        ImmutableMap map = builder.build();
        LootCollector validationContext = new LootCollector(LootContextParameterSets.l, this.c::a, this.d::a);
        map.forEach((id, function) -> function.a(validationContext));
        validationContext.a().forEach((name, message) -> a.warn("Found item modifier validation problem in {}: {}", name, message));
        this.e = map;
    }

    public Set<MinecraftKey> a() {
        return Collections.unmodifiableSet(this.e.keySet());
    }

    static class a
    implements LootItemFunction {
        protected final LootItemFunction[] a;
        private final BiFunction<ItemStack, LootTableInfo, ItemStack> b;

        public a(LootItemFunction[] functions) {
            this.a = functions;
            this.b = LootItemFunctions.a(functions);
        }

        @Override
        public ItemStack a(ItemStack itemStack, LootTableInfo lootContext) {
            return this.b.apply(itemStack, lootContext);
        }

        @Override
        @Override
        public LootItemFunctionType a() {
            throw new UnsupportedOperationException();
        }

        @Override
        public /* synthetic */ Object apply(Object object, Object object2) {
            return this.a((ItemStack)object, (LootTableInfo)object2);
        }
    }
}

