/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootItemUser;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootCollector {
    private final Multimap<String, String> a;
    private final Supplier<String> b;
    private final LootContextParameterSet c;
    private final Function<MinecraftKey, LootItemCondition> d;
    private final Set<MinecraftKey> e;
    private final Function<MinecraftKey, LootTable> f;
    private final Set<MinecraftKey> g;
    private String h;

    public LootCollector(LootContextParameterSet contextType, Function<MinecraftKey, LootItemCondition> conditionGetter, Function<MinecraftKey, LootTable> tableFactory) {
        this((Multimap<String, String>)HashMultimap.create(), () -> "", contextType, conditionGetter, (Set<MinecraftKey>)ImmutableSet.of(), tableFactory, (Set<MinecraftKey>)ImmutableSet.of());
    }

    public LootCollector(Multimap<String, String> messages, Supplier<String> nameFactory, LootContextParameterSet contextType, Function<MinecraftKey, LootItemCondition> conditionGetter, Set<MinecraftKey> conditions, Function<MinecraftKey, LootTable> tableGetter, Set<MinecraftKey> tables) {
        this.a = messages;
        this.b = nameFactory;
        this.c = contextType;
        this.d = conditionGetter;
        this.e = conditions;
        this.f = tableGetter;
        this.g = tables;
    }

    private String b() {
        if (this.h == null) {
            this.h = this.b.get();
        }
        return this.h;
    }

    public void a(String message) {
        this.a.put((Object)this.b(), (Object)message);
    }

    public LootCollector b(String name) {
        return new LootCollector(this.a, () -> this.b() + name, this.c, this.d, this.e, this.f, this.g);
    }

    public LootCollector a(String name, MinecraftKey id) {
        ImmutableSet immutableSet = ImmutableSet.builder().addAll(this.g).add((Object)id).build();
        return new LootCollector(this.a, () -> this.b() + name, this.c, this.d, this.e, this.f, (Set<MinecraftKey>)immutableSet);
    }

    public LootCollector b(String name, MinecraftKey id) {
        ImmutableSet immutableSet = ImmutableSet.builder().addAll(this.e).add((Object)id).build();
        return new LootCollector(this.a, () -> this.b() + name, this.c, this.d, (Set<MinecraftKey>)immutableSet, this.f, this.g);
    }

    public boolean a(MinecraftKey id) {
        return this.g.contains(id);
    }

    public boolean b(MinecraftKey id) {
        return this.e.contains(id);
    }

    public Multimap<String, String> a() {
        return ImmutableMultimap.copyOf(this.a);
    }

    public void a(LootItemUser contextAware) {
        this.c.a(this, contextAware);
    }

    @Nullable
    public LootTable c(MinecraftKey id) {
        return this.f.apply(id);
    }

    @Nullable
    public LootItemCondition d(MinecraftKey id) {
        return this.d.apply(id);
    }

    public LootCollector a(LootContextParameterSet contextType) {
        return new LootCollector(this.a, this.b, contextType, this.d, this.e, this.f, this.g);
    }
}

