/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionCopyState
extends LootItemFunctionConditional {
    final Block a;
    final Set<IBlockState<?>> b;

    LootItemFunctionCopyState(LootItemCondition[] conditions, Block block, Set<IBlockState<?>> properties) {
        super(conditions);
        this.a = block;
        this.b = properties;
    }

    @Override
    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.w;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return ImmutableSet.of(LootContextParameters.g);
    }

    @Override
    @Override
    protected ItemStack a(ItemStack stack, LootTableInfo context) {
        IBlockData blockState = context.c(LootContextParameters.g);
        if (blockState != null) {
            NBTTagCompound compoundTag3;
            NBTTagCompound compoundTag = stack.v();
            if (compoundTag.b("BlockStateTag", 10)) {
                NBTTagCompound compoundTag2 = compoundTag.p("BlockStateTag");
            } else {
                compoundTag3 = new NBTTagCompound();
                compoundTag.a("BlockStateTag", compoundTag3);
            }
            this.b.stream().filter(blockState::b).forEach(property -> compoundTag3.a(property.f(), LootItemFunctionCopyState.a(blockState, property)));
        }
        return stack;
    }

    public static a a(Block block) {
        return new a(block);
    }

    private static <T extends Comparable<T>> String a(IBlockData state, IBlockState<T> property) {
        T comparable = state.c(property);
        return property.a(comparable);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Block a;
        private final Set<IBlockState<?>> b = Sets.newHashSet();

        a(Block block) {
            this.a = block;
        }

        public a a(IBlockState<?> property) {
            if (!this.a.n().d().contains(property)) {
                throw new IllegalStateException("Property " + property + " is not present on block " + this.a);
            }
            this.b.add(property);
            return this;
        }

        @Override
        protected a a() {
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionCopyState(this.g(), this.a, this.b);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionCopyState> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionCopyState object, JsonSerializationContext context) {
            super.a(json, object, context);
            json.addProperty("block", BuiltInRegistries.f.b(object.a).toString());
            JsonArray jsonArray = new JsonArray();
            object.b.forEach(property -> jsonArray.add(property.f()));
            json.add("properties", (JsonElement)jsonArray);
        }

        @Override
        public LootItemFunctionCopyState a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.h(jsonObject, "block"));
            Block block = (Block)BuiltInRegistries.f.b(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Can't find block " + resourceLocation));
            BlockStateList<Block, IBlockData> stateDefinition = block.n();
            HashSet set = Sets.newHashSet();
            JsonArray jsonArray = ChatDeserializer.a(jsonObject, "properties", null);
            if (jsonArray != null) {
                jsonArray.forEach(property -> set.add(stateDefinition.a(ChatDeserializer.a(property, "property"))));
            }
            return new LootItemFunctionCopyState(lootItemConditions, block, set);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

