/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootItemFunctionSetAttribute
extends LootItemFunctionConditional {
    final List<b> a;

    LootItemFunctionSetAttribute(LootItemCondition[] conditions, List<b> attributes) {
        super(conditions);
        this.a = ImmutableList.copyOf(attributes);
    }

    @Override
    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.j;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return (Set)this.a.stream().flatMap(attribute -> attribute.d.b().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        RandomSource randomSource = context.a();
        for (b modifier : this.a) {
            UUID uUID = modifier.e;
            if (uUID == null) {
                uUID = UUID.randomUUID();
            }
            EnumItemSlot equipmentSlot = SystemUtils.a(modifier.f, randomSource);
            stack.a(modifier.b, new AttributeModifier(uUID, modifier.a, (double)modifier.d.b(context), modifier.c), equipmentSlot);
        }
        return stack;
    }

    public static c a(String name, AttributeBase attribute, AttributeModifier.Operation operation, NumberProvider amountRange) {
        return new c(name, attribute, operation, amountRange);
    }

    public static a c() {
        return new a();
    }

    static class b {
        final String a;
        final AttributeBase b;
        final AttributeModifier.Operation c;
        final NumberProvider d;
        @Nullable
        final UUID e;
        final EnumItemSlot[] f;

        b(String name, AttributeBase attribute, AttributeModifier.Operation operation, NumberProvider amount, EnumItemSlot[] slots, @Nullable UUID id) {
            this.a = name;
            this.b = attribute;
            this.c = operation;
            this.d = amount;
            this.e = id;
            this.f = slots;
        }

        public JsonObject a(JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", this.a);
            jsonObject.addProperty("attribute", BuiltInRegistries.u.b(this.b).toString());
            jsonObject.addProperty("operation", net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute$b.a(this.c));
            jsonObject.add("amount", context.serialize((Object)this.d));
            if (this.e != null) {
                jsonObject.addProperty("id", this.e.toString());
            }
            if (this.f.length == 1) {
                jsonObject.addProperty("slot", this.f[0].d());
            } else {
                JsonArray jsonArray = new JsonArray();
                for (EnumItemSlot equipmentSlot : this.f) {
                    jsonArray.add((JsonElement)new JsonPrimitive(equipmentSlot.d()));
                }
                jsonObject.add("slot", (JsonElement)jsonArray);
            }
            return jsonObject;
        }

        /*
         * WARNING - void declaration
         */
        public static b a(JsonObject json, JsonDeserializationContext context) {
            void equipmentSlots3;
            String string = ChatDeserializer.h(json, "name");
            MinecraftKey resourceLocation = new MinecraftKey(ChatDeserializer.h(json, "attribute"));
            AttributeBase attribute = BuiltInRegistries.u.a(resourceLocation);
            if (attribute == null) {
                throw new JsonSyntaxException("Unknown attribute: " + resourceLocation);
            }
            AttributeModifier.Operation operation = net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetAttribute$b.a(ChatDeserializer.h(json, "operation"));
            NumberProvider numberProvider = ChatDeserializer.a(json, "amount", context, NumberProvider.class);
            UUID uUID = null;
            if (ChatDeserializer.a(json, "slot")) {
                EnumItemSlot[] equipmentSlots = new EnumItemSlot[]{EnumItemSlot.a(ChatDeserializer.h(json, "slot"))};
            } else if (ChatDeserializer.d(json, "slot")) {
                JsonArray jsonArray = ChatDeserializer.u(json, "slot");
                EnumItemSlot[] equipmentSlots2 = new EnumItemSlot[jsonArray.size()];
                int i2 = 0;
                for (JsonElement jsonElement : jsonArray) {
                    equipmentSlots2[i2++] = EnumItemSlot.a(ChatDeserializer.a(jsonElement, "slot"));
                }
                if (equipmentSlots2.length == 0) {
                    throw new JsonSyntaxException("Invalid attribute modifier slot; must contain at least one entry.");
                }
            } else {
                throw new JsonSyntaxException("Invalid or missing attribute modifier slot; must be either string or array of strings.");
            }
            if (json.has("id")) {
                String string2 = ChatDeserializer.h(json, "id");
                try {
                    uUID = UUID.fromString(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new JsonSyntaxException("Invalid attribute modifier id '" + string2 + "' (must be UUID format, with dashes)");
                }
            }
            return new b(string, attribute, operation, numberProvider, (EnumItemSlot[])equipmentSlots3, uUID);
        }

        private static String a(AttributeModifier.Operation operation) {
            switch (operation) {
                case a: {
                    return "addition";
                }
                case b: {
                    return "multiply_base";
                }
                case c: {
                    return "multiply_total";
                }
            }
            throw new IllegalArgumentException("Unknown operation " + operation);
        }

        private static AttributeModifier.Operation a(String name) {
            switch (name) {
                case "addition": {
                    return AttributeModifier.Operation.a;
                }
                case "multiply_base": {
                    return AttributeModifier.Operation.b;
                }
                case "multiply_total": {
                    return AttributeModifier.Operation.c;
                }
            }
            throw new JsonSyntaxException("Unknown attribute modifier operation " + name);
        }
    }

    public static class c {
        private final String a;
        private final AttributeBase b;
        private final AttributeModifier.Operation c;
        private final NumberProvider d;
        @Nullable
        private UUID e;
        private final Set<EnumItemSlot> f = EnumSet.noneOf(EnumItemSlot.class);

        public c(String name, AttributeBase attribute, AttributeModifier.Operation operation, NumberProvider amount) {
            this.a = name;
            this.b = attribute;
            this.c = operation;
            this.d = amount;
        }

        public c a(EnumItemSlot slot) {
            this.f.add(slot);
            return this;
        }

        public c a(UUID uuid) {
            this.e = uuid;
            return this;
        }

        public b a() {
            return new b(this.a, this.b, this.c, this.d, this.f.toArray(new EnumItemSlot[0]), this.e);
        }
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final List<b> a = Lists.newArrayList();

        @Override
        protected a a() {
            return this;
        }

        public a a(c attribute) {
            this.a.add(attribute.a());
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionSetAttribute(this.g(), this.a);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }

    public static class d
    extends LootItemFunctionConditional.c<LootItemFunctionSetAttribute> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionSetAttribute object, JsonSerializationContext context) {
            super.a(json, object, context);
            JsonArray jsonArray = new JsonArray();
            for (b modifier : object.a) {
                jsonArray.add((JsonElement)modifier.a(context));
            }
            json.add("modifiers", (JsonElement)jsonArray);
        }

        @Override
        public LootItemFunctionSetAttribute a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            JsonArray jsonArray = ChatDeserializer.u(jsonObject, "modifiers");
            ArrayList list = Lists.newArrayListWithExpectedSize((int)jsonArray.size());
            for (JsonElement jsonElement : jsonArray) {
                list.add(b.a(ChatDeserializer.m(jsonElement, "modifier"), jsonDeserializationContext));
            }
            if (list.isEmpty()) {
                throw new JsonSyntaxException("Invalid attribute modifiers array; cannot be empty");
            }
            return new LootItemFunctionSetAttribute(lootItemConditions, list);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

