/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemSuspiciousStew;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class LootItemFunctionSetStewEffect
extends LootItemFunctionConditional {
    final Map<MobEffectList, NumberProvider> a;

    LootItemFunctionSetStewEffect(LootItemCondition[] conditions, Map<MobEffectList, NumberProvider> effects) {
        super(conditions);
        this.a = ImmutableMap.copyOf(effects);
    }

    @Override
    @Override
    public LootItemFunctionType a() {
        return LootItemFunctions.m;
    }

    @Override
    @Override
    public Set<LootContextParameter<?>> b() {
        return (Set)this.a.values().stream().flatMap(numberProvider -> numberProvider.b().stream()).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    @Override
    public ItemStack a(ItemStack stack, LootTableInfo context) {
        if (!stack.a(Items.uU) || this.a.isEmpty()) {
            return stack;
        }
        RandomSource randomSource = context.a();
        int i2 = randomSource.a(this.a.size());
        Map.Entry entry = (Map.Entry)Iterables.get(this.a.entrySet(), (int)i2);
        MobEffectList mobEffect = (MobEffectList)entry.getKey();
        int j2 = ((NumberProvider)entry.getValue()).a(context);
        if (!mobEffect.a()) {
            j2 *= 20;
        }
        ItemSuspiciousStew.a(stack, mobEffect, j2);
        return stack;
    }

    public static a c() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final Map<MobEffectList, NumberProvider> a = Maps.newLinkedHashMap();

        @Override
        protected a a() {
            return this;
        }

        public a a(MobEffectList effect, NumberProvider durationRange) {
            this.a.put(effect, durationRange);
            return this;
        }

        @Override
        @Override
        public LootItemFunction b() {
            return new LootItemFunctionSetStewEffect(this.g(), this.a);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a c() {
            return this.a();
        }
    }

    public static class b
    extends LootItemFunctionConditional.c<LootItemFunctionSetStewEffect> {
        @Override
        @Override
        public void a(JsonObject json, LootItemFunctionSetStewEffect object, JsonSerializationContext context) {
            super.a(json, object, context);
            if (!object.a.isEmpty()) {
                JsonArray jsonArray = new JsonArray();
                for (MobEffectList mobEffect : object.a.keySet()) {
                    JsonObject jsonObject = new JsonObject();
                    MinecraftKey resourceLocation = BuiltInRegistries.e.b(mobEffect);
                    if (resourceLocation == null) {
                        throw new IllegalArgumentException("Don't know how to serialize mob effect " + mobEffect);
                    }
                    jsonObject.add("type", (JsonElement)new JsonPrimitive(resourceLocation.toString()));
                    jsonObject.add("duration", context.serialize((Object)object.a.get(mobEffect)));
                    jsonArray.add((JsonElement)jsonObject);
                }
                json.add("effects", (JsonElement)jsonArray);
            }
        }

        @Override
        public LootItemFunctionSetStewEffect a(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext, LootItemCondition[] lootItemConditions) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            if (jsonObject.has("effects")) {
                JsonArray jsonArray = ChatDeserializer.u(jsonObject, "effects");
                for (JsonElement jsonElement : jsonArray) {
                    String string = ChatDeserializer.h(jsonElement.getAsJsonObject(), "type");
                    MobEffectList mobEffect = BuiltInRegistries.e.b(new MinecraftKey(string)).orElseThrow(() -> new JsonSyntaxException("Unknown mob effect '" + string + "'"));
                    NumberProvider numberProvider = ChatDeserializer.a(jsonElement.getAsJsonObject(), "duration", jsonDeserializationContext, NumberProvider.class);
                    map.put(mobEffect, numberProvider);
                }
            }
            return new LootItemFunctionSetStewEffect(lootItemConditions, map);
        }

        @Override
        public /* synthetic */ LootItemFunctionConditional b(JsonObject json, JsonDeserializationContext context, LootItemCondition[] conditions) {
            return this.a(json, context, conditions);
        }
    }
}

