/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import java.util.function.Predicate;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.JsonRegistry;
import net.minecraft.world.level.storage.loot.LootSerializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionAlternative;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityScore;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionInverted;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionKilledByPlayer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChanceWithLooting;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionSurvivesExplosion;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTableBonus;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTimeCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionWeatherCheck;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;

public class LootItemConditions {
    public static final LootItemConditionType a = LootItemConditions.a("inverted", new LootItemConditionInverted.a());
    public static final LootItemConditionType b = LootItemConditions.a("alternative", new LootItemConditionAlternative.b());
    public static final LootItemConditionType c = LootItemConditions.a("random_chance", new LootItemConditionRandomChance.a());
    public static final LootItemConditionType d = LootItemConditions.a("random_chance_with_looting", new LootItemConditionRandomChanceWithLooting.a());
    public static final LootItemConditionType e = LootItemConditions.a("entity_properties", new LootItemConditionEntityProperty.a());
    public static final LootItemConditionType f = LootItemConditions.a("killed_by_player", new LootItemConditionKilledByPlayer.a());
    public static final LootItemConditionType g = LootItemConditions.a("entity_scores", new LootItemConditionEntityScore.b());
    public static final LootItemConditionType h = LootItemConditions.a("block_state_property", new LootItemConditionBlockStateProperty.b());
    public static final LootItemConditionType i = LootItemConditions.a("match_tool", new LootItemConditionMatchTool.a());
    public static final LootItemConditionType j = LootItemConditions.a("table_bonus", new LootItemConditionTableBonus.a());
    public static final LootItemConditionType k = LootItemConditions.a("survives_explosion", new LootItemConditionSurvivesExplosion.a());
    public static final LootItemConditionType l = LootItemConditions.a("damage_source_properties", new LootItemConditionDamageSourceProperties.a());
    public static final LootItemConditionType m = LootItemConditions.a("location_check", new LootItemConditionLocationCheck.a());
    public static final LootItemConditionType n = LootItemConditions.a("weather_check", new LootItemConditionWeatherCheck.b());
    public static final LootItemConditionType o = LootItemConditions.a("reference", new LootItemConditionReference.a());
    public static final LootItemConditionType p = LootItemConditions.a("time_check", new LootItemConditionTimeCheck.b());
    public static final LootItemConditionType q = LootItemConditions.a("value_check", new ValueCheckCondition.a());

    private static LootItemConditionType a(String id, LootSerializer<? extends LootItemCondition> serializer) {
        return IRegistry.a(BuiltInRegistries.H, new MinecraftKey(id), new LootItemConditionType(serializer));
    }

    public static Object a() {
        return JsonRegistry.a(BuiltInRegistries.H, "condition", "condition", LootItemCondition::a).a();
    }

    public static <T> Predicate<T> a(Predicate<T>[] predicates2) {
        switch (predicates2.length) {
            case 0: {
                return predicates -> true;
            }
            case 1: {
                return predicates2[0];
            }
            case 2: {
                return predicates2[0].and(predicates2[1]);
            }
        }
        return operand -> {
            for (Predicate predicate : predicates2) {
                if (predicate.test(operand)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> b(Predicate<T>[] predicates2) {
        switch (predicates2.length) {
            case 0: {
                return predicates -> false;
            }
            case 1: {
                return predicates2[0];
            }
            case 2: {
                return predicates2[0].or(predicates2[1]);
            }
        }
        return operand -> {
            for (Predicate predicate : predicates2) {
                if (!predicate.test(operand)) continue;
                return true;
            }
            return false;
        };
    }
}

