/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.server.players.IpBanEntry;
import net.minecraft.server.players.IpBanList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_19_R3.CraftIpBanEntry;

public class CraftIpBanList
implements BanList {
    private final IpBanList list;

    public CraftIpBanList(IpBanList list) {
        this.list = list;
    }

    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        IpBanEntry entry = (IpBanEntry)this.list.b(target);
        if (entry == null) {
            return null;
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null");
        IpBanEntry entry = new IpBanEntry(target, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.a(entry);
        try {
            this.list.e();
        }
        catch (IOException ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Failed to save banned-ips.json, {0}", ex.getMessage());
        }
        return new CraftIpBanEntry(target, entry, this.list);
    }

    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String target : this.list.a()) {
            builder.add((Object)new CraftIpBanEntry(target, (IpBanEntry)this.list.b(target), this.list));
        }
        return builder.build();
    }

    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        return this.list.a(target);
    }

    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        this.list.c(target);
    }
}

