/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3;

import io.papermc.paper.world.structure.ConfiguredStructure;
import io.papermc.paper.world.structure.PaperConfiguredStructure;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_19_R3.generator.strucutre.CraftStructure;
import org.bukkit.craftbukkit.v1_19_R3.generator.strucutre.CraftStructureType;
import org.bukkit.craftbukkit.v1_19_R3.inventory.trim.CraftTrimMaterial;
import org.bukkit.craftbukkit.v1_19_R3.inventory.trim.CraftTrimPattern;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.generator.structure.Structure;

public class CraftRegistry<B extends Keyed, M>
implements Registry<B> {
    private final Map<NamespacedKey, B> cache = new HashMap<NamespacedKey, B>();
    private final IRegistry<M> minecraftRegistry;
    private final BiFunction<NamespacedKey, M, B> minecraftToBukkit;

    public static <B extends Keyed> Registry<?> createRegistry(Class<B> bukkitClass, IRegistryCustom registryHolder) {
        if (bukkitClass == Structure.class) {
            return new CraftRegistry<CraftStructure, net.minecraft.world.level.levelgen.structure.Structure>(registryHolder.d(Registries.ax), CraftStructure::new);
        }
        if (bukkitClass == org.bukkit.generator.structure.StructureType.class) {
            return new CraftRegistry<CraftStructureType, StructureType>(BuiltInRegistries.T, CraftStructureType::new);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimMaterial.class) {
            return new CraftRegistry<CraftTrimMaterial, TrimMaterial>(registryHolder.d(Registries.aB), CraftTrimMaterial::new);
        }
        if (bukkitClass == org.bukkit.inventory.meta.trim.TrimPattern.class) {
            return new CraftRegistry<CraftTrimPattern, TrimPattern>(registryHolder.d(Registries.aC), CraftTrimPattern::new);
        }
        if (bukkitClass == ConfiguredStructure.class) {
            return new PaperConfiguredStructure.LegacyRegistry(registryHolder.d(Registries.ax));
        }
        return null;
    }

    public CraftRegistry(IRegistry<M> minecraftRegistry, BiFunction<NamespacedKey, M, B> minecraftToBukkit) {
        this.minecraftRegistry = minecraftRegistry;
        this.minecraftToBukkit = minecraftToBukkit;
    }

    public B get(NamespacedKey namespacedKey) {
        Keyed cached = (Keyed)this.cache.get(namespacedKey);
        if (cached != null) {
            return (B)cached;
        }
        B bukkit = this.createBukkit(namespacedKey, this.minecraftRegistry.b(CraftNamespacedKey.toMinecraft(namespacedKey)).orElse(null));
        if (bukkit == null) {
            return null;
        }
        this.cache.put(namespacedKey, bukkit);
        return bukkit;
    }

    public Iterator<B> iterator() {
        return this.values().iterator();
    }

    public B createBukkit(NamespacedKey namespacedKey, M minecraft) {
        if (minecraft == null) {
            return null;
        }
        return (B)((Keyed)this.minecraftToBukkit.apply(namespacedKey, minecraft));
    }

    public Stream<B> values() {
        return this.minecraftRegistry.e().stream().map(minecraftKey -> this.get(CraftNamespacedKey.fromMinecraft(minecraftKey)));
    }
}

