/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block;

import com.google.common.base.Preconditions;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.block.BlockBell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBell;
import org.bukkit.World;
import org.bukkit.block.Bell;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;

public class CraftBell
extends CraftBlockEntityState<TileEntityBell>
implements Bell {
    public CraftBell(World world, TileEntityBell tileEntity) {
        super(world, tileEntity);
    }

    public boolean ring(Entity entity, BlockFace direction) {
        Preconditions.checkArgument((direction == null || direction.isCartesian() ? 1 : 0) != 0, (String)"direction must be cartesian, given %s", (Object)direction);
        TileEntity tileEntity = this.getTileEntityFromWorld();
        if (tileEntity == null) {
            return false;
        }
        net.minecraft.world.entity.Entity nmsEntity = entity != null ? ((CraftEntity)entity).getHandle() : null;
        EnumDirection enumDirection = CraftBlock.blockFaceToNotch(direction);
        return ((BlockBell)Blocks.nZ).a(nmsEntity, (net.minecraft.world.level.World)this.world.getHandle(), this.getPosition(), enumDirection);
    }

    public boolean ring(Entity entity) {
        return this.ring(entity, null);
    }

    public boolean ring(BlockFace direction) {
        return this.ring(null, direction);
    }

    public boolean ring() {
        return this.ring(null, null);
    }

    public boolean isShaking() {
        return ((TileEntityBell)this.getSnapshot()).b;
    }

    public int getShakingTicks() {
        return ((TileEntityBell)this.getSnapshot()).a;
    }

    public boolean isResonating() {
        return ((TileEntityBell)this.getSnapshot()).n;
    }

    public int getResonatingTicks() {
        return this.isResonating() ? ((TileEntityBell)this.getSnapshot()).a : 0;
    }
}

