/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.block;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.papermc.paper.adventure.PaperAdventure;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.block.entity.TileEntitySign;
import org.bukkit.DyeColor;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;

public class CraftSign<T extends TileEntitySign>
extends CraftBlockEntityState<T>
implements Sign {
    private ArrayList<Component> originalLines = null;
    private ArrayList<Component> lines = null;

    public CraftSign(World world, T tileEntity) {
        super(world, tileEntity);
    }

    public List<Component> lines() {
        this.loadLines();
        return this.lines;
    }

    public Component line(int index) {
        this.loadLines();
        return this.lines.get(index);
    }

    public void line(int index, Component line) {
        this.loadLines();
        this.lines.set(index, line);
    }

    private void loadLines() {
        if (this.lines != null) {
            return;
        }
        TileEntitySign sign = (TileEntitySign)this.getSnapshot();
        this.lines = PaperAdventure.asAdventure(Lists.newArrayList((Object[])sign.f));
        this.originalLines = new ArrayList<Component>(this.lines);
    }

    public String[] getLines() {
        this.loadLines();
        return (String[])this.lines.stream().map(arg_0 -> ((LegacyComponentSerializer)LegacyComponentSerializer.legacySection()).serialize(arg_0)).toArray(String[]::new);
    }

    public String getLine(int index) throws IndexOutOfBoundsException {
        this.loadLines();
        return LegacyComponentSerializer.legacySection().serialize(this.lines.get(index));
    }

    public void setLine(int index, String line) throws IndexOutOfBoundsException {
        this.loadLines();
        this.lines.set(index, (Component)(line != null ? LegacyComponentSerializer.legacySection().deserialize(line) : Component.empty()));
    }

    public boolean isEditable() {
        return ((TileEntitySign)this.getSnapshot()).h;
    }

    public void setEditable(boolean editable) {
        ((TileEntitySign)this.getSnapshot()).h = editable;
    }

    public boolean isGlowingText() {
        return ((TileEntitySign)this.getSnapshot()).v();
    }

    public void setGlowingText(boolean glowing) {
        ((TileEntitySign)this.getSnapshot()).b(glowing);
    }

    public DyeColor getColor() {
        return DyeColor.getByWoolData((byte)((byte)((TileEntitySign)this.getSnapshot()).j().a()));
    }

    public void setColor(DyeColor color) {
        ((TileEntitySign)this.getSnapshot()).a(EnumColor.a(color.getWoolData()));
    }

    @Override
    public void applyTo(T sign) {
        super.applyTo(sign);
        if (this.lines != null) {
            for (int i2 = 0; i2 < this.lines.size(); ++i2) {
                Component origComp;
                Component component = this.lines.get(i2);
                if (component.equals(origComp = this.originalLines.get(i2))) continue;
                ((TileEntitySign)sign).a(i2, PaperAdventure.asVanilla(component));
            }
        }
        ((TileEntitySign)sign).h = ((TileEntitySign)this.getSnapshot()).h;
    }

    public static void openSign(Sign sign, HumanEntity player) {
        Preconditions.checkArgument((sign != null ? 1 : 0) != 0, (Object)"sign == null");
        Preconditions.checkArgument((sign.getWorld() == player.getWorld() ? 1 : 0) != 0, (Object)"Sign must be in same world as Player");
        TileEntitySign handle = (TileEntitySign)((CraftSign)sign).getTileEntity();
        handle.h = true;
        ((CraftHumanEntity)player).getHandle().a(handle);
    }

    public static IChatBaseComponent[] sanitizeLines(List<? extends Component> lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            components[i2] = i2 < lines.size() && lines.get(i2) != null ? PaperAdventure.asVanilla(lines.get(i2)) : IChatBaseComponent.b("");
        }
        return components;
    }

    public static IChatBaseComponent[] sanitizeLines(String[] lines) {
        IChatBaseComponent[] components = new IChatBaseComponent[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            components[i2] = i2 < lines.length && lines[i2] != null ? CraftChatMessage.fromString(lines[i2])[0] : IChatBaseComponent.h();
        }
        return components;
    }

    public static String[] revertComponents(IChatBaseComponent[] components) {
        String[] lines = new String[components.length];
        for (int i2 = 0; i2 < lines.length; ++i2) {
            lines[i2] = CraftSign.revertComponent(components[i2]);
        }
        return lines;
    }

    private static String revertComponent(IChatBaseComponent component) {
        return CraftChatMessage.fromComponent(component);
    }
}

