/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.boss;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.dimension.end.EnderDragonBattle;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.boss.BossBar;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_19_R3.boss.CraftBossBar;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.entity.EnderDragon;

public class CraftDragonBattle
implements DragonBattle {
    private final EnderDragonBattle handle;

    public CraftDragonBattle(EnderDragonBattle handle) {
        this.handle = handle;
    }

    public EnderDragon getEnderDragon() {
        Entity entity = this.handle.l.a(this.handle.u);
        return entity != null ? (EnderDragon)entity.getBukkitEntity() : null;
    }

    public BossBar getBossBar() {
        return new CraftBossBar(this.handle.k);
    }

    public Location getEndPortalLocation() {
        if (this.handle.w == null) {
            return null;
        }
        return CraftLocation.toBukkit(this.handle.w, (World)this.handle.l.getWorld());
    }

    public boolean generateEndPortal(boolean withPortals) {
        if (this.handle.w != null || this.handle.j() != null) {
            return false;
        }
        this.handle.a(withPortals);
        return true;
    }

    public boolean hasBeenPreviouslyKilled() {
        return this.handle.d();
    }

    public void initiateRespawn() {
        this.handle.e();
    }

    public DragonBattle.RespawnPhase getRespawnPhase() {
        return this.toBukkitRespawnPhase(this.handle.x);
    }

    public boolean setRespawnPhase(DragonBattle.RespawnPhase phase) {
        Preconditions.checkArgument((phase != null && phase != DragonBattle.RespawnPhase.NONE ? 1 : 0) != 0, (String)"Invalid respawn phase provided: %s", (Object)phase);
        if (this.handle.x == null) {
            return false;
        }
        this.handle.a(this.toNMSRespawnPhase(phase));
        return true;
    }

    public void resetCrystals() {
        this.handle.f();
    }

    public int hashCode() {
        return this.handle.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CraftDragonBattle && ((CraftDragonBattle)obj).handle == this.handle;
    }

    private DragonBattle.RespawnPhase toBukkitRespawnPhase(EnumDragonRespawn phase) {
        return phase != null ? DragonBattle.RespawnPhase.values()[phase.ordinal()] : DragonBattle.RespawnPhase.NONE;
    }

    private EnumDragonRespawn toNMSRespawnPhase(DragonBattle.RespawnPhase phase) {
        return phase != DragonBattle.RespawnPhase.NONE ? EnumDragonRespawn.values()[phase.ordinal()] : null;
    }
}

