/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.base.Preconditions;
import net.kyori.adventure.util.TriState;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.animal.EntityBee;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.entity.Bee;
import org.bukkit.entity.EntityType;

public class CraftBee
extends CraftAnimals
implements Bee {
    public CraftBee(CraftServer server, EntityBee entity) {
        super(server, entity);
    }

    @Override
    public EntityBee getHandle() {
        return (EntityBee)this.entity;
    }

    @Override
    public String toString() {
        return "CraftBee";
    }

    @Override
    public EntityType getType() {
        return EntityType.BEE;
    }

    public Location getHive() {
        BlockPosition hive = this.getHandle().ga();
        return hive == null ? null : CraftLocation.toBukkit(hive, this.getWorld());
    }

    public void setHive(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Hive must be in same world");
        this.getHandle().cF = location == null ? null : CraftLocation.toBlockPosition(location);
    }

    public Location getFlower() {
        BlockPosition flower = this.getHandle().q();
        return flower == null ? null : CraftLocation.toBukkit(flower, this.getWorld());
    }

    public void setFlower(Location location) {
        Preconditions.checkArgument((location == null || this.getWorld().equals(location.getWorld()) ? 1 : 0) != 0, (Object)"Flower must be in same world");
        this.getHandle().g(location == null ? null : CraftLocation.toBlockPosition(location));
    }

    public boolean hasNectar() {
        return this.getHandle().gc();
    }

    public void setHasNectar(boolean nectar) {
        this.getHandle().w(nectar);
    }

    public boolean hasStung() {
        return this.getHandle().gd();
    }

    public void setHasStung(boolean stung) {
        this.getHandle().x(stung);
    }

    public int getAnger() {
        return this.getHandle().a();
    }

    public void setAnger(int anger) {
        this.getHandle().a(anger);
    }

    public int getCannotEnterHiveTicks() {
        return this.getHandle().cy;
    }

    public void setCannotEnterHiveTicks(int ticks) {
        this.getHandle().s(ticks);
    }

    public void setRollingOverride(TriState rolling) {
        this.getHandle().rollingOverride = rolling;
        this.getHandle().y(this.getHandle().gp());
    }

    public boolean isRolling() {
        return this.getRollingOverride().toBooleanOrElse(this.getHandle().gp());
    }

    public TriState getRollingOverride() {
        return this.getHandle().rollingOverride;
    }

    public void setCropsGrownSincePollination(int crops) {
        this.getHandle().cz = crops;
    }

    public int getCropsGrownSincePollination() {
        return this.getHandle().cz;
    }

    public void setTicksSincePollination(int ticks) {
        this.getHandle().cx = ticks;
    }

    public int getTicksSincePollination() {
        return this.getHandle().cx;
    }
}

