/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.util.Brightness;
import net.minecraft.world.entity.Display;
import org.bukkit.Color;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.util.Transformation;
import org.joml.Matrix4f;

public class CraftDisplay
extends CraftEntity
implements Display {
    public CraftDisplay(CraftServer server, net.minecraft.world.entity.Display entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.Display getHandle() {
        return (net.minecraft.world.entity.Display)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftDisplay";
    }

    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    public Transformation getTransformation() {
        com.mojang.math.Transformation nms = net.minecraft.world.entity.Display.a(this.getHandle().aj());
        return new Transformation(nms.d(), nms.e(), nms.f(), nms.g());
    }

    public void setTransformation(Transformation transformation) {
        Preconditions.checkArgument((transformation != null ? 1 : 0) != 0, (Object)"Transformation cannot be null");
        this.getHandle().a(new com.mojang.math.Transformation(transformation.getTranslation(), transformation.getLeftRotation(), transformation.getScale(), transformation.getRightRotation()));
    }

    public void setTransformationMatrix(Matrix4f transformationMatrix) {
        Preconditions.checkArgument((transformationMatrix != null ? 1 : 0) != 0, (Object)"Transformation matrix cannot be null");
        this.getHandle().a(new com.mojang.math.Transformation(transformationMatrix));
    }

    public int getInterpolationDuration() {
        return this.getHandle().o();
    }

    public void setInterpolationDuration(int duration) {
        this.getHandle().setInterpolationDuration_(duration);
    }

    public float getViewRange() {
        return this.getHandle().r();
    }

    public void setViewRange(float range) {
        this.getHandle().g(range);
    }

    public float getShadowRadius() {
        return this.getHandle().s();
    }

    public void setShadowRadius(float radius) {
        this.getHandle().h(radius);
    }

    public float getShadowStrength() {
        return this.getHandle().t();
    }

    public void setShadowStrength(float strength) {
        this.getHandle().w(strength);
    }

    public float getDisplayWidth() {
        return this.getHandle().v();
    }

    public void setDisplayWidth(float width) {
        this.getHandle().x(width);
    }

    public float getDisplayHeight() {
        return this.getHandle().x();
    }

    public void setDisplayHeight(float height) {
        this.getHandle().y(height);
    }

    public int getInterpolationDelay() {
        return this.getHandle().getInterpolationDelay_();
    }

    public void setInterpolationDelay(int ticks) {
        this.getHandle().setInterpolationDelay_(ticks);
    }

    public Display.Billboard getBillboard() {
        return Display.Billboard.valueOf((String)this.getHandle().j().name());
    }

    public void setBillboard(Display.Billboard billboard) {
        Preconditions.checkArgument((billboard != null ? 1 : 0) != 0, (Object)"Billboard cannot be null");
        this.getHandle().a(Display.BillboardConstraints.valueOf(billboard.name()));
    }

    public Color getGlowColorOverride() {
        int color = this.getHandle().w();
        return color == -1 ? null : Color.fromARGB((int)color);
    }

    public void setGlowColorOverride(Color color) {
        if (color == null) {
            this.getHandle().d(-1);
        } else {
            this.getHandle().d(color.asARGB());
        }
    }

    public Display.Brightness getBrightness() {
        Brightness nms = this.getHandle().q();
        return nms != null ? new Display.Brightness(nms.b(), nms.c()) : null;
    }

    public void setBrightness(Display.Brightness brightness) {
        if (brightness != null) {
            this.getHandle().a(new Brightness(brightness.getBlockLight(), brightness.getSkyLight()));
        } else {
            this.getHandle().a((Brightness)null);
        }
    }
}

