/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftProjectile;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FishHook;

public class CraftFishHook
extends CraftProjectile
implements FishHook {
    private double biteChance = -1.0;

    public CraftFishHook(CraftServer server, EntityFishingHook entity) {
        super(server, entity);
    }

    @Override
    public EntityFishingHook getHandle() {
        return (EntityFishingHook)this.entity;
    }

    @Override
    public String toString() {
        return "CraftFishingHook";
    }

    public EntityType getType() {
        return EntityType.FISHING_HOOK;
    }

    public int getMinWaitTime() {
        return this.getHandle().minWaitTime;
    }

    public void setMinWaitTime(int minWaitTime) {
        EntityFishingHook hook = this.getHandle();
        Validate.isTrue((minWaitTime >= 0 && minWaitTime <= this.getMaxWaitTime() ? 1 : 0) != 0, (String)"The minimum wait time should be between 0 and the maximum wait time.");
        hook.minWaitTime = minWaitTime;
    }

    public int getMaxWaitTime() {
        return this.getHandle().maxWaitTime;
    }

    public void setMaxWaitTime(int maxWaitTime) {
        EntityFishingHook hook = this.getHandle();
        Validate.isTrue((maxWaitTime >= 0 && maxWaitTime >= this.getMinWaitTime() ? 1 : 0) != 0, (String)"The maximum wait time should be higher than or equal to 0 and the minimum wait time.");
        hook.maxWaitTime = maxWaitTime;
    }

    public void setWaitTime(int min, int max) {
        Validate.isTrue((min >= 0 && max >= 0 && min <= max ? 1 : 0) != 0, (String)"The minimum/maximum wait time should be higher than or equal to 0 and the minimum wait time.");
        this.getHandle().minWaitTime = min;
        this.getHandle().maxWaitTime = max;
    }

    public int getMinLureTime() {
        return this.getHandle().minLureTime;
    }

    public void setMinLureTime(int minLureTime) {
        Validate.isTrue((minLureTime >= 0 && minLureTime <= this.getMaxLureTime() ? 1 : 0) != 0, (String)"The minimum lure time should be between 0 and the maximum wait time.");
        this.getHandle().minLureTime = minLureTime;
    }

    public int getMaxLureTime() {
        return this.getHandle().maxLureTime;
    }

    public void setMaxLureTime(int maxLureTime) {
        Validate.isTrue((maxLureTime >= 0 && maxLureTime >= this.getMinLureTime() ? 1 : 0) != 0, (String)"The maximum lure time should be higher than or equal to 0 and the minimum wait time.");
        this.getHandle().maxLureTime = maxLureTime;
    }

    public void setLureTime(int min, int max) {
        Validate.isTrue((min >= 0 && max >= 0 && min <= max ? 1 : 0) != 0, (String)"The minimum/maximum lure time should be higher than or equal to 0 and the minimum wait time.");
        this.getHandle().minLureTime = min;
        this.getHandle().maxLureTime = max;
    }

    public float getMinLureAngle() {
        return this.getHandle().minLureAngle;
    }

    public void setMinLureAngle(float minLureAngle) {
        Validate.isTrue((minLureAngle <= this.getMaxLureAngle() ? 1 : 0) != 0, (String)"The minimum lure angle should be less than the maximum lure angle.");
        this.getHandle().minLureAngle = minLureAngle;
    }

    public float getMaxLureAngle() {
        return this.getHandle().maxLureAngle;
    }

    public void setMaxLureAngle(float maxLureAngle) {
        Validate.isTrue((maxLureAngle >= this.getMinLureAngle() ? 1 : 0) != 0, (String)"The minimum lure angle should be less than the maximum lure angle.");
        this.getHandle().maxLureAngle = maxLureAngle;
    }

    public void setLureAngle(float min, float max) {
        Validate.isTrue((min <= max ? 1 : 0) != 0, (String)"The minimum lure angle should be less than the maximum lure angle.");
        this.getHandle().minLureAngle = min;
        this.getHandle().maxLureAngle = max;
    }

    public boolean isSkyInfluenced() {
        return this.getHandle().skyInfluenced;
    }

    public void setSkyInfluenced(boolean skyInfluenced) {
        this.getHandle().skyInfluenced = skyInfluenced;
    }

    public boolean isRainInfluenced() {
        return this.getHandle().rainInfluenced;
    }

    public void setRainInfluenced(boolean rainInfluenced) {
        this.getHandle().rainInfluenced = rainInfluenced;
    }

    public boolean getApplyLure() {
        return this.getHandle().applyLure;
    }

    public void setApplyLure(boolean applyLure) {
        this.getHandle().applyLure = applyLure;
    }

    public double getBiteChance() {
        EntityFishingHook hook = this.getHandle();
        if (this.biteChance == -1.0) {
            if (hook.H.t(BlockPosition.a(hook.de()).b(0, 1, 0))) {
                return 0.0033333333333333335;
            }
            return 0.002;
        }
        return this.biteChance;
    }

    public void setBiteChance(double chance) {
        Validate.isTrue((chance >= 0.0 && chance <= 1.0 ? 1 : 0) != 0, (String)"The bite chance must be between 0 and 1.");
        this.biteChance = chance;
    }

    public boolean isInOpenWater() {
        return this.getHandle().e < 10 && this.getHandle().b(this.getHandle().dg());
    }

    public Entity getHookedEntity() {
        net.minecraft.world.entity.Entity hooked = this.getHandle().o;
        return hooked != null ? hooked.getBukkitEntity() : null;
    }

    public void setHookedEntity(Entity entity) {
        EntityFishingHook hook = this.getHandle();
        hook.o = entity != null ? ((CraftEntity)entity).getHandle() : null;
        hook.aj().b(EntityFishingHook.g, hook.o != null ? hook.o.af() + 1 : 0);
    }

    public boolean pullHookedEntity() {
        EntityFishingHook hook = this.getHandle();
        if (hook.o == null) {
            return false;
        }
        hook.c(hook.o);
        return true;
    }

    public FishHook.HookState getState() {
        return FishHook.HookState.values()[this.getHandle().p.ordinal()];
    }

    public int getWaitTime() {
        return this.getHandle().k;
    }

    public void setWaitTime(int ticks) {
        this.getHandle().k = ticks;
    }
}

