/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.monster.EntityGhast;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEnemy;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftFlying;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Ghast;

public class CraftGhast
extends CraftFlying
implements Ghast,
CraftEnemy {
    public CraftGhast(CraftServer server, EntityGhast entity) {
        super(server, entity);
    }

    @Override
    public EntityGhast getHandle() {
        return (EntityGhast)this.entity;
    }

    @Override
    public String toString() {
        return "CraftGhast";
    }

    @Override
    public EntityType getType() {
        return EntityType.GHAST;
    }

    public boolean isCharging() {
        return this.getHandle().q();
    }

    public void setCharging(boolean flag) {
        this.getHandle().w(flag);
    }

    public int getExplosionPower() {
        return this.getHandle().r();
    }

    public void setExplosionPower(int explosionPower) {
        Preconditions.checkArgument((explosionPower >= 0 && explosionPower <= 127 ? 1 : 0) != 0, (Object)"The explosion power has to be between 0 and 127");
        this.getHandle().setExplosionPower(explosionPower);
    }
}

