/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityItem;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class CraftItem
extends CraftEntity
implements Item {
    private static final int NO_AGE_TIME = Short.MIN_VALUE;
    private static final int NO_PICKUP_TIME = Short.MAX_VALUE;
    private final EntityItem item;

    public CraftItem(CraftServer server, Entity entity, EntityItem item) {
        super(server, entity);
        this.item = item;
    }

    public CraftItem(CraftServer server, EntityItem entity) {
        this(server, entity, entity);
    }

    public ItemStack getItemStack() {
        return CraftItemStack.asCraftMirror(this.item.i());
    }

    public void setItemStack(ItemStack stack) {
        this.item.a(CraftItemStack.asNMSCopy(stack));
    }

    public int getPickupDelay() {
        return this.item.h;
    }

    public void setPickupDelay(int delay) {
        this.item.h = Math.min(delay, Short.MAX_VALUE);
    }

    public void setUnlimitedLifetime(boolean unlimited) {
        this.item.g = unlimited ? Short.MIN_VALUE : this.getTicksLived();
    }

    public boolean isUnlimitedLifetime() {
        return this.item.g == Short.MIN_VALUE;
    }

    @Override
    public void setTicksLived(int value) {
        super.setTicksLived(value);
        if (!this.isUnlimitedLifetime()) {
            this.item.g = value;
        }
    }

    public boolean canMobPickup() {
        return this.item.canMobPickup;
    }

    public void setCanMobPickup(boolean canMobPickup) {
        this.item.canMobPickup = canMobPickup;
    }

    public boolean canPlayerPickup() {
        return this.item.h != Short.MAX_VALUE;
    }

    public void setCanPlayerPickup(boolean canPlayerPickup) {
        this.item.h = canPlayerPickup ? 0 : Short.MAX_VALUE;
    }

    public boolean willAge() {
        return this.item.g != Short.MIN_VALUE;
    }

    public void setWillAge(boolean willAge) {
        this.item.g = willAge ? 0 : Short.MIN_VALUE;
    }

    @NotNull
    public TriState getFrictionState() {
        return this.item.frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Objects.requireNonNull(state, "state may not be null");
        this.item.frictionState = state;
    }

    public int getHealth() {
        return this.item.i;
    }

    public void setHealth(int health) {
        if (health <= 0) {
            this.item.i().a(this.item);
            this.item.ai();
        } else {
            this.item.i = health;
        }
    }

    public void setOwner(UUID uuid) {
        this.item.b(uuid);
    }

    public UUID getOwner() {
        return this.item.k;
    }

    public void setThrower(UUID uuid) {
        this.item.c(uuid);
    }

    public UUID getThrower() {
        return this.item.j;
    }

    @Override
    public String toString() {
        return "CraftItem";
    }

    public EntityType getType() {
        return EntityType.DROPPED_ITEM;
    }
}

