/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.destroystokyo.paper.block.TargetBlockInfo;
import com.destroystokyo.paper.entity.TargetEntityInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.util.TriState;
import net.minecraft.network.protocol.game.PacketPlayOutEntityStatus;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMonsterType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.boss.wither.EntityWither;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityDragonFireball;
import net.minecraft.world.entity.projectile.EntityEgg;
import net.minecraft.world.entity.projectile.EntityEnderPearl;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.entity.projectile.EntityLargeFireball;
import net.minecraft.world.entity.projectile.EntityLlamaSpit;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.entity.projectile.EntityProjectile;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.entity.projectile.EntitySmallFireball;
import net.minecraft.world.entity.projectile.EntitySnowball;
import net.minecraft.world.entity.projectile.EntitySpectralArrow;
import net.minecraft.world.entity.projectile.EntityThrownExpBottle;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.EntityTippedArrow;
import net.minecraft.world.entity.projectile.EntityWitherSkull;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.Validate;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_19_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftSound;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftItem;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.memory.CraftMemoryKey;
import org.bukkit.craftbukkit.v1_19_R3.entity.memory.CraftMemoryMapper;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftEntityEquipment;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.potion.CraftPotionUtil;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftVector;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityCategory;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.FishHook;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.LlamaSpit;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.memory.MemoryKey;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;
import org.bukkit.util.BlockIterator;
import org.bukkit.util.Consumer;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

public class CraftLivingEntity
extends CraftEntity
implements LivingEntity {
    private CraftEntityEquipment equipment;

    public CraftLivingEntity(CraftServer server, EntityLiving entity) {
        super(server, entity);
        if (entity instanceof EntityInsentient || entity instanceof EntityArmorStand) {
            this.equipment = new CraftEntityEquipment(this);
        }
    }

    public double getHealth() {
        return Math.min((double)Math.max(0.0f, this.getHandle().eo()), this.getMaxHealth());
    }

    public void setHealth(double health) {
        if ((health = (double)((float)health)) < 0.0 || health > this.getMaxHealth()) {
            throw new IllegalArgumentException("Health must be between 0 and " + this.getMaxHealth() + ", but was " + health + ". (attribute base value: " + this.getHandle().a(GenericAttributes.a).b() + (Serializable)(this instanceof CraftPlayer ? ", player: " + this.getName() + ")" : Character.valueOf(')')));
        }
        if (this.getHandle().generation && health == 0.0) {
            this.getHandle().ai();
            return;
        }
        this.getHandle().c((float)health);
        if (health == 0.0) {
            this.getHandle().a(this.getHandle().dG().n());
        }
    }

    public double getAbsorptionAmount() {
        return this.getHandle().fb();
    }

    public void setAbsorptionAmount(double amount) {
        Preconditions.checkArgument((amount >= 0.0 && Double.isFinite(amount) ? 1 : 0) != 0, (Object)"amount < 0 or non-finite");
        this.getHandle().x((float)amount);
    }

    public double getMaxHealth() {
        return this.getHandle().eE();
    }

    public void setMaxHealth(double amount) {
        Validate.isTrue((amount > 0.0 ? 1 : 0) != 0, (String)"Max health must be greater than 0");
        this.getHandle().a(GenericAttributes.a).a(amount);
        if (this.getHealth() > amount) {
            this.setHealth(amount);
        }
    }

    public void resetMaxHealth() {
        this.setMaxHealth(this.getHandle().a(GenericAttributes.a).a().a());
    }

    public double getEyeHeight() {
        return this.getHandle().cE();
    }

    public double getEyeHeight(boolean ignorePose) {
        return this.getEyeHeight();
    }

    private List<Block> getLineOfSight(Set<Material> transparent, int maxDistance, int maxLength) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot get line of sight during world generation");
        if (transparent == null) {
            transparent = Sets.newHashSet((Object[])new Material[]{Material.AIR, Material.CAVE_AIR, Material.VOID_AIR});
        }
        if (maxDistance > 120) {
            maxDistance = 120;
        }
        ArrayList<Block> blocks = new ArrayList<Block>();
        BlockIterator itr = new BlockIterator((LivingEntity)this, maxDistance);
        while (itr.hasNext()) {
            Material material;
            Block block = (Block)itr.next();
            blocks.add(block);
            if (maxLength != 0 && blocks.size() > maxLength) {
                blocks.remove(0);
            }
            if (transparent.contains(material = block.getType())) continue;
            break;
        }
        return blocks;
    }

    public List<Block> getLineOfSight(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 0);
    }

    public Block getTargetBlock(Set<Material> transparent, int maxDistance) {
        List<Block> blocks = this.getLineOfSight(transparent, maxDistance, 1);
        return blocks.get(0);
    }

    public Block getTargetBlock(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockExact(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        return this.getTargetBlockFace(maxDistance, fluidMode.bukkit);
    }

    public BlockFace getTargetBlockFace(int maxDistance, FluidCollisionMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode);
        return result != null ? result.getHitBlockFace() : null;
    }

    public TargetBlockInfo getTargetBlockInfo(int maxDistance, TargetBlockInfo.FluidMode fluidMode) {
        RayTraceResult result = this.rayTraceBlocks(maxDistance, fluidMode.bukkit);
        if (result != null && result.getHitBlock() != null && result.getHitBlockFace() != null) {
            return new TargetBlockInfo(result.getHitBlock(), result.getHitBlockFace());
        }
        return null;
    }

    public Entity getTargetEntity(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : rayTrace.a().getBukkitEntity();
    }

    public TargetEntityInfo getTargetEntityInfo(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new TargetEntityInfo((Entity)rayTrace.a().getBukkitEntity(), new Vector(rayTrace.e().c, rayTrace.e().d, rayTrace.e().e));
    }

    public RayTraceResult rayTraceEntities(int maxDistance, boolean ignoreBlocks) {
        MovingObjectPositionEntity rayTrace = this.rayTraceEntity(maxDistance, ignoreBlocks);
        return rayTrace == null ? null : new RayTraceResult(CraftVector.toBukkit(rayTrace.e()), (Entity)rayTrace.a().getBukkitEntity());
    }

    public MovingObjectPositionEntity rayTraceEntity(int maxDistance, boolean ignoreBlocks) {
        Vec3D eye;
        MovingObjectPosition rayTraceBlocks;
        MovingObjectPositionEntity rayTrace = this.getHandle().getTargetEntity(maxDistance);
        if (rayTrace == null) {
            return null;
        }
        if (!ignoreBlocks && (rayTraceBlocks = this.getHandle().getRayTrace(maxDistance, RayTrace.FluidCollisionOption.a)) != null && (eye = this.getHandle().n(1.0f)).g(rayTraceBlocks.e()) <= eye.g(rayTrace.e())) {
            return null;
        }
        return rayTrace;
    }

    public List<Block> getLastTwoTargetBlocks(Set<Material> transparent, int maxDistance) {
        return this.getLineOfSight(transparent, maxDistance, 2);
    }

    public Block getTargetBlockExact(int maxDistance) {
        return this.getTargetBlockExact(maxDistance, FluidCollisionMode.NEVER);
    }

    public Block getTargetBlockExact(int maxDistance, FluidCollisionMode fluidCollisionMode) {
        RayTraceResult hitResult = this.rayTraceBlocks(maxDistance, fluidCollisionMode);
        return hitResult != null ? hitResult.getHitBlock() : null;
    }

    public RayTraceResult rayTraceBlocks(double maxDistance) {
        return this.rayTraceBlocks(maxDistance, FluidCollisionMode.NEVER);
    }

    public RayTraceResult rayTraceBlocks(double maxDistance, FluidCollisionMode fluidCollisionMode) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot ray tray blocks during world generation");
        Location eyeLocation = this.getEyeLocation();
        Vector direction = eyeLocation.getDirection();
        return this.getWorld().rayTraceBlocks(eyeLocation, direction, maxDistance, fluidCollisionMode, false);
    }

    public int getRemainingAir() {
        return this.getHandle().cd();
    }

    public void setRemainingAir(int ticks) {
        this.getHandle().i(ticks);
    }

    public int getMaximumAir() {
        return this.getHandle().maxAirTicks;
    }

    public void setMaximumAir(int ticks) {
        this.getHandle().maxAirTicks = ticks;
    }

    public int getArrowCooldown() {
        return this.getHandle().aH;
    }

    public void setArrowCooldown(int ticks) {
        this.getHandle().aH = ticks;
    }

    public int getArrowsInBody() {
        return this.getHandle().eF();
    }

    public void setArrowsInBody(int count, boolean fireEvent) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New arrow amount must be >= 0");
        if (!fireEvent) {
            this.getHandle().aj().b(EntityLiving.bI, count);
        } else {
            this.getHandle().o(count);
        }
    }

    public int getBeeStingerCooldown() {
        return this.getHandle().aI;
    }

    public void setBeeStingerCooldown(int ticks) {
        this.getHandle().aI = ticks;
    }

    public int getBeeStingersInBody() {
        return this.getHandle().eG();
    }

    public void setBeeStingersInBody(int count) {
        Preconditions.checkArgument((count >= 0 ? 1 : 0) != 0, (Object)"New bee stinger amount must be >= 0");
        this.getHandle().p(count);
    }

    public void damage(double amount) {
        this.damage(amount, null);
    }

    public void damage(double amount, Entity source) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot damage entity during world generation");
        DamageSource reason = this.getHandle().dG().n();
        if (source instanceof HumanEntity) {
            reason = this.getHandle().dG().a(((CraftHumanEntity)source).getHandle());
        } else if (source instanceof LivingEntity) {
            reason = this.getHandle().dG().b(((CraftLivingEntity)source).getHandle());
        }
        this.entity.a(reason, (float)amount);
    }

    public Location getEyeLocation() {
        Location loc = this.getLocation();
        loc.setY(loc.getY() + this.getEyeHeight());
        return loc;
    }

    public int getMaximumNoDamageTicks() {
        return this.getHandle().aQ;
    }

    public void setMaximumNoDamageTicks(int ticks) {
        this.getHandle().aQ = ticks;
    }

    public double getLastDamage() {
        return this.getHandle().bh;
    }

    public void setLastDamage(double damage) {
        this.getHandle().bh = (float)damage;
    }

    public int getNoDamageTicks() {
        return this.getHandle().ak;
    }

    public void setNoDamageTicks(int ticks) {
        this.getHandle().ak = ticks;
    }

    @Override
    public EntityLiving getHandle() {
        return (EntityLiving)this.entity;
    }

    public void setHandle(EntityLiving entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftLivingEntity{id=" + this.getEntityId() + "}";
    }

    public Player getKiller() {
        return this.getHandle().aX == null ? null : (Player)this.getHandle().aX.getBukkitEntity();
    }

    public void setKiller(Player killer) {
        EntityPlayer entityPlayer = killer == null ? null : ((CraftPlayer)killer).getHandle();
        this.getHandle().aX = entityPlayer;
        this.getHandle().bT = entityPlayer;
        this.getHandle().aY = entityPlayer == null ? 0 : 100;
    }

    public boolean addPotionEffect(PotionEffect effect) {
        return this.addPotionEffect(effect, false);
    }

    public boolean addPotionEffect(PotionEffect effect, boolean force) {
        AsyncCatcher.catchOp("effect add");
        this.getHandle().addEffect(new MobEffect(MobEffectList.a(effect.getType().getId()), effect.getDuration(), effect.getAmplifier(), effect.isAmbient(), effect.hasParticles(), effect.hasIcon()), EntityPotionEffectEvent.Cause.PLUGIN);
        return true;
    }

    public boolean addPotionEffects(Collection<PotionEffect> effects) {
        boolean success = true;
        for (PotionEffect effect : effects) {
            success &= this.addPotionEffect(effect);
        }
        return success;
    }

    public boolean hasPotionEffect(PotionEffectType type) {
        return this.getHandle().a(MobEffectList.a(type.getId()));
    }

    public PotionEffect getPotionEffect(PotionEffectType type) {
        MobEffect handle = this.getHandle().b(MobEffectList.a(type.getId()));
        return handle == null ? null : new PotionEffect(PotionEffectType.getById((int)MobEffectList.a(handle.c())), handle.d(), handle.e(), handle.f(), handle.g());
    }

    public void removePotionEffect(PotionEffectType type) {
        this.getHandle().removeEffect(MobEffectList.a(type.getId()), EntityPotionEffectEvent.Cause.PLUGIN);
    }

    public Collection<PotionEffect> getActivePotionEffects() {
        ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
        for (MobEffect handle : this.getHandle().bO.values()) {
            effects.add(new PotionEffect(PotionEffectType.getById((int)MobEffectList.a(handle.c())), handle.d(), handle.e(), handle.f(), handle.g()));
        }
        return effects;
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile) {
        return this.launchProjectile(projectile, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity) {
        return this.launchProjectile(projectile, velocity, null);
    }

    public <T extends Projectile> T launchProjectile(Class<? extends T> projectile, Vector velocity, Consumer<T> function) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot launch projectile during world generation");
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        IProjectile launch = null;
        if (Snowball.class.isAssignableFrom(projectile)) {
            launch = new EntitySnowball(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dy(), this.getHandle().dw(), 0.0f, 1.5f, 1.0f);
        } else if (Egg.class.isAssignableFrom(projectile)) {
            launch = new EntityEgg(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dy(), this.getHandle().dw(), 0.0f, 1.5f, 1.0f);
        } else if (EnderPearl.class.isAssignableFrom(projectile)) {
            launch = new EntityEnderPearl(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dy(), this.getHandle().dw(), 0.0f, 1.5f, 1.0f);
        } else if (AbstractArrow.class.isAssignableFrom(projectile)) {
            if (TippedArrow.class.isAssignableFrom(projectile)) {
                launch = new EntityTippedArrow(world, this.getHandle());
                ((EntityTippedArrow)launch).setPotionType(CraftPotionUtil.fromBukkit(new PotionData(PotionType.WATER, false, false)));
            } else {
                launch = SpectralArrow.class.isAssignableFrom(projectile) ? new EntitySpectralArrow(world, this.getHandle()) : (Trident.class.isAssignableFrom(projectile) ? new EntityThrownTrident(world, this.getHandle(), new net.minecraft.world.item.ItemStack(Items.uP)) : new EntityTippedArrow(world, this.getHandle()));
            }
            ((EntityArrow)launch).a(this.getHandle(), this.getHandle().dy(), this.getHandle().dw(), 0.0f, 3.0f, 1.0f);
        } else if (ThrownPotion.class.isAssignableFrom(projectile)) {
            if (LingeringPotion.class.isAssignableFrom(projectile)) {
                launch = new EntityPotion(world, this.getHandle());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.LINGERING_POTION, 1)));
            } else {
                launch = new EntityPotion(world, this.getHandle());
                ((EntityPotion)launch).a(CraftItemStack.asNMSCopy(new ItemStack(Material.SPLASH_POTION, 1)));
            }
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dy(), this.getHandle().dw(), -20.0f, 0.5f, 1.0f);
        } else if (ThrownExpBottle.class.isAssignableFrom(projectile)) {
            launch = new EntityThrownExpBottle(world, this.getHandle());
            ((EntityProjectile)launch).a(this.getHandle(), this.getHandle().dy(), this.getHandle().dw(), -20.0f, 0.7f, 1.0f);
        } else if (FishHook.class.isAssignableFrom(projectile) && this.getHandle() instanceof EntityHuman) {
            launch = new EntityFishingHook((EntityHuman)this.getHandle(), (World)world, 0, 0);
        } else if (Fireball.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection().multiply(10);
            launch = SmallFireball.class.isAssignableFrom(projectile) ? new EntitySmallFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (WitherSkull.class.isAssignableFrom(projectile) ? new EntityWitherSkull(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : (DragonFireball.class.isAssignableFrom(projectile) ? new EntityDragonFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ()) : new EntityLargeFireball(world, this.getHandle(), direction.getX(), direction.getY(), direction.getZ(), 1)));
            ((EntityFireball)launch).projectileSource = this;
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (LlamaSpit.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            Vector direction = location.getDirection();
            launch = EntityTypes.ak.a(world);
            ((EntityLlamaSpit)launch).b((net.minecraft.world.entity.Entity)this.getHandle());
            ((EntityLlamaSpit)launch).c(direction.getX(), direction.getY(), direction.getZ(), 1.5f, 10.0f);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (ShulkerBullet.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityShulkerBullet(world, this.getHandle(), null, null);
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        } else if (Firework.class.isAssignableFrom(projectile)) {
            Location location = this.getEyeLocation();
            launch = new EntityFireworks(world, net.minecraft.world.item.ItemStack.b, this.getHandle());
            launch.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
        }
        Validate.notNull((Object)launch, (String)"Projectile not supported");
        if (velocity != null) {
            ((Projectile)launch.getBukkitEntity()).setVelocity(velocity);
        }
        if (function != null) {
            function.accept((Object)((Projectile)launch.getBukkitEntity()));
        }
        world.b(launch);
        return (T)((Projectile)launch.getBukkitEntity());
    }

    public EntityType getType() {
        return EntityType.UNKNOWN;
    }

    public boolean hasLineOfSight(Entity other) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check line of sight during world generation");
        return this.getHandle().B(((CraftEntity)other).getHandle());
    }

    public boolean hasLineOfSight(Location loc) {
        if (this.getHandle().H != ((CraftWorld)loc.getWorld()).getHandle()) {
            return false;
        }
        Vec3D vec3d = new Vec3D(this.getHandle().dl(), this.getHandle().dp(), this.getHandle().dr());
        Vec3D vec3d1 = new Vec3D(loc.getX(), loc.getY(), loc.getZ());
        if (vec3d1.g(vec3d) > 16384.0) {
            return false;
        }
        return this.getHandle().H.a(new RayTrace(vec3d, vec3d1, RayTrace.BlockCollisionOption.a, RayTrace.FluidCollisionOption.a, this.getHandle())).c() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public boolean getRemoveWhenFarAway() {
        return this.getHandle() instanceof EntityInsentient && !((EntityInsentient)this.getHandle()).fB();
    }

    public void setRemoveWhenFarAway(boolean remove) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).setPersistenceRequired(!remove);
        }
    }

    public EntityEquipment getEquipment() {
        return this.equipment;
    }

    public void setCanPickupItems(boolean pickup) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).s(pickup);
        } else {
            this.getHandle().bukkitPickUpLoot = pickup;
        }
    }

    public boolean getCanPickupItems() {
        if (this.getHandle() instanceof EntityInsentient) {
            return ((EntityInsentient)this.getHandle()).fA();
        }
        return this.getHandle().bukkitPickUpLoot;
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        if (this.getHealth() == 0.0) {
            return false;
        }
        return super.teleport(location, cause);
    }

    public boolean isLeashed() {
        if (!(this.getHandle() instanceof EntityInsentient)) {
            return false;
        }
        return ((EntityInsentient)this.getHandle()).fJ() != null;
    }

    public Entity getLeashHolder() throws IllegalStateException {
        if (!this.isLeashed()) {
            throw new IllegalStateException("Entity not leashed");
        }
        return ((EntityInsentient)this.getHandle()).fJ().getBukkitEntity();
    }

    private boolean unleash() {
        if (!this.isLeashed()) {
            return false;
        }
        ((EntityInsentient)this.getHandle()).a(true, false);
        return true;
    }

    public boolean setLeashHolder(Entity holder) {
        if (this.getHandle().generation || this.getHandle() instanceof EntityWither || !(this.getHandle() instanceof EntityInsentient)) {
            return false;
        }
        if (holder == null) {
            return this.unleash();
        }
        if (holder.isDead()) {
            return false;
        }
        this.unleash();
        ((EntityInsentient)this.getHandle()).b(((CraftEntity)holder).getHandle(), true);
        return true;
    }

    public boolean isGliding() {
        return this.getHandle().h(7);
    }

    public void setGliding(boolean gliding) {
        this.getHandle().b(7, gliding);
    }

    public boolean isSwimming() {
        return this.getHandle().bV();
    }

    public void setSwimming(boolean swimming) {
        this.getHandle().h(swimming);
    }

    public boolean isRiptiding() {
        return this.getHandle().fa();
    }

    public boolean isSleeping() {
        return this.getHandle().fu();
    }

    public boolean isClimbing() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot check if climbing during world generation");
        return this.getHandle().z_();
    }

    public AttributeInstance getAttribute(Attribute attribute) {
        return this.getHandle().craftAttributes.getAttribute(attribute);
    }

    public void registerAttribute(Attribute attribute) {
        this.getHandle().craftAttributes.registerAttribute(attribute);
    }

    public void setAI(boolean ai) {
        if (this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).t(!ai);
        }
    }

    public boolean hasAI() {
        return this.getHandle() instanceof EntityInsentient ? !((EntityInsentient)this.getHandle()).fK() : false;
    }

    public void attack(Entity target) {
        Preconditions.checkArgument((target != null ? 1 : 0) != 0, (Object)"target == null");
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot attack during world generation");
        if (this.getHandle() instanceof EntityHuman) {
            ((EntityHuman)this.getHandle()).d(((CraftEntity)target).getHandle());
        } else {
            this.getHandle().z(((CraftEntity)target).getHandle());
        }
    }

    public void swingMainHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.a, true);
    }

    public void swingOffHand() {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot swing hand during world generation");
        this.getHandle().a(EnumHand.b, true);
    }

    public void setCollidable(boolean collidable) {
        this.getHandle().collides = collidable;
    }

    public boolean isCollidable() {
        return this.getHandle().collides;
    }

    public Set<UUID> getCollidableExemptions() {
        return this.getHandle().collidableExemptions;
    }

    public <T> T getMemory(MemoryKey<T> memoryKey) {
        return this.getHandle().dH().c(CraftMemoryKey.fromMemoryKey(memoryKey)).map(CraftMemoryMapper::fromNms).orElse(null);
    }

    public <T> void setMemory(MemoryKey<T> memoryKey, T t2) {
        this.getHandle().dH().a(CraftMemoryKey.fromMemoryKey(memoryKey), CraftMemoryMapper.toNms(t2));
    }

    public Sound getHurtSound() {
        SoundEffect sound = this.getHandle().getHurtSound0(this.getHandle().dG().n());
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    public Sound getDeathSound() {
        SoundEffect sound = this.getHandle().getDeathSound0();
        return sound != null ? CraftSound.getBukkit(sound) : null;
    }

    public Sound getFallDamageSound(int fallHeight) {
        return CraftSound.getBukkit(this.getHandle().getFallDamageSound0(fallHeight));
    }

    public Sound getFallDamageSoundSmall() {
        return CraftSound.getBukkit(this.getHandle().ey().a());
    }

    public Sound getFallDamageSoundBig() {
        return CraftSound.getBukkit(this.getHandle().ey().b());
    }

    public Sound getDrinkingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.getBukkit(this.getHandle().getDrinkingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    public Sound getEatingSound(ItemStack itemStack) {
        Preconditions.checkArgument((itemStack != null ? 1 : 0) != 0, (Object)"itemStack must not be null");
        return CraftSound.getBukkit(this.getHandle().getEatingSound0(CraftItemStack.asNMSCopy(itemStack)));
    }

    public boolean canBreatheUnderwater() {
        return this.getHandle().dK();
    }

    public EntityCategory getCategory() {
        EnumMonsterType type = this.getHandle().eJ();
        if (type == EnumMonsterType.a) {
            return EntityCategory.NONE;
        }
        if (type == EnumMonsterType.b) {
            return EntityCategory.UNDEAD;
        }
        if (type == EnumMonsterType.c) {
            return EntityCategory.ARTHROPOD;
        }
        if (type == EnumMonsterType.d) {
            return EntityCategory.ILLAGER;
        }
        if (type == EnumMonsterType.e) {
            return EntityCategory.WATER;
        }
        throw new UnsupportedOperationException("Unsupported monster type: " + type + ". This is a bug, report this to Spigot.");
    }

    public boolean isInvisible() {
        return this.getHandle().ca();
    }

    public void setInvisible(boolean invisible) {
        this.getHandle().persistentInvisibility = invisible;
        this.getHandle().b(5, invisible);
    }

    public int getArrowsStuck() {
        return this.getHandle().eF();
    }

    public void setArrowsStuck(int arrows) {
        this.getHandle().o(arrows);
    }

    public int getShieldBlockingDelay() {
        return this.getHandle().getShieldBlockingDelay();
    }

    public void setShieldBlockingDelay(int delay) {
        this.getHandle().setShieldBlockingDelay(delay);
    }

    public ItemStack getActiveItem() {
        return this.getHandle().fg().asBukkitMirror();
    }

    public void clearActiveItem() {
        this.getHandle().fk();
    }

    public int getItemUseRemainingTime() {
        return this.getHandle().fh();
    }

    public int getHandRaisedTime() {
        return this.getHandle().fi();
    }

    public boolean isHandRaised() {
        return this.getHandle().fe();
    }

    public EquipmentSlot getHandRaised() {
        return this.getHandle().ff() == EnumHand.a ? EquipmentSlot.HAND : EquipmentSlot.OFF_HAND;
    }

    public boolean isJumping() {
        return this.getHandle().bi;
    }

    public void setJumping(boolean jumping) {
        this.getHandle().r(jumping);
        if (jumping && this.getHandle() instanceof EntityInsentient) {
            ((EntityInsentient)this.getHandle()).E().a();
        }
    }

    public void playPickupItemAnimation(Item item, int quantity) {
        this.getHandle().a(((CraftItem)item).getHandle(), quantity);
    }

    public float getHurtDirection() {
        return this.getHandle().ex();
    }

    public void setHurtDirection(float hurtDirection) {
        throw new UnsupportedOperationException("Cannot set the hurt direction on a non player");
    }

    public static EnumMonsterType fromBukkitEntityCategory(EntityCategory entityCategory) {
        switch (entityCategory) {
            case NONE: {
                return EnumMonsterType.a;
            }
            case UNDEAD: {
                return EnumMonsterType.b;
            }
            case ARTHROPOD: {
                return EnumMonsterType.c;
            }
            case ILLAGER: {
                return EnumMonsterType.d;
            }
            case WATER: {
                return EnumMonsterType.e;
            }
        }
        throw new IllegalArgumentException(entityCategory + " is an unrecognized entity category");
    }

    public void broadcastSlotBreak(EquipmentSlot slot) {
        this.getHandle().d(CraftEquipmentSlot.getNMS(slot));
    }

    public void broadcastSlotBreak(EquipmentSlot slot, Collection<Player> players) {
        if (players.isEmpty()) {
            return;
        }
        PacketPlayOutEntityStatus packet = new PacketPlayOutEntityStatus(this.getHandle(), EntityLiving.g(CraftEquipmentSlot.getNMS(slot)));
        players.forEach(player -> ((CraftPlayer)player).getHandle().b.a(packet));
    }

    public ItemStack damageItemStack(ItemStack stack, int amount) {
        net.minecraft.world.item.ItemStack nmsStack;
        if (stack instanceof CraftItemStack) {
            CraftItemStack craftItemStack = (CraftItemStack)stack;
            if (craftItemStack.handle == null || craftItemStack.handle.b()) {
                return stack;
            }
            nmsStack = craftItemStack.handle;
        } else {
            nmsStack = CraftItemStack.asNMSCopy(stack);
            stack = CraftItemStack.asCraftMirror(nmsStack);
        }
        this.damageItemStack0(nmsStack, amount, null);
        return stack;
    }

    public void damageItemStack(EquipmentSlot slot, int amount) {
        EnumItemSlot nmsSlot = CraftEquipmentSlot.getNMS(slot);
        this.damageItemStack0(this.getHandle().c(nmsSlot), amount, nmsSlot);
    }

    public float getBodyYaw() {
        return this.getHandle().dx();
    }

    public void setBodyYaw(float bodyYaw) {
        this.getHandle().s(bodyYaw);
    }

    private void damageItemStack0(net.minecraft.world.item.ItemStack nmsStack, int amount, EnumItemSlot slot) {
        nmsStack.a(amount, this.getHandle(), livingEntity -> {
            if (slot != null) {
                livingEntity.d(slot);
            }
        });
    }

    @NotNull
    public TriState getFrictionState() {
        return this.getHandle().frictionState;
    }

    public void setFrictionState(@NotNull TriState state) {
        Objects.requireNonNull(state, "state may not be null");
        this.getHandle().frictionState = state;
    }

    public void knockback(double strength, double directionX, double directionZ) {
        Preconditions.checkArgument((strength > 0.0 ? 1 : 0) != 0, (Object)"Knockback strength must be > 0");
        this.getHandle().q(strength, directionX, directionZ);
    }
}

