/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.destroystokyo.paper.entity.CraftRangedEntity;
import com.google.common.base.Preconditions;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftChestedHorse;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventoryLlama;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.inventory.LlamaInventory;
import org.jetbrains.annotations.NotNull;

public class CraftLlama
extends CraftChestedHorse
implements Llama,
CraftRangedEntity<EntityLlama> {
    public CraftLlama(CraftServer server, EntityLlama entity) {
        super(server, entity);
    }

    @Override
    public EntityLlama getHandle() {
        return (EntityLlama)super.getHandle();
    }

    public Llama.Color getColor() {
        return Llama.Color.values()[this.getHandle().ge().ordinal()];
    }

    public void setColor(Llama.Color color) {
        Preconditions.checkArgument((color != null ? 1 : 0) != 0, (Object)"color");
        this.getHandle().a(EntityLlama.Variant.a(color.ordinal()));
    }

    public LlamaInventory getInventory() {
        return new CraftInventoryLlama(this.getHandle().cn);
    }

    public int getStrength() {
        return this.getHandle().gc();
    }

    public void setStrength(int strength) {
        Preconditions.checkArgument((1 <= strength && strength <= 5 ? 1 : 0) != 0, (Object)"strength must be [1,5]");
        if (strength == this.getStrength()) {
            return;
        }
        this.getHandle().setStrengthPublic(strength);
        this.getHandle().go();
    }

    public Horse.Variant getVariant() {
        return Horse.Variant.LLAMA;
    }

    @Override
    public String toString() {
        return "CraftLlama";
    }

    @Override
    public EntityType getType() {
        return EntityType.LLAMA;
    }

    public boolean inCaravan() {
        return this.getHandle().gG();
    }

    public void joinCaravan(@NotNull Llama llama) {
        this.getHandle().a(((CraftLlama)llama).getHandle());
    }

    public void leaveCaravan() {
        this.getHandle().gE();
    }

    public boolean hasCaravanTail() {
        return this.getHandle().gF();
    }

    public Llama getCaravanHead() {
        return this.getHandle().gH() == null ? null : (Llama)this.getHandle().gH().getBukkitEntity();
    }

    public Llama getCaravanTail() {
        return this.getHandle().cb == null ? null : (Llama)this.getHandle().cb.getBukkitEntity();
    }
}

