/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.destroystokyo.paper.ClientOption;
import com.destroystokyo.paper.PaperSkinParts;
import com.destroystokyo.paper.Title;
import com.destroystokyo.paper.event.player.PlayerSetSpawnEvent;
import com.destroystokyo.paper.profile.CraftPlayerProfile;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.BaseEncoding;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import io.netty.buffer.Unpooled;
import io.papermc.paper.adventure.DisplayNames;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.chunk.PlayerChunkLoader;
import io.papermc.paper.entity.LookAnchor;
import io.papermc.paper.entity.TeleportFlag;
import io.papermc.paper.math.Position;
import io.papermc.paper.util.MCUtil;
import it.unimi.dsi.fastutil.shorts.Short2ObjectArrayMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.ShortArraySet;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.bossbar.HackyBossBarPlatformBridge;
import net.kyori.adventure.chat.ChatType;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.util.TriState;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.commands.arguments.ArgumentAnchor;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.OutgoingChatMessage;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.protocol.game.ClientboundClearTitlesPacket;
import net.minecraft.network.protocol.game.ClientboundCustomChatCompletionsPacket;
import net.minecraft.network.protocol.game.ClientboundDeleteChatPacket;
import net.minecraft.network.protocol.game.ClientboundHurtAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.PacketPlayOutBlockBreakAnimation;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutCustomPayload;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEffect;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntitySound;
import net.minecraft.network.protocol.game.PacketPlayOutExperience;
import net.minecraft.network.protocol.game.PacketPlayOutGameStateChange;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutMultiBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.network.protocol.game.PacketPlayOutOpenBook;
import net.minecraft.network.protocol.game.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.network.protocol.game.PacketPlayOutRespawn;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnPosition;
import net.minecraft.network.protocol.game.PacketPlayOutStopSound;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateAttributes;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateHealth;
import net.minecraft.network.protocol.game.PacketPlayOutWorldEvent;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.AdvancementDataPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerChunkMap;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.players.WhiteListEntry;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.world.EnumHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.projectile.EntityFireworks;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyInstrument;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.saveddata.maps.MapIcon;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang.Validate;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.DyeColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Instrument;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Note;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.Statistic;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.advancement.Advancement;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationCanceller;
import org.bukkit.conversations.ManuallyAbandonedConversationCanceller;
import org.bukkit.craftbukkit.v1_19_R3.CraftEffect;
import org.bukkit.craftbukkit.v1_19_R3.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_19_R3.CraftOfflinePlayer;
import org.bukkit.craftbukkit.v1_19_R3.CraftParticle;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.CraftSound;
import org.bukkit.craftbukkit.v1_19_R3.CraftStatistic;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorldBorder;
import org.bukkit.craftbukkit.v1_19_R3.advancement.CraftAdvancement;
import org.bukkit.craftbukkit.v1_19_R3.advancement.CraftAdvancementProgress;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftSign;
import org.bukkit.craftbukkit.v1_19_R3.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_19_R3.conversations.ConversationTracker;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.map.CraftMapView;
import org.bukkit.craftbukkit.v1_19_R3.map.RenderData;
import org.bukkit.craftbukkit.v1_19_R3.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerExpCooldownChangeEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerHideEntityEvent;
import org.bukkit.event.player.PlayerItemMendEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShowEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.InventoryView;
import org.bukkit.map.MapCursor;
import org.bukkit.map.MapView;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.Messenger;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.spigotmc.AsyncCatcher;

@DelegateDeserialization(value=CraftOfflinePlayer.class)
public class CraftPlayer
extends CraftHumanEntity
implements Player {
    private long firstPlayed = 0L;
    private long lastPlayed = 0L;
    private boolean hasPlayedBefore = false;
    private final ConversationTracker conversationTracker = new ConversationTracker();
    private final Set<String> channels = new HashSet<String>();
    private final Map<UUID, Set<WeakReference<Plugin>>> invertedVisibilityEntities = new HashMap<UUID, Set<WeakReference<Plugin>>>();
    private static final WeakHashMap<Plugin, WeakReference<Plugin>> pluginWeakReferences = new WeakHashMap();
    private int hash = 0;
    private double health = 20.0;
    private boolean scaledHealth = false;
    private double healthScale = 20.0;
    private CraftWorldBorder clientWorldBorder = null;
    private IWorldBorderListener clientWorldBorderListener = this.createWorldBorderListener();
    private PlayerResourcePackStatusEvent.Status resourcePackStatus;
    private String resourcePackHash;
    private static final boolean DISABLE_CHANNEL_LIMIT = System.getProperty("paper.disableChannelLimit") != null;
    private long lastSaveTime;
    private Component playerListHeader;
    private Component playerListFooter;
    private static final Component DEFAULT_KICK_COMPONENT = Component.translatable((String)"multiplayer.disconnect.kicked");
    private final Player.Spigot spigot = new Player.Spigot(){

        public InetSocketAddress getRawAddress() {
            return (InetSocketAddress)CraftPlayer.this.getHandle().b.getRawAddress();
        }

        public boolean getCollidesWithEntities() {
            return CraftPlayer.this.isCollidable();
        }

        public void setCollidesWithEntities(boolean collides) {
            CraftPlayer.this.setCollidable(collides);
        }

        public void respawn() {
            if (CraftPlayer.this.getHealth() <= 0.0 && CraftPlayer.this.isOnline()) {
                CraftPlayer.this.server.getServer().bi().respawn(CraftPlayer.this.getHandle(), false, PlayerRespawnEvent.RespawnReason.PLUGIN);
            }
        }

        public Set<Player> getHiddenPlayers() {
            HashSet<Player> ret = new HashSet<Player>();
            for (Player p2 : CraftPlayer.this.getServer().getOnlinePlayers()) {
                if (CraftPlayer.this.canSee(p2)) continue;
                ret.add(p2);
            }
            return Collections.unmodifiableSet(ret);
        }

        public void sendMessage(BaseComponent component) {
            this.sendMessage(new BaseComponent[]{component});
        }

        public void sendMessage(BaseComponent ... components) {
            this.sendMessage(ChatMessageType.SYSTEM, components);
        }

        public void sendMessage(UUID sender, BaseComponent component) {
            this.sendMessage(ChatMessageType.CHAT, sender, component);
        }

        public void sendMessage(UUID sender, BaseComponent ... components) {
            this.sendMessage(ChatMessageType.CHAT, sender, components);
        }

        public void sendMessage(ChatMessageType position, BaseComponent component) {
            this.sendMessage(position, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, BaseComponent ... components) {
            this.sendMessage(position, (UUID)null, components);
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent component) {
            this.sendMessage(position, sender, new BaseComponent[]{component});
        }

        public void sendMessage(ChatMessageType position, UUID sender, BaseComponent ... components) {
            if (CraftPlayer.this.getHandle().b == null) {
                return;
            }
            CraftPlayer.this.getHandle().b.a(new ClientboundSystemChatPacket(components, position == ChatMessageType.ACTION_BAR));
        }

        public int getPing() {
            return CraftPlayer.this.getHandle().e;
        }
    };

    public CraftPlayer(CraftServer server, EntityPlayer entity) {
        super(server, entity);
        this.firstPlayed = System.currentTimeMillis();
    }

    public int getViewDistance() {
        PlayerChunkMap chunkMap = this.getHandle().x().k().a;
        PlayerChunkLoader.PlayerLoaderData data = chunkMap.playerChunkManager.getData(this.getHandle());
        if (data == null) {
            return chunkMap.playerChunkManager.getTargetNoTickViewDistance();
        }
        return data.getTargetNoTickViewDistance();
    }

    public void setViewDistance(int viewDistance) {
        PlayerChunkMap chunkMap = this.getHandle().x().k().a;
        PlayerChunkLoader.PlayerLoaderData data = chunkMap.playerChunkManager.getData(this.getHandle());
        if (data == null) {
            throw new IllegalStateException("Player is not attached to world");
        }
        data.setTargetNoTickViewDistance(viewDistance);
    }

    public int getSimulationDistance() {
        PlayerChunkMap chunkMap = this.getHandle().x().k().a;
        PlayerChunkLoader.PlayerLoaderData data = chunkMap.playerChunkManager.getData(this.getHandle());
        if (data == null) {
            return chunkMap.playerChunkManager.getTargetTickViewDistance();
        }
        return data.getTargetTickViewDistance();
    }

    public void setSimulationDistance(int simulationDistance) {
        PlayerChunkMap chunkMap = this.getHandle().x().k().a;
        PlayerChunkLoader.PlayerLoaderData data = chunkMap.playerChunkManager.getData(this.getHandle());
        if (data == null) {
            throw new IllegalStateException("Player is not attached to world");
        }
        data.setTargetTickViewDistance(simulationDistance);
    }

    public int getNoTickViewDistance() {
        return this.getViewDistance();
    }

    public void setNoTickViewDistance(int viewDistance) {
        this.setViewDistance(viewDistance);
    }

    public int getSendViewDistance() {
        PlayerChunkMap chunkMap = this.getHandle().x().k().a;
        PlayerChunkLoader.PlayerLoaderData data = chunkMap.playerChunkManager.getData(this.getHandle());
        if (data == null) {
            return chunkMap.playerChunkManager.getTargetSendDistance();
        }
        return data.getTargetSendViewDistance();
    }

    public void setSendViewDistance(int viewDistance) {
        PlayerChunkMap chunkMap = this.getHandle().x().k().a;
        PlayerChunkLoader.PlayerLoaderData data = chunkMap.playerChunkManager.getData(this.getHandle());
        if (data == null) {
            throw new IllegalStateException("Player is not attached to world");
        }
        data.setTargetSendViewDistance(viewDistance);
    }

    public GameProfile getProfile() {
        return this.getHandle().fI();
    }

    @Override
    public boolean isOp() {
        return this.server.getHandle().f(this.getProfile());
    }

    @Override
    public void setOp(boolean value) {
        if (value == this.isOp()) {
            return;
        }
        if (value) {
            this.server.getHandle().a(this.getProfile());
        } else {
            this.server.getHandle().b(this.getProfile());
        }
        this.perm.recalculatePermissions();
    }

    public boolean isOnline() {
        return this.server.getPlayer(this.getUniqueId()) != null;
    }

    public InetSocketAddress getAddress() {
        if (this.getHandle().b == null) {
            return null;
        }
        SocketAddress addr = this.getHandle().b.e();
        if (addr instanceof InetSocketAddress) {
            return (InetSocketAddress)addr;
        }
        return null;
    }

    public int getProtocolVersion() {
        if (this.getHandle().b == null) {
            return -1;
        }
        return this.getHandle().b.h.protocolVersion;
    }

    public InetSocketAddress getVirtualHost() {
        if (this.getHandle().b == null) {
            return null;
        }
        return this.getHandle().b.h.virtualHost;
    }

    @Override
    public double getEyeHeight(boolean ignorePose) {
        if (ignorePose) {
            return 1.62;
        }
        return this.getEyeHeight();
    }

    public void sendRawMessage(String message) {
        if (this.getHandle().b == null) {
            return;
        }
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.getHandle().a(component);
        }
    }

    public void sendRawMessage(UUID sender, String message) {
        if (this.getHandle().b == null) {
            return;
        }
        for (IChatBaseComponent component : CraftChatMessage.fromString(message)) {
            this.getHandle().a(component);
        }
    }

    @Override
    public void sendMessage(String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(message);
        }
    }

    @Override
    public void sendMessage(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String message) {
        if (!this.conversationTracker.isConversingModaly()) {
            this.sendRawMessage(sender, message);
        }
    }

    @Override
    public void sendMessage(UUID sender, String ... messages) {
        for (String message : messages) {
            this.sendMessage(sender, message);
        }
    }

    @Deprecated
    public void sendActionBar(BaseComponent[] message) {
        if (this.getHandle().b == null) {
            return;
        }
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket((IChatBaseComponent)null);
        packet.components = message;
        this.getHandle().b.a(packet);
    }

    @Deprecated
    public void sendActionBar(String message) {
        if (this.getHandle().b == null || message == null || message.isEmpty()) {
            return;
        }
        this.getHandle().b.a(new ClientboundSetActionBarTextPacket(CraftChatMessage.fromStringOrNull(message)));
    }

    @Deprecated
    public void sendActionBar(char alternateChar, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        this.sendActionBar(ChatColor.translateAlternateColorCodes((char)alternateChar, (String)message));
    }

    public void setPlayerListHeaderFooter(BaseComponent[] header, BaseComponent[] footer) {
        if (header != null) {
            String headerJson = ComponentSerializer.toString((BaseComponent[])header);
            this.playerListHeader = GsonComponentSerializer.gson().deserialize((Object)headerJson);
        } else {
            this.playerListHeader = null;
        }
        if (footer != null) {
            String footerJson = ComponentSerializer.toString((BaseComponent[])footer);
            this.playerListFooter = GsonComponentSerializer.gson().deserialize((Object)footerJson);
        } else {
            this.playerListFooter = null;
        }
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(BaseComponent header, BaseComponent footer) {
        BaseComponent[] baseComponentArray;
        BaseComponent[] baseComponentArray2;
        if (header == null) {
            baseComponentArray2 = null;
        } else {
            BaseComponent[] baseComponentArray3 = new BaseComponent[1];
            baseComponentArray2 = baseComponentArray3;
            baseComponentArray3[0] = header;
        }
        if (footer == null) {
            baseComponentArray = null;
        } else {
            BaseComponent[] baseComponentArray4 = new BaseComponent[1];
            baseComponentArray = baseComponentArray4;
            baseComponentArray4[0] = footer;
        }
        this.setPlayerListHeaderFooter(baseComponentArray2, baseComponentArray);
    }

    public void setTitleTimes(int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.getHandle().b.a(new ClientboundSetTitlesAnimationPacket(fadeInTicks, stayTicks, fadeOutTicks));
    }

    public void setSubtitle(BaseComponent[] subtitle) {
        ClientboundSetSubtitleTextPacket packet = new ClientboundSetSubtitleTextPacket((IChatBaseComponent)null);
        packet.components = subtitle;
        this.getHandle().b.a(packet);
    }

    public void setSubtitle(BaseComponent subtitle) {
        this.setSubtitle(new BaseComponent[]{subtitle});
    }

    public void showTitle(BaseComponent[] title) {
        ClientboundSetTitleTextPacket packet = new ClientboundSetTitleTextPacket((IChatBaseComponent)null);
        packet.components = title;
        this.getHandle().b.a(packet);
    }

    public void showTitle(BaseComponent title) {
        this.showTitle(new BaseComponent[]{title});
    }

    public void showTitle(BaseComponent[] title, BaseComponent[] subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void showTitle(BaseComponent title, BaseComponent subtitle, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        this.setTitleTimes(fadeInTicks, stayTicks, fadeOutTicks);
        this.setSubtitle(subtitle);
        this.showTitle(title);
    }

    public void sendTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        this.setSubtitle(title.getSubtitle() == null ? new BaseComponent[]{} : title.getSubtitle());
        this.showTitle(title.getTitle());
    }

    public void updateTitle(Title title) {
        Preconditions.checkNotNull((Object)title, (Object)"Title is null");
        this.setTitleTimes(title.getFadeIn(), title.getStay(), title.getFadeOut());
        if (title.getSubtitle() != null) {
            this.setSubtitle(title.getSubtitle());
        }
        this.showTitle(title.getTitle());
    }

    public void hideTitle() {
        this.getHandle().b.a(new ClientboundClearTitlesPacket(false));
    }

    public String getDisplayName() {
        return DisplayNames.getLegacy(this);
    }

    public void setDisplayName(String name) {
        this.getHandle().adventure$displayName = name != null ? LegacyComponentSerializer.legacySection().deserialize(name) : Component.text((String)this.getName());
        this.getHandle().displayName = name == null ? this.getName() : name;
    }

    public void playerListName(Component name) {
        this.getHandle().listName = name == null ? null : PaperAdventure.asVanilla(name);
        for (EntityPlayer player : this.server.getHandle().k) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.b.a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, this.getHandle()));
        }
    }

    public Component playerListName() {
        return this.getHandle().listName == null ? Component.text((String)this.getName()) : PaperAdventure.asAdventure(this.getHandle().listName);
    }

    public Component playerListHeader() {
        return this.playerListHeader;
    }

    public Component playerListFooter() {
        return this.playerListFooter;
    }

    public String getPlayerListName() {
        return this.getHandle().listName == null ? this.getName() : CraftChatMessage.fromComponent(this.getHandle().listName);
    }

    public void setPlayerListName(String name) {
        if (name == null) {
            name = this.getName();
        }
        this.getHandle().listName = name.equals(this.getName()) ? null : CraftChatMessage.fromStringOrNull(name);
        for (EntityPlayer player : this.server.getHandle().k) {
            if (!player.getBukkitEntity().canSee(this)) continue;
            player.b.a(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.f, this.getHandle()));
        }
    }

    public String getPlayerListHeader() {
        return this.playerListHeader == null ? null : LegacyComponentSerializer.legacySection().serialize(this.playerListHeader);
    }

    public String getPlayerListFooter() {
        return this.playerListFooter == null ? null : LegacyComponentSerializer.legacySection().serialize(this.playerListFooter);
    }

    public void setPlayerListHeader(String header) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListFooter(String footer) {
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    public void setPlayerListHeaderFooter(String header, String footer) {
        this.playerListHeader = header == null ? null : LegacyComponentSerializer.legacySection().deserialize(header);
        this.playerListFooter = footer == null ? null : LegacyComponentSerializer.legacySection().deserialize(footer);
        this.updatePlayerListHeaderFooter();
    }

    private void updatePlayerListHeaderFooter() {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter(this.playerListHeader == null ? IChatBaseComponent.h() : PaperAdventure.asVanilla(this.playerListHeader), this.playerListFooter == null ? IChatBaseComponent.h() : PaperAdventure.asVanilla(this.playerListFooter));
        this.getHandle().b.a(packet);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OfflinePlayer)) {
            return false;
        }
        OfflinePlayer other = (OfflinePlayer)obj;
        if (this.getUniqueId() == null || other.getUniqueId() == null) {
            return false;
        }
        boolean uuidEquals = this.getUniqueId().equals(other.getUniqueId());
        boolean idEquals = true;
        if (other instanceof CraftPlayer) {
            idEquals = this.getEntityId() == ((CraftPlayer)other).getEntityId();
        }
        return uuidEquals && idEquals;
    }

    public void kickPlayer(String message) {
        AsyncCatcher.catchOp("player kick");
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.disconnect(message == null ? "" : message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick() {
        this.kick(DEFAULT_KICK_COMPONENT);
    }

    public void kick(Component message) {
        this.kick(message, PlayerKickEvent.Cause.PLUGIN);
    }

    public void kick(Component message, PlayerKickEvent.Cause cause) {
        AsyncCatcher.catchOp("player kick");
        PlayerConnection connection = this.getHandle().b;
        if (connection != null) {
            connection.disconnect((Component)(message == null ? Component.empty() : message), cause);
        }
    }

    public <T> T getClientOption(ClientOption<T> type) {
        if (ClientOption.SKIN_PARTS == type) {
            return type.getType().cast(new PaperSkinParts(this.getHandle().aj().a(EntityHuman.bJ).byteValue()));
        }
        if (ClientOption.CHAT_COLORS_ENABLED == type) {
            return type.getType().cast(this.getHandle().z());
        }
        if (ClientOption.CHAT_VISIBILITY == type) {
            return type.getType().cast(this.getHandle().A() == null ? ClientOption.ChatVisibility.UNKNOWN : ClientOption.ChatVisibility.valueOf((String)this.getHandle().A().name()));
        }
        if (ClientOption.LOCALE == type) {
            return type.getType().cast(this.getLocale());
        }
        if (ClientOption.MAIN_HAND == type) {
            return type.getType().cast(this.getMainHand());
        }
        if (ClientOption.VIEW_DISTANCE == type) {
            return type.getType().cast(this.getClientViewDistance());
        }
        if (ClientOption.ALLOW_SERVER_LISTINGS == type) {
            return type.getType().cast(this.getHandle().V());
        }
        if (ClientOption.TEXT_FILTERING_ENABLED == type) {
            return type.getType().cast(this.getHandle().U());
        }
        throw new RuntimeException("Unknown settings type");
    }

    public Firework boostElytra(org.bukkit.inventory.ItemStack firework) {
        Validate.isTrue((boolean)this.isGliding(), (String)"Player must be gliding");
        Validate.isTrue((firework != null ? 1 : 0) != 0, (String)"firework == null");
        Validate.isTrue((firework.getType() == Material.FIREWORK_ROCKET ? 1 : 0) != 0, (String)"Firework must be Material.FIREWORK_ROCKET");
        ItemStack item = CraftItemStack.asNMSCopy(firework);
        WorldServer world = ((CraftWorld)this.getWorld()).getHandle();
        EntityFireworks entity = new EntityFireworks(world, item, this.getHandle());
        return world.b(entity) ? (Firework)entity.getBukkitEntity() : null;
    }

    public void sendOpLevel(byte level) {
        Preconditions.checkArgument((level >= 0 && level <= 4 ? 1 : 0) != 0, (Object)"Level must be within [0, 4]");
        this.getHandle().cH().ac().sendPlayerPermissionLevel(this.getHandle(), level, false);
    }

    public void addAdditionalChatCompletions(@NotNull Collection<String> completions) {
        this.getHandle().b.a(new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.a, new ArrayList<String>(completions)));
    }

    public void removeAdditionalChatCompletions(@NotNull Collection<String> completions) {
        this.getHandle().b.a(new ClientboundCustomChatCompletionsPacket(ClientboundCustomChatCompletionsPacket.Action.b, new ArrayList<String>(completions)));
    }

    public void setCompassTarget(Location loc) {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutSpawnPosition(CraftLocation.toBlockPosition(loc), loc.getYaw()));
    }

    public Location getCompassTarget() {
        return this.getHandle().compassTarget;
    }

    public void chat(String msg) {
        if (this.getHandle().b == null) {
            return;
        }
        if (PlayerConnection.c(msg)) {
            this.getHandle().b.disconnect(IChatBaseComponent.c("multiplayer.disconnect.illegal_characters"), PlayerKickEvent.Cause.ILLEGAL_CHARACTERS);
        } else if (msg.startsWith("/")) {
            this.getHandle().b.handleCommand(msg);
        } else {
            PlayerChatMessage playerChatMessage = PlayerChatMessage.a(msg).withResult(new ChatDecorator.ModernResult(IChatBaseComponent.b(msg), true, false));
            this.getHandle().b.chat(msg, playerChatMessage, false);
        }
    }

    public boolean performCommand(String command) {
        return this.server.dispatchCommand((CommandSender)this, command);
    }

    public void playNote(Location loc, byte instrument, byte note) {
        if (this.getHandle().b == null) {
            return;
        }
        String instrumentName = null;
        switch (instrument) {
            case 0: {
                instrumentName = "harp";
                break;
            }
            case 1: {
                instrumentName = "basedrum";
                break;
            }
            case 2: {
                instrumentName = "snare";
                break;
            }
            case 3: {
                instrumentName = "hat";
                break;
            }
            case 4: {
                instrumentName = "bass";
                break;
            }
            case 5: {
                instrumentName = "flute";
                break;
            }
            case 6: {
                instrumentName = "bell";
                break;
            }
            case 7: {
                instrumentName = "guitar";
                break;
            }
            case 8: {
                instrumentName = "chime";
                break;
            }
            case 9: {
                instrumentName = "xylophone";
            }
        }
        float f2 = (float)Math.pow(2.0, ((double)note - 12.0) / 12.0);
        this.getHandle().b.a(new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(CraftSound.getSoundEffect("block.note_block." + instrumentName)), net.minecraft.sounds.SoundCategory.c, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, f2, this.getHandle().dZ().g()));
    }

    public void playNote(Location loc, Instrument instrument, Note note) {
        if (this.getHandle().b == null) {
            return;
        }
        BlockPropertyInstrument nms = CraftBlockData.toNMS(instrument, BlockPropertyInstrument.class);
        float f2 = nms.b() ? (float)Math.pow(2.0, ((double)note.getId() - 12.0) / 12.0) : 1.0f;
        if (!nms.d()) {
            this.getHandle().b.a(new PacketPlayOutNamedSoundEffect(nms.a(), net.minecraft.sounds.SoundCategory.c, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), 3.0f, f2, this.getHandle().dZ().g()));
        }
    }

    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, String sound, float volume, float pitch) {
        this.playSound(loc, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Location loc, Sound sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().b == null) {
            return;
        }
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(BuiltInRegistries.c.d(CraftSound.getSoundEffect(sound)), net.minecraft.sounds.SoundCategory.valueOf(category.name()), loc.getX(), loc.getY(), loc.getZ(), volume, pitch, this.getHandle().dZ().g());
        this.getHandle().b.a(packet);
    }

    public void playSound(Location loc, String sound, SoundCategory category, float volume, float pitch) {
        if (loc == null || sound == null || category == null || this.getHandle().b == null) {
            return;
        }
        PacketPlayOutNamedSoundEffect packet = new PacketPlayOutNamedSoundEffect(Holder.a(SoundEffect.a(new MinecraftKey(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), loc.getX(), loc.getY(), loc.getZ(), volume, pitch, this.getHandle().dZ().g());
        this.getHandle().b.a(packet);
    }

    public void playSound(Entity entity, Sound sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, String sound, float volume, float pitch) {
        this.playSound(entity, sound, SoundCategory.MASTER, volume, pitch);
    }

    public void playSound(Entity entity, Sound sound, SoundCategory category, float volume, float pitch) {
        CraftEntity craftEntity;
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().b != null) break block3;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(BuiltInRegistries.c.d(CraftSound.getSoundEffect(sound)), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, this.getHandle().dZ().g());
        this.getHandle().b.a(packet);
    }

    public void playSound(Entity entity, String sound, SoundCategory category, float volume, float pitch) {
        CraftEntity craftEntity;
        block3: {
            block2: {
                if (!(entity instanceof CraftEntity)) break block2;
                craftEntity = (CraftEntity)entity;
                if (sound != null && category != null && this.getHandle().b != null) break block3;
            }
            return;
        }
        PacketPlayOutEntitySound packet = new PacketPlayOutEntitySound(Holder.a(SoundEffect.a(new MinecraftKey(sound))), net.minecraft.sounds.SoundCategory.valueOf(category.name()), craftEntity.getHandle(), volume, pitch, this.getHandle().dZ().g());
        this.getHandle().b.a(packet);
    }

    public void stopSound(Sound sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(String sound) {
        this.stopSound(sound, null);
    }

    public void stopSound(Sound sound, SoundCategory category) {
        this.stopSound(sound.getKey().getKey(), category);
    }

    public void stopSound(String sound, SoundCategory category) {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutStopSound(new MinecraftKey(sound), category == null ? net.minecraft.sounds.SoundCategory.a : net.minecraft.sounds.SoundCategory.valueOf(category.name())));
    }

    public void stopSound(SoundCategory category) {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutStopSound(null, net.minecraft.sounds.SoundCategory.valueOf(category.name())));
    }

    public void stopAllSounds() {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutStopSound(null, null));
    }

    public void playEffect(Location loc, Effect effect, int data) {
        if (this.getHandle().b == null) {
            return;
        }
        int packetData = effect.getId();
        PacketPlayOutWorldEvent packet = new PacketPlayOutWorldEvent(packetData, CraftLocation.toBlockPosition(loc), data, false);
        this.getHandle().b.a(packet);
    }

    public <T> void playEffect(Location loc, Effect effect, T data) {
        if (data != null) {
            Validate.isTrue((effect.getData() != null && effect.getData().isAssignableFrom(data.getClass()) ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null || effect == Effect.ELECTRIC_SPARK ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        int datavalue = CraftEffect.getDataValue(effect, data);
        this.playEffect(loc, effect, datavalue);
    }

    public boolean breakBlock(Block block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        Preconditions.checkArgument((boolean)block.getWorld().equals(this.getWorld()), (Object)"Cannot break blocks across worlds");
        return this.getHandle().d.a(new BlockPosition(block.getX(), block.getY(), block.getZ()));
    }

    public void sendBlockChange(Location loc, Material material, byte data) {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(CraftLocation.toBlockPosition(loc), CraftMagicNumbers.getBlock(material, data));
        this.getHandle().b.a(packet);
    }

    public void sendBlockChange(Location loc, BlockData block) {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutBlockChange packet = new PacketPlayOutBlockChange(CraftLocation.toBlockPosition(loc), ((CraftBlockData)block).getState());
        this.getHandle().b.a(packet);
    }

    public void sendMultiBlockChange(Map<? extends Position, BlockData> blockChanges, boolean suppressLightUpdates) {
        if (this.getHandle().b == null) {
            return;
        }
        HashMap<SectionPosition, Short2ObjectMap> sectionMap = new HashMap<SectionPosition, Short2ObjectMap>();
        for (Map.Entry<? extends Position, BlockData> entry : blockChanges.entrySet()) {
            BlockData blockData = entry.getValue();
            BlockPosition blockPos = MCUtil.toBlockPos(entry.getKey());
            SectionPosition sectionPos = SectionPosition.a(blockPos);
            Short2ObjectMap sectionData = sectionMap.computeIfAbsent(sectionPos, key -> new Short2ObjectArrayMap());
            sectionData.put(SectionPosition.b(blockPos), (Object)((CraftBlockData)blockData).getState());
        }
        for (Map.Entry<Object, Object> entry : sectionMap.entrySet()) {
            SectionPosition sectionPos = (SectionPosition)entry.getKey();
            Short2ObjectMap blockData = (Short2ObjectMap)entry.getValue();
            PacketPlayOutMultiBlockChange packet = new PacketPlayOutMultiBlockChange(sectionPos, (Short2ObjectMap<IBlockData>)blockData, suppressLightUpdates);
            this.getHandle().b.a(packet);
        }
    }

    public void sendBlockChanges(Collection<BlockState> blocks, boolean suppressLightUpdates) {
        Preconditions.checkArgument((blocks != null ? 1 : 0) != 0, (Object)"blocks must not be null");
        if (this.getHandle().b == null || blocks.isEmpty()) {
            return;
        }
        HashMap<SectionPosition, ChunkSectionChanges> changes = new HashMap<SectionPosition, ChunkSectionChanges>();
        for (BlockState blockState : blocks) {
            CraftBlockState cstate = (CraftBlockState)blockState;
            BlockPosition blockPosition = cstate.getPosition();
            SectionPosition sectionPosition = SectionPosition.a(blockPosition);
            ChunkSectionChanges sectionChanges = changes.computeIfAbsent(sectionPosition, ignore -> new ChunkSectionChanges());
            sectionChanges.positions().add(SectionPosition.b(blockPosition));
            sectionChanges.blockData().add(cstate.getHandle());
        }
        for (Map.Entry entry : changes.entrySet()) {
            ChunkSectionChanges chunkChanges = (ChunkSectionChanges)entry.getValue();
            PacketPlayOutMultiBlockChange packet = new PacketPlayOutMultiBlockChange((SectionPosition)entry.getKey(), chunkChanges.positions(), (IBlockData[])chunkChanges.blockData().toArray(IBlockData[]::new), suppressLightUpdates);
            this.getHandle().b.a(packet);
        }
    }

    public void sendBlockDamage(Location loc, float progress) {
        this.sendBlockDamage(loc, progress, this.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, Entity source) {
        Preconditions.checkArgument((source != null ? 1 : 0) != 0, (Object)"source must not be null");
        this.sendBlockDamage(loc, progress, source.getEntityId());
    }

    public void sendBlockDamage(Location loc, float progress, int sourceId) {
        Preconditions.checkArgument((loc != null ? 1 : 0) != 0, (Object)"loc must not be null");
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (Object)"progress must be between 0.0 and 1.0 (inclusive)");
        if (this.getHandle().b == null) {
            return;
        }
        int stage = (int)(9.0f * progress);
        if (progress == 0.0f) {
            stage = -1;
        }
        PacketPlayOutBlockBreakAnimation packet = new PacketPlayOutBlockBreakAnimation(sourceId, CraftLocation.toBlockPosition(loc), stage);
        this.getHandle().b.a(packet);
    }

    public void sendSignChange(Location loc, @Nullable List<? extends Component> lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().b == null) {
            return;
        }
        if (lines == null) {
            lines = new ArrayList<Component>(4);
        }
        Validate.notNull((Object)loc, (String)"Location cannot be null");
        Validate.notNull((Object)dyeColor, (String)"DyeColor cannot be null");
        if (lines.size() < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    public void sendSignChange(Location loc, String[] lines) {
        this.sendSignChange(loc, lines, DyeColor.BLACK);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor) {
        this.sendSignChange(loc, lines, dyeColor, false);
    }

    public void sendSignChange(Location loc, String[] lines, DyeColor dyeColor, boolean hasGlowingText) {
        if (this.getHandle().b == null) {
            return;
        }
        if (lines == null) {
            lines = new String[4];
        }
        Validate.notNull((Object)loc, (String)"Location can not be null");
        Validate.notNull((Object)dyeColor, (String)"DyeColor can not be null");
        if (lines.length < 4) {
            throw new IllegalArgumentException("Must have at least 4 lines");
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(lines);
        this.sendSignChange0(components, loc, dyeColor, hasGlowingText);
    }

    private void sendSignChange0(IChatBaseComponent[] components, Location loc, DyeColor dyeColor, boolean hasGlowingText) {
        TileEntitySign sign = new TileEntitySign(CraftLocation.toBlockPosition(loc), Blocks.cD.o());
        sign.a(EnumColor.a(dyeColor.getWoolData()));
        sign.b(hasGlowingText);
        for (int i2 = 0; i2 < components.length; ++i2) {
            sign.a(i2, components[i2]);
        }
        this.getHandle().b.a(sign.f());
    }

    public void sendEquipmentChange(LivingEntity entity, EquipmentSlot slot, org.bukkit.inventory.ItemStack item) {
        this.sendEquipmentChange(entity, Map.of(slot, item));
    }

    public void sendEquipmentChange(LivingEntity entity, Map<EquipmentSlot, org.bukkit.inventory.ItemStack> items) {
        Preconditions.checkArgument((entity != null ? 1 : 0) != 0, (Object)"entity must not be null");
        Preconditions.checkArgument((items != null ? 1 : 0) != 0, (Object)"items must not be null");
        if (this.getHandle().b == null) {
            return;
        }
        ArrayList<Pair<EnumItemSlot, ItemStack>> equipment = new ArrayList<Pair<EnumItemSlot, ItemStack>>(items.size());
        for (Map.Entry<EquipmentSlot, org.bukkit.inventory.ItemStack> entry : items.entrySet()) {
            EquipmentSlot slot = entry.getKey();
            Preconditions.checkArgument((slot != null ? 1 : 0) != 0, (Object)"Cannot set null EquipmentSlot");
            equipment.add((Pair<EnumItemSlot, ItemStack>)new Pair((Object)CraftEquipmentSlot.getNMS(slot), (Object)CraftItemStack.asNMSCopy(entry.getValue())));
        }
        this.getHandle().b.a(new PacketPlayOutEntityEquipment(entity.getEntityId(), equipment));
    }

    public WorldBorder getWorldBorder() {
        return this.clientWorldBorder;
    }

    public void setWorldBorder(WorldBorder border) {
        net.minecraft.world.level.border.WorldBorder newWorldBorder;
        CraftWorldBorder craftBorder = (CraftWorldBorder)border;
        if (border != null && !craftBorder.isVirtual() && !craftBorder.getWorld().equals(this.getWorld())) {
            throw new UnsupportedOperationException("Cannot set player world border to that of another world");
        }
        if (this.clientWorldBorder != null) {
            this.clientWorldBorder.getHandle().b(this.clientWorldBorderListener);
        }
        if (craftBorder == null || !craftBorder.isVirtual()) {
            this.clientWorldBorder = null;
            newWorldBorder = ((CraftWorldBorder)this.getWorld().getWorldBorder()).getHandle();
        } else {
            this.clientWorldBorder = craftBorder;
            this.clientWorldBorder.getHandle().a(this.clientWorldBorderListener);
            newWorldBorder = this.clientWorldBorder.getHandle();
        }
        PlayerConnection connection = this.getHandle().b;
        connection.a(new ClientboundSetBorderSizePacket(newWorldBorder));
        connection.a(new ClientboundSetBorderLerpSizePacket(newWorldBorder));
        connection.a(new ClientboundSetBorderCenterPacket(newWorldBorder));
        connection.a(new ClientboundSetBorderWarningDelayPacket(newWorldBorder));
        connection.a(new ClientboundSetBorderWarningDistancePacket(newWorldBorder));
    }

    private IWorldBorderListener createWorldBorderListener() {
        return new IWorldBorderListener(){

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, double size) {
                CraftPlayer.this.getHandle().b.a(new ClientboundSetBorderSizePacket(border));
            }

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, double fromSize, double toSize, long time) {
                CraftPlayer.this.getHandle().b.a(new ClientboundSetBorderLerpSizePacket(border));
            }

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, double centerX, double centerZ) {
                CraftPlayer.this.getHandle().b.a(new ClientboundSetBorderCenterPacket(border));
            }

            @Override
            public void a(net.minecraft.world.level.border.WorldBorder border, int warningTime) {
                CraftPlayer.this.getHandle().b.a(new ClientboundSetBorderWarningDelayPacket(border));
            }

            @Override
            public void b(net.minecraft.world.level.border.WorldBorder border, int warningBlockDistance) {
                CraftPlayer.this.getHandle().b.a(new ClientboundSetBorderWarningDistancePacket(border));
            }

            @Override
            public void b(net.minecraft.world.level.border.WorldBorder border, double damagePerBlock) {
            }

            @Override
            public void c(net.minecraft.world.level.border.WorldBorder border, double safeZoneRadius) {
            }
        };
    }

    public boolean hasClientWorldBorder() {
        return this.clientWorldBorder != null;
    }

    public void sendMap(MapView map) {
        if (this.getHandle().b == null) {
            return;
        }
        RenderData data = ((CraftMapView)map).render(this);
        ArrayList<MapIcon> icons = new ArrayList<MapIcon>();
        for (MapCursor cursor : data.cursors) {
            if (!cursor.isVisible()) continue;
            icons.add(new MapIcon(MapIcon.Type.a(cursor.getRawType()), cursor.getX(), cursor.getY(), cursor.getDirection(), CraftChatMessage.fromStringOrNull(cursor.getCaption())));
        }
        PacketPlayOutMap packet = new PacketPlayOutMap(map.getId(), map.getScale().getValue(), map.isLocked(), icons, new WorldMap.b(0, 0, 128, 128, data.buffer));
        this.getHandle().b.a(packet);
    }

    public void sendHurtAnimation(float yaw) {
        if (this.getHandle().b == null) {
            return;
        }
        float actualYaw = yaw + 90.0f;
        this.getHandle().b.a(new ClientboundHurtAnimationPacket(this.getEntityId(), actualYaw));
    }

    public void addCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.a);
    }

    public void removeCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.b);
    }

    public void setCustomChatCompletions(Collection<String> completions) {
        this.sendCustomChatCompletionPacket(completions, ClientboundCustomChatCompletionsPacket.Action.c);
    }

    private void sendCustomChatCompletionPacket(Collection<String> completions, ClientboundCustomChatCompletionsPacket.Action action) {
        if (this.getHandle().b == null) {
            return;
        }
        ClientboundCustomChatCompletionsPacket packet = new ClientboundCustomChatCompletionsPacket(action, new ArrayList<String>(completions));
        this.getHandle().b.a(packet);
    }

    public void showWinScreen() {
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutGameStateChange packet = new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.e, 1.0f);
        this.getHandle().b.a(packet);
    }

    public boolean hasSeenWinScreen() {
        return this.getHandle().cE;
    }

    public void setHasSeenWinScreen(boolean hasSeenWinScreen) {
        this.getHandle().cE = hasSeenWinScreen;
    }

    @Override
    public void setRotation(float yaw, float pitch) {
        Location targetLocation = this.getEyeLocation();
        targetLocation.setYaw(yaw);
        targetLocation.setPitch(pitch);
        Vector direction = targetLocation.getDirection();
        targetLocation.add(direction);
        this.lookAt((Position)targetLocation, LookAnchor.EYES);
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause) {
        return this.teleport(location, cause, new TeleportFlag[0]);
    }

    public void lookAt(@NotNull Entity entity, @NotNull LookAnchor playerAnchor, @NotNull LookAnchor entityAnchor) {
        this.getHandle().a(CraftPlayer.toNmsAnchor(playerAnchor), ((CraftEntity)entity).getHandle(), CraftPlayer.toNmsAnchor(entityAnchor));
    }

    public void lookAt(double x2, double y2, double z2, @NotNull LookAnchor playerAnchor) {
        this.getHandle().a(CraftPlayer.toNmsAnchor(playerAnchor), new Vec3D(x2, y2, z2));
    }

    public static ArgumentAnchor.Anchor toNmsAnchor(LookAnchor nmsAnchor) {
        return switch (nmsAnchor) {
            default -> throw new IncompatibleClassChangeError();
            case LookAnchor.EYES -> ArgumentAnchor.Anchor.b;
            case LookAnchor.FEET -> ArgumentAnchor.Anchor.a;
        };
    }

    public static LookAnchor toApiAnchor(ArgumentAnchor.Anchor playerAnchor) {
        return switch (playerAnchor) {
            default -> throw new IncompatibleClassChangeError();
            case ArgumentAnchor.Anchor.b -> LookAnchor.EYES;
            case ArgumentAnchor.Anchor.a -> LookAnchor.FEET;
        };
    }

    public static RelativeMovement toNmsRelativeFlag(TeleportFlag.Relative apiFlag) {
        return switch (apiFlag) {
            default -> throw new IncompatibleClassChangeError();
            case TeleportFlag.Relative.X -> RelativeMovement.a;
            case TeleportFlag.Relative.Y -> RelativeMovement.b;
            case TeleportFlag.Relative.Z -> RelativeMovement.c;
            case TeleportFlag.Relative.PITCH -> RelativeMovement.e;
            case TeleportFlag.Relative.YAW -> RelativeMovement.d;
        };
    }

    public static TeleportFlag.Relative toApiRelativeFlag(RelativeMovement nmsFlag) {
        return switch (nmsFlag) {
            default -> throw new IncompatibleClassChangeError();
            case RelativeMovement.a -> TeleportFlag.Relative.X;
            case RelativeMovement.b -> TeleportFlag.Relative.Y;
            case RelativeMovement.c -> TeleportFlag.Relative.Z;
            case RelativeMovement.e -> TeleportFlag.Relative.PITCH;
            case RelativeMovement.d -> TeleportFlag.Relative.YAW;
        };
    }

    @Override
    public boolean teleport(Location location, PlayerTeleportEvent.TeleportCause cause, TeleportFlag ... flags) {
        Set<TeleportFlag> allFlags;
        Set<RelativeMovement> relativeArguments;
        if (flags.length == 0) {
            relativeArguments = Set.of();
            allFlags = Set.of();
        } else {
            relativeArguments = EnumSet.noneOf(RelativeMovement.class);
            allFlags = new HashSet();
            for (TeleportFlag flag : flags) {
                if (flag instanceof TeleportFlag.Relative) {
                    TeleportFlag.Relative relativeTeleportFlag = (TeleportFlag.Relative)flag;
                    relativeArguments.add(CraftPlayer.toNmsRelativeFlag(relativeTeleportFlag));
                }
                allFlags.add(flag);
            }
        }
        boolean dismount = !allFlags.contains(TeleportFlag.EntityState.RETAIN_VEHICLE);
        boolean ignorePassengers = allFlags.contains(TeleportFlag.EntityState.RETAIN_PASSENGERS);
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location");
        Preconditions.checkArgument((location.getWorld() != null ? 1 : 0) != 0, (Object)"location.world");
        if (ignorePassengers && this.entity.bM() && location.getWorld() != this.getWorld()) {
            return false;
        }
        if (!dismount && this.entity.bL() && location.getWorld() != this.getWorld()) {
            return false;
        }
        location.checkFinite();
        EntityPlayer entity = this.getHandle();
        if (this.getHealth() == 0.0 || entity.dB()) {
            return false;
        }
        if (entity.b == null) {
            return false;
        }
        if (entity.bM() && !ignorePassengers) {
            return false;
        }
        Location from = this.getLocation();
        Location to = location;
        PlayerTeleportEvent event = new PlayerTeleportEvent((Player)this, from, to, cause);
        this.server.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (dismount) {
            entity.bz();
        }
        if (this.isSleeping()) {
            this.wakeup(false);
        }
        from = event.getFrom();
        to = event.getTo();
        WorldServer fromWorld = ((CraftWorld)from.getWorld()).getHandle();
        WorldServer toWorld = ((CraftWorld)to.getWorld()).getHandle();
        if (this.getHandle().bP != this.getHandle().bO && !allFlags.contains(TeleportFlag.EntityState.RETAIN_OPEN_INVENTORY)) {
            this.getHandle().closeContainer(InventoryCloseEvent.Reason.TELEPORT);
        }
        if (fromWorld == toWorld) {
            entity.b.internalTeleport(to.getX(), to.getY(), to.getZ(), to.getYaw(), to.getPitch(), relativeArguments);
        } else {
            this.server.getHandle().respawn(entity, toWorld, true, to, !toWorld.paperConfig().environment.disableTeleportationSuffocationCheck, null);
        }
        return true;
    }

    @Override
    public void setSneaking(boolean sneak) {
        this.getHandle().f(sneak);
    }

    @Override
    public boolean isSneaking() {
        return this.getHandle().bO();
    }

    public boolean isSprinting() {
        return this.getHandle().bU();
    }

    public void setSprinting(boolean sprinting) {
        this.getHandle().g(sprinting);
    }

    public void loadData() {
        this.server.getHandle().s.b(this.getHandle());
    }

    public void saveData() {
        this.server.getHandle().s.a(this.getHandle());
    }

    @Deprecated
    public void updateInventory() {
        this.getHandle().bP.b();
    }

    public void setSleepingIgnored(boolean isSleeping) {
        this.getHandle().fauxSleeping = isSleeping;
        ((CraftWorld)this.getWorld()).getHandle().e();
    }

    public boolean isSleepingIgnored() {
        return this.getHandle().fauxSleeping;
    }

    public Location getBedSpawnLocation() {
        Optional<Vec3D> spawnLoc;
        WorldServer world = this.getHandle().c.a(this.getHandle().P());
        BlockPosition bed = this.getHandle().N();
        if (world != null && bed != null && (spawnLoc = EntityHuman.a(world, bed, this.getHandle().O(), this.getHandle().Q(), true)).isPresent()) {
            Vec3D vec = spawnLoc.get();
            return CraftLocation.toBukkit(vec, (World)world.getWorld(), this.getHandle().O(), 0.0f);
        }
        return null;
    }

    public void setBedSpawnLocation(Location location) {
        this.setBedSpawnLocation(location, false);
    }

    public void setBedSpawnLocation(Location location, boolean override) {
        if (location == null) {
            this.getHandle().setRespawnPosition(null, null, 0.0f, override, false, PlayerSetSpawnEvent.Cause.PLUGIN);
        } else {
            this.getHandle().setRespawnPosition(((CraftWorld)location.getWorld()).getHandle().ab(), CraftLocation.toBlockPosition(location), location.getYaw(), override, false, PlayerSetSpawnEvent.Cause.PLUGIN);
        }
    }

    @Override
    public Location getBedLocation() {
        Preconditions.checkState((boolean)this.isSleeping(), (Object)"Not sleeping");
        BlockPosition bed = this.getHandle().N();
        return CraftLocation.toBukkit(bed, this.getWorld());
    }

    @Override
    public boolean hasDiscoveredRecipe(NamespacedKey recipe) {
        Preconditions.checkArgument((recipe != null ? 1 : 0) != 0, (Object)"recipe cannot be null");
        return this.getHandle().E().b(CraftNamespacedKey.toMinecraft(recipe));
    }

    @Override
    public Set<NamespacedKey> getDiscoveredRecipes() {
        ImmutableSet.Builder bukkitRecipeKeys = ImmutableSet.builder();
        this.getHandle().E().a.forEach(key -> bukkitRecipeKeys.add((Object)CraftNamespacedKey.fromMinecraft(key)));
        return bukkitRecipeKeys.build();
    }

    public void incrementStatistic(Statistic statistic) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic);
    }

    public void decrementStatistic(Statistic statistic) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic);
    }

    public int getStatistic(Statistic statistic) {
        return CraftStatistic.getStatistic(this.getHandle().D(), statistic);
    }

    public void incrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, amount);
    }

    public void decrementStatistic(Statistic statistic, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, amount);
    }

    public void setStatistic(Statistic statistic, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().D(), statistic, newValue);
    }

    public void incrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, material);
    }

    public void decrementStatistic(Statistic statistic, Material material) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, material);
    }

    public int getStatistic(Statistic statistic, Material material) {
        return CraftStatistic.getStatistic(this.getHandle().D(), statistic, material);
    }

    public void incrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, material, amount);
    }

    public void decrementStatistic(Statistic statistic, Material material, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, material, amount);
    }

    public void setStatistic(Statistic statistic, Material material, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().D(), statistic, material, newValue);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, entityType);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, entityType);
    }

    public int getStatistic(Statistic statistic, EntityType entityType) {
        return CraftStatistic.getStatistic(this.getHandle().D(), statistic, entityType);
    }

    public void incrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.incrementStatistic(this.getHandle().D(), statistic, entityType, amount);
    }

    public void decrementStatistic(Statistic statistic, EntityType entityType, int amount) {
        CraftStatistic.decrementStatistic(this.getHandle().D(), statistic, entityType, amount);
    }

    public void setStatistic(Statistic statistic, EntityType entityType, int newValue) {
        CraftStatistic.setStatistic(this.getHandle().D(), statistic, entityType, newValue);
    }

    public void setPlayerTime(long time, boolean relative) {
        this.getHandle().timeOffset = time;
        this.getHandle().relativeTime = relative;
    }

    public long getPlayerTimeOffset() {
        return this.getHandle().timeOffset;
    }

    public long getPlayerTime() {
        return this.getHandle().getPlayerTime();
    }

    public boolean isPlayerTimeRelative() {
        return this.getHandle().relativeTime;
    }

    public void resetPlayerTime() {
        this.setPlayerTime(0L, true);
    }

    public void setPlayerWeather(WeatherType type) {
        this.getHandle().setPlayerWeather(type, true);
    }

    public WeatherType getPlayerWeather() {
        return this.getHandle().getPlayerWeather();
    }

    public int getExpCooldown() {
        return this.getHandle().bU;
    }

    public void setExpCooldown(int ticks) {
        this.getHandle().bU = CraftEventFactory.callPlayerXpCooldownEvent(this.getHandle(), ticks, PlayerExpCooldownChangeEvent.ChangeReason.PLUGIN).getNewCooldown();
    }

    public void resetPlayerWeather() {
        this.getHandle().resetPlayerWeather();
    }

    public boolean isBanned() {
        return this.server.getBanList(BanList.Type.NAME).isBanned(this.getName());
    }

    public boolean isWhitelisted() {
        return this.server.getHandle().i().a(this.getProfile());
    }

    public void setWhitelisted(boolean value) {
        if (value) {
            this.server.getHandle().i().a(new WhiteListEntry(this.getProfile()));
        } else {
            this.server.getHandle().i().c(this.getProfile());
        }
    }

    @Override
    public void setGameMode(GameMode mode) {
        if (this.getHandle().b == null) {
            return;
        }
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null");
        }
        this.getHandle().setGameMode(EnumGamemode.a(mode.getValue()), PlayerGameModeChangeEvent.Cause.PLUGIN, null);
    }

    @Override
    public GameMode getGameMode() {
        return GameMode.getByValue((int)this.getHandle().d.b().a());
    }

    public GameMode getPreviousGameMode() {
        EnumGamemode previousGameMode = this.getHandle().d.c();
        return previousGameMode == null ? null : GameMode.getByValue((int)previousGameMode.a());
    }

    public int applyMending(int amount) {
        ItemStack itemstack;
        EntityPlayer handle = this.getHandle();
        Map.Entry<EnumItemSlot, ItemStack> stackEntry = EnchantmentManager.b(Enchantments.L, handle);
        ItemStack itemStack = itemstack = stackEntry != null ? stackEntry.getValue() : ItemStack.b;
        if (!itemstack.b() && itemstack.c().o()) {
            EntityExperienceOrb orb = EntityTypes.J.a(handle.H);
            orb.i = amount;
            orb.spawnReason = ExperienceOrb.SpawnReason.CUSTOM;
            orb.p(handle.dl(), handle.dn(), handle.dr());
            int i2 = Math.min(orb.d(amount), itemstack.j());
            PlayerItemMendEvent event = CraftEventFactory.callPlayerItemMendEvent(handle, orb, itemstack, stackEntry.getKey(), i2);
            i2 = event.getRepairAmount();
            orb.ai();
            if (!event.isCancelled()) {
                amount -= orb.c(i2);
                itemstack.b(itemstack.j() - i2);
            }
        }
        return amount;
    }

    public void giveExp(int exp, boolean applyMending) {
        if (applyMending) {
            exp = this.applyMending(exp);
        }
        this.getHandle().d(exp);
    }

    public void giveExpLevels(int levels) {
        this.getHandle().c(levels);
    }

    public float getExp() {
        return this.getHandle().ce;
    }

    public void setExp(float exp) {
        Preconditions.checkArgument(((double)exp >= 0.0 && (double)exp <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(exp));
        this.getHandle().ce = exp;
        this.getHandle().cx = -1;
    }

    public int getLevel() {
        return this.getHandle().cc;
    }

    public void setLevel(int level) {
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        this.getHandle().cc = level;
        this.getHandle().cx = -1;
    }

    public int getTotalExperience() {
        return this.getHandle().cd;
    }

    public void setTotalExperience(int exp) {
        Preconditions.checkArgument((exp >= 0 ? 1 : 0) != 0, (String)"Total experience points must not be negative (%s)", (int)exp);
        this.getHandle().cd = exp;
    }

    public void sendExperienceChange(float progress) {
        this.sendExperienceChange(progress, this.getLevel());
    }

    public void sendExperienceChange(float progress, int level) {
        Preconditions.checkArgument(((double)progress >= 0.0 && (double)progress <= 1.0 ? 1 : 0) != 0, (String)"Experience progress must be between 0.0 and 1.0 (%s)", (Object)Float.valueOf(progress));
        Preconditions.checkArgument((level >= 0 ? 1 : 0) != 0, (String)"Experience level must not be negative (%s)", (int)level);
        if (this.getHandle().b == null) {
            return;
        }
        PacketPlayOutExperience packet = new PacketPlayOutExperience(progress, this.getTotalExperience(), level);
        this.getHandle().b.a(packet);
    }

    @Nullable
    private static WeakReference<Plugin> getPluginWeakReference(@Nullable Plugin plugin) {
        return plugin == null ? null : pluginWeakReferences.computeIfAbsent(plugin, WeakReference::new);
    }

    @Deprecated
    public void hidePlayer(Player player) {
        this.hideEntity0(null, (Entity)player);
    }

    public void hidePlayer(Plugin plugin, Player player) {
        this.hideEntity(plugin, (Entity)player);
    }

    public void hideEntity(Plugin plugin, Entity entity) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        Validate.isTrue((boolean)plugin.isEnabled(), (String)"Plugin attempted to hide player while disabled");
        this.hideEntity0(plugin, entity);
    }

    private void hideEntity0(@Nullable Plugin plugin, Entity entity) {
        Validate.notNull((Object)entity, (String)"hidden entity cannot be null");
        if (this.getHandle().b == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldHide = entity.isVisibleByDefault() ? this.addInvertedVisibility(plugin, entity) : this.removeInvertedVisibility(plugin, entity);
        if (shouldHide) {
            this.untrackAndHideEntity(entity);
        }
    }

    private boolean addInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins != null) {
            invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
            return false;
        }
        invertedPlugins = new HashSet<WeakReference<Plugin>>();
        invertedPlugins.add(CraftPlayer.getPluginWeakReference(plugin));
        this.invertedVisibilityEntities.put(entity.getUniqueId(), invertedPlugins);
        return true;
    }

    private void untrackAndHideEntity(Entity entity) {
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        this.unregisterEntity(other);
        this.server.getPluginManager().callEvent((Event)new PlayerHideEntityEvent((Player)this, entity));
    }

    private void unregisterEntity(net.minecraft.world.entity.Entity other) {
        PlayerChunkMap tracker = ((WorldServer)this.getHandle().H).k().a;
        PlayerChunkMap.EntityTracker entry = (PlayerChunkMap.EntityTracker)tracker.L.get(other.af());
        if (entry != null) {
            entry.a(this.getHandle());
        }
        if (other instanceof EntityPlayer) {
            EntityPlayer otherPlayer = (EntityPlayer)other;
            if (otherPlayer.sentListPacket) {
                this.getHandle().b.a(new ClientboundPlayerInfoRemovePacket(List.of(otherPlayer.cs())));
            }
        }
    }

    void resetAndHideEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.untrackAndHideEntity(entity);
        }
    }

    @Deprecated
    public void showPlayer(Player player) {
        this.showEntity0(null, (Entity)player);
    }

    public void showPlayer(Plugin plugin, Player player) {
        this.showEntity(plugin, (Entity)player);
    }

    public void showEntity(Plugin plugin, Entity entity) {
        Validate.notNull((Object)plugin, (String)"Plugin cannot be null");
        this.showEntity0(plugin, entity);
    }

    private void showEntity0(@Nullable Plugin plugin, Entity entity) {
        Validate.notNull((Object)entity, (String)"shown entity cannot be null");
        if (this.getHandle().b == null) {
            return;
        }
        if (this.equals(entity)) {
            return;
        }
        boolean shouldShow = entity.isVisibleByDefault() ? this.removeInvertedVisibility(plugin, entity) : this.addInvertedVisibility(plugin, entity);
        if (shouldShow) {
            this.trackAndShowEntity(entity);
        }
    }

    private boolean removeInvertedVisibility(@Nullable Plugin plugin, Entity entity) {
        Set<WeakReference<Plugin>> invertedPlugins = this.invertedVisibilityEntities.get(entity.getUniqueId());
        if (invertedPlugins == null) {
            return false;
        }
        invertedPlugins.remove(CraftPlayer.getPluginWeakReference(plugin));
        if (!invertedPlugins.isEmpty()) {
            return false;
        }
        this.invertedVisibilityEntities.remove(entity.getUniqueId());
        return true;
    }

    private void trackAndShowEntity(Entity entity) {
        PlayerChunkMap.EntityTracker entry;
        PlayerChunkMap tracker = ((WorldServer)this.getHandle().H).k().a;
        net.minecraft.world.entity.Entity other = ((CraftEntity)entity).getHandle();
        if (other instanceof EntityPlayer) {
            EntityPlayer otherPlayer = (EntityPlayer)other;
            this.getHandle().b.a(ClientboundPlayerInfoUpdatePacket.a(List.of(otherPlayer)));
        }
        if ((entry = (PlayerChunkMap.EntityTracker)tracker.L.get(other.af())) != null && !entry.f.contains(this.getHandle().b)) {
            entry.b(this.getHandle());
        }
        this.server.getPluginManager().callEvent((Event)new PlayerShowEntityEvent((Player)this, entity));
    }

    public void setPlayerProfile(PlayerProfile profile) {
        CraftPlayer bukkitPlayer;
        EntityPlayer self = this.getHandle();
        GameProfile gameProfile = CraftPlayerProfile.asAuthlibCopy(profile);
        if (!self.sentListPacket) {
            ((EntityHuman)self).co = gameProfile;
            return;
        }
        List<EntityPlayer> players = this.server.getServer().bi().k;
        for (EntityPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee(this)) continue;
            bukkitPlayer.unregisterEntity(self);
        }
        ((EntityHuman)self).co = gameProfile;
        for (EntityPlayer player : players) {
            bukkitPlayer = player.getBukkitEntity();
            if (!bukkitPlayer.canSee(this)) continue;
            bukkitPlayer.trackAndShowEntity(self.getBukkitEntity());
        }
        this.refreshPlayer();
    }

    void resetAndShowEntity(Entity entity) {
        if (this.equals(entity)) {
            return;
        }
        if (this.invertedVisibilityEntities.remove(entity.getUniqueId()) == null) {
            this.trackAndShowEntity(entity);
        }
    }

    public PlayerProfile getPlayerProfile() {
        return new CraftPlayerProfile(this).clone();
    }

    private void refreshPlayer() {
        EntityPlayer handle = this.getHandle();
        Location loc = this.getLocation();
        PlayerConnection connection = handle.b;
        WorldServer worldserver = handle.x();
        connection.a(new PacketPlayOutRespawn(worldserver.Z(), worldserver.ab(), BiomeManager.a(worldserver.A()), handle.d.b(), handle.d.c(), worldserver.ae(), worldserver.z(), 3, this.getHandle().gi()));
        handle.w();
        connection.internalTeleport(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), Collections.emptySet());
        MinecraftServer.getServer().ac().e(handle);
        connection.a(new PacketPlayOutExperience(handle.ce, handle.cd, handle.cc));
        for (MobEffect mobEffect : handle.el()) {
            connection.a(new PacketPlayOutEntityEffect(handle.af(), mobEffect));
        }
        if (this.isOp()) {
            this.setOp(false);
            this.setOp(true);
        }
    }

    public void onEntityRemove(net.minecraft.world.entity.Entity entity) {
        this.invertedVisibilityEntities.remove(entity.cs());
    }

    public boolean canSee(Player player) {
        return this.canSee((Entity)player);
    }

    public boolean canSee(Entity entity) {
        return this.equals(entity) || entity.isVisibleByDefault() ^ this.invertedVisibilityEntities.containsKey(entity.getUniqueId());
    }

    public boolean canSee(UUID uuid) {
        Player entity = this.getServer().getPlayer(uuid);
        if (entity == null) {
            entity = this.getServer().getEntity(uuid);
        }
        return entity != null ? this.canSee((Entity)entity) : false;
    }

    public Map<String, Object> serialize() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("name", this.getName());
        return result;
    }

    public Player getPlayer() {
        return this;
    }

    @Override
    public EntityPlayer getHandle() {
        return (EntityPlayer)this.entity;
    }

    public void setHandle(EntityPlayer entity) {
        super.setHandle(entity);
    }

    @Override
    public String toString() {
        return "CraftPlayer{name=" + this.getName() + "}";
    }

    @Override
    public int hashCode() {
        if (this.hash == 0 || this.hash == 485) {
            this.hash = 485 + (this.getUniqueId() != null ? this.getUniqueId().hashCode() : 0);
        }
        return this.hash;
    }

    public long getFirstPlayed() {
        return this.firstPlayed;
    }

    public long getLastPlayed() {
        return this.lastPlayed;
    }

    public boolean hasPlayedBefore() {
        return this.hasPlayedBefore;
    }

    public void setFirstPlayed(long firstPlayed) {
        this.firstPlayed = firstPlayed;
    }

    public long getLastLogin() {
        return this.getHandle().loginTime;
    }

    public long getLastSeen() {
        return this.isOnline() ? System.currentTimeMillis() : this.lastSaveTime;
    }

    public void readExtraData(NBTTagCompound nbttagcompound) {
        this.hasPlayedBefore = true;
        if (nbttagcompound.e("bukkit")) {
            NBTTagCompound data = nbttagcompound.p("bukkit");
            if (data.e("firstPlayed")) {
                this.firstPlayed = data.i("firstPlayed");
                this.lastPlayed = data.i("lastPlayed");
            }
            if (data.e("newExp")) {
                EntityPlayer handle = this.getHandle();
                handle.newExp = data.h("newExp");
                handle.newTotalExp = data.h("newTotalExp");
                handle.newLevel = data.h("newLevel");
                handle.expToDrop = data.h("expToDrop");
                handle.keepLevel = data.q("keepLevel");
            }
        }
    }

    public void setExtraData(NBTTagCompound nbttagcompound) {
        this.lastSaveTime = System.currentTimeMillis();
        if (!nbttagcompound.e("bukkit")) {
            nbttagcompound.a("bukkit", new NBTTagCompound());
        }
        NBTTagCompound data = nbttagcompound.p("bukkit");
        EntityPlayer handle = this.getHandle();
        data.a("newExp", handle.newExp);
        data.a("newTotalExp", handle.newTotalExp);
        data.a("newLevel", handle.newLevel);
        data.a("expToDrop", handle.expToDrop);
        data.a("keepLevel", handle.keepLevel);
        data.a("firstPlayed", this.getFirstPlayed());
        data.a("lastPlayed", System.currentTimeMillis());
        data.a("lastKnownName", handle.cu());
        if (!nbttagcompound.e("Paper")) {
            nbttagcompound.a("Paper", new NBTTagCompound());
        }
        NBTTagCompound paper = nbttagcompound.p("Paper");
        paper.a("LastLogin", handle.loginTime);
        paper.a("LastSeen", System.currentTimeMillis());
    }

    public boolean beginConversation(Conversation conversation) {
        return this.conversationTracker.beginConversation(conversation);
    }

    public void abandonConversation(Conversation conversation) {
        this.conversationTracker.abandonConversation(conversation, new ConversationAbandonedEvent(conversation, (ConversationCanceller)new ManuallyAbandonedConversationCanceller()));
    }

    public void abandonConversation(Conversation conversation, ConversationAbandonedEvent details) {
        this.conversationTracker.abandonConversation(conversation, details);
    }

    public void acceptConversationInput(String input) {
        this.conversationTracker.acceptConversationInput(input);
    }

    public boolean isConversing() {
        return this.conversationTracker.isConversing();
    }

    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage((Messenger)this.server.getMessenger(), (Plugin)source, (String)channel, (byte[])message);
        if (this.getHandle().b == null) {
            return;
        }
        if (this.channels.contains(channel)) {
            channel = StandardMessenger.validateAndCorrectChannel((String)channel);
            PacketPlayOutCustomPayload packet = new PacketPlayOutCustomPayload(new MinecraftKey(channel), new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])message)));
            this.getHandle().b.a(packet);
        }
    }

    public void setTexturePack(String url) {
        this.setResourcePack(url);
    }

    public void setResourcePack(String url) {
        this.setResourcePack(url, (byte[])null);
    }

    public void setResourcePack(String url, byte[] hash) {
        this.setResourcePack(url, hash, false);
    }

    public void setResourcePack(String url, byte[] hash, String prompt) {
        this.setResourcePack(url, hash, prompt, false);
    }

    public void setResourcePack(String url, byte[] hash, boolean force) {
        this.setResourcePack(url, hash, (String)null, force);
    }

    public void setResourcePack(String url, byte[] hash, String prompt, boolean force) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        if (hash != null) {
            Validate.isTrue((hash.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hash.length));
            this.getHandle().a(url, BaseEncoding.base16().lowerCase().encode(hash), force, CraftChatMessage.fromStringOrNull(prompt, true));
        } else {
            this.getHandle().a(url, "", force, CraftChatMessage.fromStringOrNull(prompt, true));
        }
    }

    public void setResourcePack(String url, byte[] hashBytes, Component prompt, boolean force) {
        String hash;
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        if (hashBytes != null) {
            Validate.isTrue((hashBytes.length == 20 ? 1 : 0) != 0, (String)("Resource pack hash should be 20 bytes long but was " + hashBytes.length));
            hash = BaseEncoding.base16().lowerCase().encode(hashBytes);
        } else {
            hash = "";
        }
        this.getHandle().a(url, hash, force, PaperAdventure.asVanilla(prompt));
    }

    public void addChannel(String channel) {
        Preconditions.checkState((DISABLE_CHANNEL_LIMIT || this.channels.size() < 128 ? 1 : 0) != 0, (String)"Cannot register channel '%s'. Too many channels registered!", (Object)channel);
        channel = StandardMessenger.validateAndCorrectChannel((String)channel);
        if (this.channels.add(channel)) {
            this.server.getPluginManager().callEvent((Event)new PlayerRegisterChannelEvent((Player)this, channel));
        }
    }

    public void removeChannel(String channel) {
        if (this.channels.remove(channel = StandardMessenger.validateAndCorrectChannel((String)channel))) {
            this.server.getPluginManager().callEvent((Event)new PlayerUnregisterChannelEvent((Player)this, channel));
        }
    }

    public Set<String> getListeningPluginChannels() {
        return ImmutableSet.copyOf(this.channels);
    }

    public void sendSupportedChannels() {
        if (this.getHandle().b == null) {
            return;
        }
        Set listening = this.server.getMessenger().getIncomingChannels();
        if (!listening.isEmpty()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            for (String channel : listening) {
                try {
                    stream.write(channel.getBytes("UTF8"));
                    stream.write(0);
                }
                catch (IOException ex) {
                    Logger.getLogger(CraftPlayer.class.getName()).log(Level.SEVERE, "Could not send Plugin Channel REGISTER to " + this.getName(), ex);
                }
            }
            this.getHandle().b.a(new PacketPlayOutCustomPayload(new MinecraftKey("register"), new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])stream.toByteArray()))));
        }
    }

    @Override
    public EntityType getType() {
        return EntityType.PLAYER;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getPlayerMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getPlayerMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getPlayerMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public boolean setWindowProperty(InventoryView.Property prop, int value) {
        Container container = this.getHandle().bP;
        if (container.getBukkitView().getType() != prop.getType()) {
            return false;
        }
        container.a(prop.getId(), value);
        return true;
    }

    public void disconnect(String reason) {
        this.conversationTracker.abandonAllConversations();
        this.perm.clearPermissions();
    }

    public boolean isFlying() {
        return this.getHandle().fK().b;
    }

    public void setFlying(boolean value) {
        boolean needsUpdate;
        boolean bl = needsUpdate = this.getHandle().fK().b != value;
        if (!this.getAllowFlight() && value) {
            throw new IllegalArgumentException("Cannot make player fly if getAllowFlight() is false");
        }
        this.getHandle().fK().b = value;
        if (needsUpdate) {
            this.getHandle().w();
        }
    }

    public boolean getAllowFlight() {
        return this.getHandle().fK().c;
    }

    public void setAllowFlight(boolean value) {
        if (this.isFlying() && !value) {
            this.getHandle().fK().b = false;
        }
        this.getHandle().fK().c = value;
        this.getHandle().w();
    }

    public void setFlyingFallDamage(@NotNull TriState flyingFallDamage) {
        this.getHandle().flyingFallDamage = flyingFallDamage;
    }

    @NotNull
    public TriState hasFlyingFallDamage() {
        return this.getHandle().flyingFallDamage;
    }

    @Override
    public int getNoDamageTicks() {
        if (this.getHandle().cy > 0) {
            return Math.max(this.getHandle().cy, this.getHandle().ak);
        }
        return this.getHandle().ak;
    }

    @Override
    public void setNoDamageTicks(int ticks) {
        super.setNoDamageTicks(ticks);
        this.getHandle().cy = ticks;
    }

    public void setFlySpeed(float value) {
        this.validateSpeed(value);
        EntityPlayer player = this.getHandle();
        player.fK().f = value / 2.0f;
        player.w();
    }

    public void setWalkSpeed(float value) {
        this.validateSpeed(value);
        EntityPlayer player = this.getHandle();
        player.fK().g = value / 2.0f;
        player.w();
        this.getHandle().a(GenericAttributes.d).a(player.fK().g);
    }

    public float getFlySpeed() {
        return this.getHandle().fK().f * 2.0f;
    }

    public float getWalkSpeed() {
        return this.getHandle().fK().g * 2.0f;
    }

    private void validateSpeed(float value) {
        if (value < 0.0f) {
            if (value < -1.0f) {
                throw new IllegalArgumentException(value + " is too low");
            }
        } else if (value > 1.0f) {
            throw new IllegalArgumentException(value + " is too high");
        }
    }

    @Override
    public void setMaxHealth(double amount) {
        super.setMaxHealth(amount);
        this.health = Math.min(this.health, this.health);
        this.getHandle().u();
    }

    @Override
    public void resetMaxHealth() {
        super.resetMaxHealth();
        this.getHandle().u();
    }

    public CraftScoreboard getScoreboard() {
        return this.server.getScoreboardManager().getPlayerBoard(this);
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Validate.notNull((Object)scoreboard, (String)"Scoreboard cannot be null");
        PlayerConnection playerConnection = this.getHandle().b;
        if (playerConnection == null) {
            throw new IllegalStateException("Cannot set scoreboard yet");
        }
        if (playerConnection.isDisconnected()) {
            // empty if block
        }
        this.server.getScoreboardManager().setPlayerBoard(this, scoreboard);
    }

    public void setHealthScale(double value) {
        Validate.isTrue(((float)value > 0.0f ? 1 : 0) != 0, (String)"Must be greater than 0");
        this.healthScale = value;
        this.scaledHealth = true;
        this.updateScaledHealth();
    }

    public double getHealthScale() {
        return this.healthScale;
    }

    public void setHealthScaled(boolean scale) {
        this.scaledHealth = scale;
        if (this.scaledHealth != this.scaledHealth) {
            this.updateScaledHealth();
        }
    }

    public boolean isHealthScaled() {
        return this.scaledHealth;
    }

    public float getScaledHealth() {
        return (float)(this.isHealthScaled() ? this.getHealth() * this.getHealthScale() / this.getMaxHealth() : this.getHealth());
    }

    @Override
    public double getHealth() {
        return this.health;
    }

    public void setRealHealth(double health) {
        if (Double.isNaN(health)) {
            return;
        }
        this.health = health;
    }

    public void updateScaledHealth() {
        this.updateScaledHealth(true);
    }

    public void updateScaledHealth(boolean sendHealth) {
        AttributeMapBase attributemapserver = this.getHandle().eI();
        Collection<AttributeModifiable> set = attributemapserver.b();
        this.injectScaledMaxHealth(set, true);
        if (this.getHandle().b != null) {
            this.getHandle().b.a(new PacketPlayOutUpdateAttributes(this.getHandle().af(), set));
            if (sendHealth) {
                this.sendHealthUpdate();
            }
        }
        this.getHandle().aj().b(EntityLiving.bF, Float.valueOf(this.getScaledHealth()));
        this.getHandle().maxHealthCache = this.getMaxHealth();
    }

    public void sendHealthUpdate(double health, int foodLevel, float saturationLevel) {
        PacketPlayOutUpdateHealth packet = new PacketPlayOutUpdateHealth((float)health, foodLevel, saturationLevel);
        if (this.getHandle().queueHealthUpdatePacket) {
            this.getHandle().queuedHealthUpdatePacket = packet;
        } else {
            this.getHandle().b.a(packet);
        }
    }

    public void sendHealthUpdate() {
        this.sendHealthUpdate(this.getScaledHealth(), this.getHandle().fT().a(), this.getHandle().fT().e());
    }

    public void injectScaledMaxHealth(Collection<AttributeModifiable> collection, boolean force) {
        double healthMod;
        if (!this.scaledHealth && !force) {
            return;
        }
        for (AttributeModifiable genericInstance : collection) {
            if (genericInstance.a() != GenericAttributes.a) continue;
            collection.remove(genericInstance);
            break;
        }
        AttributeModifiable dummy = new AttributeModifiable(GenericAttributes.a, attribute -> {});
        double d2 = healthMod = this.scaledHealth ? this.healthScale : this.getMaxHealth();
        if (healthMod >= 3.4028234663852886E38 || healthMod <= 0.0) {
            healthMod = 20.0;
            this.getServer().getLogger().warning(this.getName() + " tried to crash the server with a large health attribute");
        }
        dummy.a(healthMod);
        collection.add(dummy);
    }

    public Entity getSpectatorTarget() {
        net.minecraft.world.entity.Entity followed = this.getHandle().G();
        return followed == this.getHandle() ? null : followed.getBukkitEntity();
    }

    public void setSpectatorTarget(Entity entity) {
        Preconditions.checkArgument((this.getGameMode() == GameMode.SPECTATOR ? 1 : 0) != 0, (Object)"Player must be in spectator mode");
        this.getHandle().c(entity == null ? null : ((CraftEntity)entity).getHandle());
    }

    public void sendTitle(String title, String subtitle) {
        this.sendTitle(title, subtitle, 10, 70, 20);
    }

    public void sendTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        ClientboundSetTitlesAnimationPacket times = new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut);
        this.getHandle().b.a(times);
        if (title != null) {
            ClientboundSetTitleTextPacket packetTitle = new ClientboundSetTitleTextPacket(CraftChatMessage.fromString(title)[0]);
            this.getHandle().b.a(packetTitle);
        }
        if (subtitle != null) {
            ClientboundSetSubtitleTextPacket packetSubtitle = new ClientboundSetSubtitleTextPacket(CraftChatMessage.fromString(subtitle)[0]);
            this.getHandle().b.a(packetSubtitle);
        }
    }

    public void resetTitle() {
        ClientboundClearTitlesPacket packetReset = new ClientboundClearTitlesPacket(true);
        this.getHandle().b.a(packetReset);
    }

    public void spawnParticle(Particle particle, Location location, int count) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count) {
        this.spawnParticle(particle, x2, y2, z2, count, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, 0.0, 0.0, 0.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, T data) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, 1.0, data);
    }

    public void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra);
    }

    public void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra) {
        this.spawnParticle(particle, x2, y2, z2, count, offsetX, offsetY, offsetZ, extra, null);
    }

    public <T> void spawnParticle(Particle particle, Location location, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        this.spawnParticle(particle, location.getX(), location.getY(), location.getZ(), count, offsetX, offsetY, offsetZ, extra, data);
    }

    public <T> void spawnParticle(Particle particle, double x2, double y2, double z2, int count, double offsetX, double offsetY, double offsetZ, double extra, T data) {
        if (data != null && !particle.getDataType().isInstance(data)) {
            throw new IllegalArgumentException("data should be " + particle.getDataType() + " got " + data.getClass());
        }
        PacketPlayOutWorldParticles packetplayoutworldparticles = new PacketPlayOutWorldParticles(CraftParticle.toNMS(particle, data), true, x2, y2, z2, (float)offsetX, (float)offsetY, (float)offsetZ, (float)extra, count);
        this.getHandle().b.a(packetplayoutworldparticles);
    }

    public org.bukkit.advancement.AdvancementProgress getAdvancementProgress(Advancement advancement) {
        Preconditions.checkArgument((advancement != null ? 1 : 0) != 0, (Object)"advancement");
        CraftAdvancement craft = (CraftAdvancement)advancement;
        AdvancementDataPlayer data = this.getHandle().M();
        AdvancementProgress progress = data.b(craft.getHandle());
        return new CraftAdvancementProgress(craft, data, progress);
    }

    public int getClientViewDistance() {
        return this.getHandle().clientViewDistance == null ? Bukkit.getViewDistance() : this.getHandle().clientViewDistance;
    }

    public Locale locale() {
        return this.getHandle().adventure$locale;
    }

    public int getPing() {
        return this.getHandle().e;
    }

    public String getLocale() {
        String locale = this.getHandle().locale;
        return locale != null ? locale : "en_us";
    }

    public void setAffectsSpawning(boolean affects) {
        this.getHandle().affectsSpawning = affects;
    }

    public boolean getAffectsSpawning() {
        return this.getHandle().affectsSpawning;
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash) {
        this.setResourcePack(url, hash, false, null);
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required) {
        this.setResourcePack(url, hash, required, null);
    }

    public void setResourcePack(@NotNull String url, @NotNull String hash, boolean required, Component resourcePackPrompt) {
        Validate.notNull((Object)url, (String)"Resource pack URL cannot be null");
        Validate.notNull((Object)hash, (String)"Hash cannot be null");
        IChatBaseComponent promptComponent = resourcePackPrompt != null ? PaperAdventure.asVanilla(resourcePackPrompt) : null;
        this.getHandle().a(url, hash, required, promptComponent);
    }

    public PlayerResourcePackStatusEvent.Status getResourcePackStatus() {
        return this.resourcePackStatus;
    }

    public String getResourcePackHash() {
        return this.resourcePackHash;
    }

    public boolean hasResourcePack() {
        return this.resourcePackStatus == PlayerResourcePackStatusEvent.Status.SUCCESSFULLY_LOADED;
    }

    public void setResourcePackStatus(PlayerResourcePackStatusEvent.Status status) {
        this.resourcePackStatus = status;
    }

    public void updateCommands() {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().c.aC().a(this.getHandle());
    }

    public void openBook(org.bukkit.inventory.ItemStack book) {
        Validate.isTrue((book != null ? 1 : 0) != 0, (String)"book == null");
        Validate.isTrue((book.getType() == Material.WRITTEN_BOOK ? 1 : 0) != 0, (String)"Book must be Material.WRITTEN_BOOK");
        org.bukkit.inventory.ItemStack hand = this.getInventory().getItemInMainHand();
        this.getInventory().setItemInMainHand(book);
        this.getHandle().a(CraftItemStack.asNMSCopy(book), EnumHand.a);
        this.getInventory().setItemInMainHand(hand);
    }

    @Override
    public void openSign(Sign sign) {
        CraftSign.openSign(sign, this);
    }

    public void showDemoScreen() {
        if (this.getHandle().b == null) {
            return;
        }
        this.getHandle().b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.f, 0.0f));
    }

    public boolean isAllowingServerListings() {
        return this.getHandle().V();
    }

    public Component displayName() {
        return this.getHandle().adventure$displayName;
    }

    public void displayName(Component displayName) {
        this.getHandle().adventure$displayName = displayName != null ? displayName : Component.text((String)this.getName());
        this.getHandle().displayName = null;
    }

    public void deleteMessage(SignedMessage.Signature signature) {
        if (this.getHandle().b == null) {
            return;
        }
        MessageSignature sig = new MessageSignature(signature.bytes());
        this.getHandle().b.a(new ClientboundDeleteChatPacket(new MessageSignature.a(sig)));
    }

    private ChatMessageType.a toHandle(ChatType.Bound boundChatType) {
        IRegistry<net.minecraft.network.chat.ChatMessageType> chatTypeRegistry = this.getHandle().H.u_().d(Registries.ao);
        return new ChatMessageType.a(chatTypeRegistry.a(PaperAdventure.asVanilla(boundChatType.type().key())), PaperAdventure.asVanilla(boundChatType.name()), PaperAdventure.asVanilla(boundChatType.target()));
    }

    public void sendMessage(Component message, ChatType.Bound boundChatType) {
        if (this.getHandle().b == null) {
            return;
        }
        IChatBaseComponent component = PaperAdventure.asVanilla(message);
        this.getHandle().a(new OutgoingChatMessage.a(component), this.getHandle().U(), this.toHandle(boundChatType));
    }

    public void sendMessage(SignedMessage signedMessage, ChatType.Bound boundChatType) {
        Component message;
        if (this.getHandle().b == null) {
            return;
        }
        if (signedMessage instanceof PlayerChatMessage.AdventureView) {
            PlayerChatMessage.AdventureView view = (PlayerChatMessage.AdventureView)signedMessage;
            this.getHandle().a(OutgoingChatMessage.a(view.playerChatMessage()), this.getHandle().U(), this.toHandle(boundChatType));
            return;
        }
        Object object = message = signedMessage.unsignedContent() == null ? Component.text((String)signedMessage.message()) : signedMessage.unsignedContent();
        if (signedMessage.isSystem()) {
            this.sendMessage(message, boundChatType);
        } else {
            super.sendMessage(signedMessage, boundChatType);
        }
    }

    @Deprecated(forRemoval=true)
    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.getHandle().b == null) {
            return;
        }
        IRegistry<net.minecraft.network.chat.ChatMessageType> chatTypeRegistry = this.getHandle().H.u_().d(Registries.ao);
        this.getHandle().b.a(new ClientboundSystemChatPacket(message, false));
    }

    public void sendActionBar(Component message) {
        ClientboundSetActionBarTextPacket packet = new ClientboundSetActionBarTextPacket((IChatBaseComponent)null);
        packet.adventure$text = message;
        this.getHandle().b.a(packet);
    }

    public void sendPlayerListHeader(Component header) {
        this.playerListHeader = header;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListFooter(Component footer) {
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.playerListHeader = header;
        this.playerListFooter = footer;
        this.adventure$sendPlayerListHeaderAndFooter();
    }

    private void adventure$sendPlayerListHeaderAndFooter() {
        PlayerConnection connection = this.getHandle().b;
        if (connection == null) {
            return;
        }
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter(null, null);
        packet.adventure$header = this.playerListHeader == null ? Component.empty() : this.playerListHeader;
        packet.adventure$footer = this.playerListFooter == null ? Component.empty() : this.playerListFooter;
        connection.a(packet);
    }

    public void showTitle(net.kyori.adventure.title.Title title) {
        PlayerConnection connection = this.getHandle().b;
        Title.Times times = title.times();
        if (times != null) {
            connection.a(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        }
        ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket((IChatBaseComponent)null);
        sp.adventure$text = title.subtitle();
        connection.a(sp);
        ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket((IChatBaseComponent)null);
        tp.adventure$text = title.title();
        connection.a(tp);
    }

    public <T> void sendTitlePart(TitlePart<T> part, T value) {
        Objects.requireNonNull(part, "part");
        Objects.requireNonNull(value, "value");
        if (part == TitlePart.TITLE) {
            ClientboundSetTitleTextPacket tp = new ClientboundSetTitleTextPacket((IChatBaseComponent)null);
            tp.adventure$text = (Component)value;
            this.getHandle().b.a(tp);
        } else if (part == TitlePart.SUBTITLE) {
            ClientboundSetSubtitleTextPacket sp = new ClientboundSetSubtitleTextPacket((IChatBaseComponent)null);
            sp.adventure$text = (Component)value;
            this.getHandle().b.a(sp);
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            this.getHandle().b.a(new ClientboundSetTitlesAnimationPacket(CraftPlayer.ticks(times.fadeIn()), CraftPlayer.ticks(times.stay()), CraftPlayer.ticks(times.fadeOut())));
        } else {
            throw new IllegalArgumentException("Unknown TitlePart");
        }
    }

    private static int ticks(Duration duration) {
        if (duration == null) {
            return -1;
        }
        return (int)(duration.toMillis() / 50L);
    }

    public void clearTitle() {
        this.getHandle().b.a(new ClientboundClearTitlesPacket(false));
    }

    public void showBossBar(BossBar bar) {
        ((HackyBossBarPlatformBridge)bar).paper$playerShow(this);
    }

    public void hideBossBar(BossBar bar) {
        ((HackyBossBarPlatformBridge)bar).paper$playerHide(this);
    }

    public void playSound(net.kyori.adventure.sound.Sound sound) {
        Vec3D pos = this.getHandle().de();
        this.playSound(sound, pos.c, pos.d, pos.e);
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, double x2, double y2, double z2) {
        long seed = sound.seed().orElseGet(this.getHandle().dZ()::g);
        MinecraftKey name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEffect> event = BuiltInRegistries.c.b(name);
        Holder<SoundEffect> soundHolder = event.isPresent() ? BuiltInRegistries.c.d(event.get()) : Holder.a(SoundEffect.a(name));
        this.getHandle().b.a(new PacketPlayOutNamedSoundEffect(soundHolder, PaperAdventure.asVanilla(sound.source()), x2, y2, z2, sound.volume(), sound.pitch(), seed));
    }

    public void playSound(net.kyori.adventure.sound.Sound sound, Sound.Emitter emitter) {
        net.minecraft.world.entity.Entity entity;
        if (emitter == Sound.Emitter.self()) {
            entity = this.getHandle();
        } else if (emitter instanceof Entity) {
            entity = ((CraftEntity)emitter).getHandle();
        } else {
            throw new IllegalArgumentException("Sound emitter must be an Entity or self(), but was: " + emitter);
        }
        long seed = sound.seed().orElseGet(this.getHandle().dZ()::g);
        MinecraftKey name = PaperAdventure.asVanilla(sound.name());
        Optional<SoundEffect> event = BuiltInRegistries.c.b(name);
        Holder<SoundEffect> soundHolder = event.isPresent() ? BuiltInRegistries.c.d(event.get()) : Holder.a(SoundEffect.a(name));
        this.getHandle().b.a(new PacketPlayOutEntitySound(soundHolder, PaperAdventure.asVanilla(sound.source()), entity, sound.volume(), sound.pitch(), seed));
    }

    public void stopSound(SoundStop stop) {
        this.getHandle().b.a(new PacketPlayOutStopSound(PaperAdventure.asVanillaNullable(stop.sound()), PaperAdventure.asVanillaNullable(stop.source())));
    }

    public void openBook(Book book) {
        Locale locale = this.getHandle().adventure$locale;
        ItemStack item = PaperAdventure.asItemStack(book, locale);
        EntityPlayer player = this.getHandle();
        PlayerConnection connection = player.b;
        PlayerInventory inventory = player.fJ();
        int slot = inventory.i.size() + inventory.l;
        int stateId = this.getHandle().bP.j();
        connection.a(new PacketPlayOutSetSlot(0, stateId, slot, item));
        connection.a(new PacketPlayOutOpenBook(EnumHand.a));
        connection.a(new PacketPlayOutSetSlot(0, stateId, slot, inventory.f()));
    }

    @Override
    public Pointers pointers() {
        if (this.adventure$pointers == null) {
            this.adventure$pointers = (Pointers)Pointers.builder().withDynamic(Identity.DISPLAY_NAME, this::displayName).withDynamic(Identity.NAME, this::getName).withDynamic(Identity.UUID, this::getUniqueId).withStatic(PermissionChecker.POINTER, arg_0 -> ((CraftPlayer)this).permissionValue(arg_0)).withDynamic(Identity.LOCALE, this::locale).build();
        }
        return this.adventure$pointers;
    }

    public float getCooldownPeriod() {
        return this.getHandle().gc();
    }

    public float getCooledAttackStrength(float adjustTicks) {
        return this.getHandle().z(adjustTicks);
    }

    public void resetCooldown() {
        this.getHandle().gd();
    }

    @Override
    public void remove() {
        if (this.getHandle().getClass().equals(EntityPlayer.class)) {
            throw new UnsupportedOperationException("Calling Entity#remove on players produces undefined (bad) behavior");
        }
        super.remove();
    }

    public String getClientBrandName() {
        return this.getHandle().b != null ? this.getHandle().b.getClientBrandName() : null;
    }

    public void showElderGuardian(boolean silent) {
        if (this.getHandle().b != null) {
            this.getHandle().b.a(new PacketPlayOutGameStateChange(PacketPlayOutGameStateChange.k, silent ? 0.0f : 1.0f));
        }
    }

    public int getWardenWarningCooldown() {
        return this.getHandle().cU.i;
    }

    public void setWardenWarningCooldown(int cooldown) {
        this.getHandle().cU.i = Math.max(cooldown, 0);
    }

    public int getWardenTimeSinceLastWarning() {
        return this.getHandle().cU.g;
    }

    public void setWardenTimeSinceLastWarning(int time) {
        this.getHandle().cU.g = time;
    }

    public int getWardenWarningLevel() {
        return this.getHandle().cU.c();
    }

    public void setWardenWarningLevel(int warningLevel) {
        this.getHandle().cU.a(warningLevel);
    }

    public void increaseWardenWarningLevel() {
        this.getHandle().cU.e();
    }

    public Player.Spigot spigot() {
        return this.spigot;
    }

    private record ChunkSectionChanges(ShortSet positions, List<IBlockData> blockData) {
        public ChunkSectionChanges() {
            this((ShortSet)new ShortArraySet(), new ArrayList<IBlockData>());
        }
    }
}

