/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.base.Preconditions;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.block.CraftBlock;
import org.bukkit.craftbukkit.v1_19_R3.entity.AbstractProjectile;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ShulkerBullet;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class CraftShulkerBullet
extends AbstractProjectile
implements ShulkerBullet {
    public CraftShulkerBullet(CraftServer server, EntityShulkerBullet entity) {
        super(server, entity);
    }

    public ProjectileSource getShooter() {
        return this.getHandle().projectileSource;
    }

    public void setShooter(ProjectileSource shooter) {
        if (shooter instanceof Entity) {
            this.getHandle().b(((CraftEntity)shooter).getHandle());
        } else {
            this.getHandle().b((net.minecraft.world.entity.Entity)null);
        }
        this.getHandle().projectileSource = shooter;
    }

    public Entity getTarget() {
        return this.getHandle().getTarget() != null ? this.getHandle().getTarget().getBukkitEntity() : null;
    }

    public void setTarget(Entity target) {
        Preconditions.checkState((!this.getHandle().generation ? 1 : 0) != 0, (Object)"Cannot set target during world generation");
        this.getHandle().setTarget(target == null ? null : ((CraftEntity)target).getHandle());
    }

    public Vector getTargetDelta() {
        EntityShulkerBullet bullet = this.getHandle();
        return new Vector(bullet.f, bullet.g, bullet.h);
    }

    public void setTargetDelta(Vector vector) {
        EntityShulkerBullet bullet = this.getHandle();
        bullet.f = vector.getX();
        bullet.g = vector.getY();
        bullet.h = vector.getZ();
    }

    public BlockFace getCurrentMovementDirection() {
        return CraftBlock.notchToBlockFace(this.getHandle().d);
    }

    public void setCurrentMovementDirection(BlockFace movementDirection) {
        this.getHandle().d = CraftBlock.blockFaceToNotch(movementDirection);
    }

    public int getFlightSteps() {
        return this.getHandle().e;
    }

    public void setFlightSteps(int steps) {
        this.getHandle().e = steps;
    }

    @Override
    public String toString() {
        return "CraftShulkerBullet";
    }

    public EntityType getType() {
        return EntityType.SHULKER_BULLET;
    }

    @Override
    public EntityShulkerBullet getHandle() {
        return (EntityShulkerBullet)this.entity;
    }
}

