/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftLocation;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Sniffer;

public class CraftSniffer
extends CraftAnimals
implements Sniffer {
    public CraftSniffer(CraftServer server, net.minecraft.world.entity.animal.sniffer.Sniffer entity) {
        super(server, entity);
    }

    @Override
    public net.minecraft.world.entity.animal.sniffer.Sniffer getHandle() {
        return (net.minecraft.world.entity.animal.sniffer.Sniffer)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftSniffer";
    }

    @Override
    public EntityType getType() {
        return EntityType.SNIFFER;
    }

    public Collection<Location> getExploredLocations() {
        return this.getHandle().gh().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).collect(Collectors.toList());
    }

    public void removeExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        BlockPosition blockPosition = CraftLocation.toBlockPosition(location);
        this.getHandle().dH().a(MemoryModuleType.aP, this.getHandle().gh().filter(blockPositionExplored -> !blockPositionExplored.equals(blockPosition)).collect(Collectors.toList()));
    }

    public void addExploredLocation(Location location) {
        Preconditions.checkArgument((location != null ? 1 : 0) != 0, (Object)"location cannot be null");
        if (location.getWorld() != this.getWorld()) {
            return;
        }
        this.getHandle().h(CraftLocation.toBlockPosition(location));
    }

    public Sniffer.State getState() {
        return this.stateToBukkit(this.getHandle().gd());
    }

    public void setState(Sniffer.State state) {
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state cannot be null");
        this.getHandle().a(this.stateToNMS(state));
    }

    public Location findPossibleDigLocation() {
        return this.getHandle().fS().map(blockPosition -> CraftLocation.toBukkit(blockPosition, this.getLocation().getWorld())).orElse(null);
    }

    public boolean canDig() {
        return this.getHandle().fY();
    }

    private Sniffer.a stateToNMS(Sniffer.State state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case Sniffer.State.IDLING -> Sniffer.a.a;
            case Sniffer.State.FEELING_HAPPY -> Sniffer.a.b;
            case Sniffer.State.SCENTING -> Sniffer.a.c;
            case Sniffer.State.SNIFFING -> Sniffer.a.d;
            case Sniffer.State.SEARCHING -> Sniffer.a.e;
            case Sniffer.State.DIGGING -> Sniffer.a.f;
            case Sniffer.State.RISING -> Sniffer.a.g;
        };
    }

    private Sniffer.State stateToBukkit(Sniffer.a state) {
        return switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case Sniffer.a.a -> Sniffer.State.IDLING;
            case Sniffer.a.b -> Sniffer.State.FEELING_HAPPY;
            case Sniffer.a.c -> Sniffer.State.SCENTING;
            case Sniffer.a.d -> Sniffer.State.SNIFFING;
            case Sniffer.a.e -> Sniffer.State.SEARCHING;
            case Sniffer.a.f -> Sniffer.State.DIGGING;
            case Sniffer.a.g -> Sniffer.State.RISING;
        };
    }
}

