/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.projectile.EntityPotion;
import net.minecraft.world.item.alchemy.PotionUtil;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftThrowableProjectile;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.potion.CraftPotionUtil;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LingeringPotion;
import org.bukkit.entity.SplashPotion;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;

public class CraftThrownPotion
extends CraftThrowableProjectile
implements ThrownPotion,
SplashPotion,
LingeringPotion {
    public CraftThrownPotion(CraftServer server, EntityPotion entity) {
        super(server, entity);
    }

    public Collection<PotionEffect> getEffects() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MobEffect effect : PotionUtil.a(this.getHandle().k())) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        return builder.build();
    }

    @Override
    public ItemStack getItem() {
        return CraftItemStack.asBukkitCopy(this.getHandle().k());
    }

    @Override
    public void setItem(ItemStack item) {
        Validate.notNull((Object)item, (String)"ItemStack cannot be null.");
        PotionMeta meta = item.getType() == Material.LINGERING_POTION || item.getType() == Material.SPLASH_POTION ? null : this.getPotionMeta();
        this.getHandle().a(CraftItemStack.asNMSCopy(item));
        if (meta != null) {
            this.setPotionMeta(meta);
        }
    }

    public PotionMeta getPotionMeta() {
        return (PotionMeta)CraftItemStack.getItemMeta(this.getHandle().k(), Material.SPLASH_POTION);
    }

    public void setPotionMeta(PotionMeta meta) {
        net.minecraft.world.item.ItemStack item = this.getHandle().i();
        CraftItemStack.applyMetaToItem(item, (ItemMeta)meta);
        this.getHandle().a(item);
    }

    public void splash() {
        this.getHandle().splash(null);
    }

    @Override
    public EntityPotion getHandle() {
        return (EntityPotion)this.entity;
    }

    public EntityType getType() {
        return EntityType.SPLASH_POTION;
    }
}

