/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.entity;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.monster.EntityZombieVillager;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_19_R3.CraftServer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftZombie;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class CraftVillagerZombie
extends CraftZombie
implements ZombieVillager {
    public CraftVillagerZombie(CraftServer server, EntityZombieVillager entity) {
        super(server, entity);
    }

    @Override
    public EntityZombieVillager getHandle() {
        return (EntityZombieVillager)super.getHandle();
    }

    @Override
    public String toString() {
        return "CraftVillagerZombie";
    }

    @Override
    public EntityType getType() {
        return EntityType.ZOMBIE_VILLAGER;
    }

    @Override
    public Villager.Profession getVillagerProfession() {
        return Villager.Profession.valueOf((String)BuiltInRegistries.z.b(this.getHandle().gd().b()).a().toUpperCase(Locale.ROOT));
    }

    @Override
    public void setVillagerProfession(Villager.Profession profession) {
        Validate.notNull((Object)profession);
        this.getHandle().a(this.getHandle().gd().a(BuiltInRegistries.z.a(new MinecraftKey(profession.name().toLowerCase(Locale.ROOT)))));
    }

    public Villager.Type getVillagerType() {
        return Villager.Type.valueOf((String)BuiltInRegistries.y.b(this.getHandle().gd().a()).a().toUpperCase(Locale.ROOT));
    }

    public void setVillagerType(Villager.Type type) {
        Validate.notNull((Object)type);
        this.getHandle().a(this.getHandle().gd().a(BuiltInRegistries.y.a(CraftNamespacedKey.toMinecraft(type.getKey()))));
    }

    @Override
    public boolean isConverting() {
        return this.getHandle().gc();
    }

    @Override
    public int getConversionTime() {
        Preconditions.checkState((boolean)this.isConverting(), (Object)"Entity not converting");
        return this.getHandle().ca;
    }

    @Override
    public void setConversionTime(int time) {
        this.setConversionTime(time, true);
    }

    public void setConversionTime(int time, boolean broadcastEntityEvent) {
        if (time < 0) {
            this.getHandle().ca = -1;
            this.getHandle().aj().b(EntityZombieVillager.c, false);
            this.getHandle().cb = null;
            this.getHandle().removeEffect(MobEffects.e, EntityPotionEffectEvent.Cause.CONVERSION);
        } else {
            this.getHandle().startConverting(null, time, broadcastEntityEvent);
        }
    }

    public OfflinePlayer getConversionPlayer() {
        return this.getHandle().cb == null ? null : Bukkit.getOfflinePlayer((UUID)this.getHandle().cb);
    }

    public void setConversionPlayer(OfflinePlayer conversionPlayer) {
        if (!this.isConverting()) {
            return;
        }
        this.getHandle().cb = conversionPlayer == null ? null : conversionPlayer.getUniqueId();
    }
}

