/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.inventory;

import com.google.common.base.Preconditions;
import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.GameMode;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

public class CraftInventoryView
extends InventoryView {
    private final Container container;
    private final CraftHumanEntity player;
    private final CraftInventory viewing;
    private final String originalTitle;
    private String title;

    public CraftInventoryView(HumanEntity player, Inventory viewing, Container container) {
        this.player = (CraftHumanEntity)player;
        this.viewing = (CraftInventory)viewing;
        this.container = container;
        this.title = this.originalTitle = CraftChatMessage.fromComponent(container.getTitle());
    }

    public Inventory getTopInventory() {
        return this.viewing;
    }

    public Inventory getBottomInventory() {
        return this.player.getInventory();
    }

    public HumanEntity getPlayer() {
        return this.player;
    }

    public InventoryType getType() {
        InventoryType type = this.viewing.getType();
        if (type == InventoryType.CRAFTING && this.player.getGameMode() == GameMode.CREATIVE) {
            return InventoryType.CREATIVE;
        }
        return type;
    }

    public void setItem(int slot, ItemStack item) {
        net.minecraft.world.item.ItemStack stack = CraftItemStack.asNMSCopy(item);
        if (slot >= 0) {
            this.container.b(slot).e(stack);
        } else {
            this.player.getHandle().a(stack, false);
        }
    }

    public ItemStack getItem(int slot) {
        if (slot < 0) {
            return null;
        }
        return CraftItemStack.asCraftMirror(this.container.b(slot).e());
    }

    public Component title() {
        return PaperAdventure.asAdventure(this.container.getTitle());
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public void setTitle(String title) {
        CraftInventoryView.sendInventoryTitleChange(this, title);
        this.title = title;
    }

    public boolean isInTop(int rawSlot) {
        return rawSlot < this.viewing.getSize();
    }

    public Container getHandle() {
        return this.container;
    }

    public static void sendInventoryTitleChange(InventoryView view, String title) {
        Preconditions.checkArgument((view != null ? 1 : 0) != 0, (Object)"InventoryView cannot be null");
        Preconditions.checkArgument((title != null ? 1 : 0) != 0, (Object)"Title cannot be null");
        Preconditions.checkArgument((boolean)(view.getPlayer() instanceof Player), (Object)"NPCs are not currently supported for this function");
        Preconditions.checkArgument((boolean)view.getTopInventory().getType().isCreatable(), (Object)"Only creatable inventories can have their title changed");
        EntityPlayer entityPlayer = (EntityPlayer)((CraftHumanEntity)view.getPlayer()).getHandle();
        int containerId = entityPlayer.bP.j;
        Containers windowType = CraftContainer.getNotchInventoryType(view.getTopInventory());
        entityPlayer.b.a(new PacketPlayOutOpenWindow(containerId, windowType, CraftChatMessage.fromString(title)[0]));
        ((Player)view.getPlayer()).updateInventory();
    }
}

