/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.inventory;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantRecipe;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;

public class CraftMerchantRecipe
extends org.bukkit.inventory.MerchantRecipe {
    private final MerchantRecipe handle;

    public CraftMerchantRecipe(MerchantRecipe merchantRecipe) {
        super(CraftItemStack.asBukkitCopy(merchantRecipe.c), 0);
        this.handle = merchantRecipe;
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.a));
        this.addIngredient(CraftItemStack.asBukkitCopy(merchantRecipe.b));
    }

    @Deprecated
    public CraftMerchantRecipe(org.bukkit.inventory.ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0, false);
    }

    public CraftMerchantRecipe(org.bukkit.inventory.ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, boolean ignoreDiscounts) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, 0, 0, ignoreDiscounts);
    }

    public CraftMerchantRecipe(org.bukkit.inventory.ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, int demand, int specialPrice) {
        this(result, uses, maxUses, experienceReward, experience, priceMultiplier, demand, specialPrice, false);
    }

    public CraftMerchantRecipe(org.bukkit.inventory.ItemStack result, int uses, int maxUses, boolean experienceReward, int experience, float priceMultiplier, int demand, int specialPrice, boolean ignoreDiscounts) {
        super(result, uses, maxUses, experienceReward, experience, priceMultiplier, demand, specialPrice, ignoreDiscounts);
        this.handle = new MerchantRecipe(ItemStack.b, ItemStack.b, CraftItemStack.asNMSCopy(result), uses, maxUses, experience, priceMultiplier, demand, ignoreDiscounts, this);
        this.setSpecialPrice(specialPrice);
        this.setExperienceReward(experienceReward);
    }

    public int getSpecialPrice() {
        return this.handle.m();
    }

    public void setSpecialPrice(int specialPrice) {
        this.handle.g = specialPrice;
    }

    public int getDemand() {
        return this.handle.h;
    }

    public void setDemand(int demand) {
        this.handle.h = demand;
    }

    public int getUses() {
        return this.handle.d;
    }

    public void setUses(int uses) {
        this.handle.d = uses;
    }

    public int getMaxUses() {
        return this.handle.e;
    }

    public void setMaxUses(int maxUses) {
        this.handle.e = maxUses;
    }

    public boolean hasExperienceReward() {
        return this.handle.f;
    }

    public void setExperienceReward(boolean flag) {
        this.handle.f = flag;
    }

    public int getVillagerExperience() {
        return this.handle.j;
    }

    public void setVillagerExperience(int villagerExperience) {
        this.handle.j = villagerExperience;
    }

    public float getPriceMultiplier() {
        return this.handle.i;
    }

    public void setPriceMultiplier(float priceMultiplier) {
        this.handle.i = priceMultiplier;
    }

    public boolean shouldIgnoreDiscounts() {
        return this.handle.ignoreDiscounts;
    }

    public void setIgnoreDiscounts(boolean ignoreDiscounts) {
        this.handle.ignoreDiscounts = ignoreDiscounts;
    }

    public MerchantRecipe toMinecraft() {
        List ingredients = this.getIngredients();
        Preconditions.checkState((!ingredients.isEmpty() ? 1 : 0) != 0, (Object)"No offered ingredients");
        this.handle.a = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)ingredients.get(0));
        if (ingredients.size() > 1) {
            this.handle.b = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)ingredients.get(1));
        }
        return this.handle;
    }

    public static CraftMerchantRecipe fromBukkit(org.bukkit.inventory.MerchantRecipe recipe) {
        if (recipe instanceof CraftMerchantRecipe) {
            return (CraftMerchantRecipe)recipe;
        }
        CraftMerchantRecipe craft = new CraftMerchantRecipe(recipe.getResult(), recipe.getUses(), recipe.getMaxUses(), recipe.hasExperienceReward(), recipe.getVillagerExperience(), recipe.getPriceMultiplier(), recipe.getDemand(), recipe.getSpecialPrice(), recipe.shouldIgnoreDiscounts());
        craft.setIngredients(recipe.getIngredients());
        return craft;
    }
}

