/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.inventory.util;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import org.bukkit.craftbukkit.v1_19_R3.inventory.util.CraftCustomInventoryConverter;
import org.bukkit.craftbukkit.v1_19_R3.inventory.util.CraftTileInventoryConverter;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public final class CraftInventoryCreator {
    public static final CraftInventoryCreator INSTANCE = new CraftInventoryCreator();
    private final CraftCustomInventoryConverter DEFAULT_CONVERTER = new CraftCustomInventoryConverter();
    private final Map<InventoryType, InventoryConverter> converterMap = new HashMap<InventoryType, InventoryConverter>();

    private CraftInventoryCreator() {
        this.converterMap.put(InventoryType.CHEST, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.DISPENSER, new CraftTileInventoryConverter.Dispenser());
        this.converterMap.put(InventoryType.DROPPER, new CraftTileInventoryConverter.Dropper());
        this.converterMap.put(InventoryType.FURNACE, new CraftTileInventoryConverter.Furnace());
        this.converterMap.put(InventoryType.WORKBENCH, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.ENCHANTING, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BREWING, new CraftTileInventoryConverter.BrewingStand());
        this.converterMap.put(InventoryType.PLAYER, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.MERCHANT, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.ENDER_CHEST, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.ANVIL, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.SMITHING, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BEACON, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.HOPPER, new CraftTileInventoryConverter.Hopper());
        this.converterMap.put(InventoryType.SHULKER_BOX, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BARREL, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.BLAST_FURNACE, new CraftTileInventoryConverter.BlastFurnace());
        this.converterMap.put(InventoryType.LECTERN, new CraftTileInventoryConverter.Lectern());
        this.converterMap.put(InventoryType.SMOKER, new CraftTileInventoryConverter.Smoker());
        this.converterMap.put(InventoryType.LOOM, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.CARTOGRAPHY, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.GRINDSTONE, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.STONECUTTER, this.DEFAULT_CONVERTER);
        this.converterMap.put(InventoryType.SMITHING_NEW, this.DEFAULT_CONVERTER);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type) {
        return this.converterMap.get(type).createInventory(holder, type);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type, Component title) {
        return this.converterMap.get(type).createInventory(holder, type, title);
    }

    public Inventory createInventory(InventoryHolder holder, InventoryType type, String title) {
        return this.converterMap.get(type).createInventory(holder, type, title);
    }

    public Inventory createInventory(InventoryHolder holder, int size) {
        return this.DEFAULT_CONVERTER.createInventory(holder, size);
    }

    public Inventory createInventory(InventoryHolder holder, int size, Component title) {
        return this.DEFAULT_CONVERTER.createInventory(holder, size, title);
    }

    public Inventory createInventory(InventoryHolder holder, int size, String title) {
        return this.DEFAULT_CONVERTER.createInventory(holder, size, title);
    }

    public static interface InventoryConverter {
        public Inventory createInventory(InventoryHolder var1, InventoryType var2);

        public Inventory createInventory(InventoryHolder var1, InventoryType var2, Component var3);

        public Inventory createInventory(InventoryHolder var1, InventoryType var2, String var3);
    }
}

