/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang.Validate;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_19_R3.persistence.CraftPersistentDataAdapterContext;
import org.bukkit.craftbukkit.v1_19_R3.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNBTTagConfigSerializer;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class CraftPersistentDataContainer
implements PersistentDataContainer {
    private final Map<String, NBTBase> customDataTags = new HashMap<String, NBTBase>();
    private final CraftPersistentDataTypeRegistry registry;
    private final CraftPersistentDataAdapterContext adapterContext;

    public CraftPersistentDataContainer(Map<String, NBTBase> customTags, CraftPersistentDataTypeRegistry registry) {
        this(registry);
        this.customDataTags.putAll(customTags);
    }

    public CraftPersistentDataContainer(CraftPersistentDataTypeRegistry registry) {
        this.registry = registry;
        this.adapterContext = new CraftPersistentDataAdapterContext(this.registry);
    }

    public <T, Z> void set(NamespacedKey key, PersistentDataType<T, Z> type, Z value) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        Validate.notNull(type, (String)"The provided type for the custom value was null");
        Validate.notNull(value, (String)"The provided value for the custom value was null");
        this.customDataTags.put(key.toString(), this.registry.wrap(type.getPrimitiveType(), type.toPrimitive(value, (PersistentDataAdapterContext)this.adapterContext)));
    }

    public <T, Z> boolean has(NamespacedKey key, PersistentDataType<T, Z> type) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        Validate.notNull(type, (String)"The provided type for the custom value was null");
        NBTBase value = this.customDataTags.get(key.toString());
        if (value == null) {
            return false;
        }
        return this.registry.isInstanceOf(type.getPrimitiveType(), value);
    }

    public <T, Z> Z get(NamespacedKey key, PersistentDataType<T, Z> type) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        Validate.notNull(type, (String)"The provided type for the custom value was null");
        NBTBase value = this.customDataTags.get(key.toString());
        if (value == null) {
            return null;
        }
        return (Z)type.fromPrimitive(this.registry.extract(type.getPrimitiveType(), value), (PersistentDataAdapterContext)this.adapterContext);
    }

    public <T, Z> Z getOrDefault(NamespacedKey key, PersistentDataType<T, Z> type, Z defaultValue) {
        Z z2 = this.get(key, type);
        return z2 != null ? z2 : defaultValue;
    }

    public Set<NamespacedKey> getKeys() {
        HashSet<NamespacedKey> keys = new HashSet<NamespacedKey>();
        this.customDataTags.keySet().forEach(key -> {
            String[] keyData = key.split(":", 2);
            if (keyData.length == 2) {
                keys.add(new NamespacedKey(keyData[0], keyData[1]));
            }
        });
        return keys;
    }

    public void remove(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        this.customDataTags.remove(key.toString());
    }

    public boolean isEmpty() {
        return this.customDataTags.isEmpty();
    }

    public PersistentDataAdapterContext getAdapterContext() {
        return this.adapterContext;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CraftPersistentDataContainer)) {
            return false;
        }
        Map<String, NBTBase> myRawMap = this.getRaw();
        Map<String, NBTBase> theirRawMap = ((CraftPersistentDataContainer)obj).getRaw();
        return Objects.equals(myRawMap, theirRawMap);
    }

    public NBTTagCompound toTagCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        for (Map.Entry<String, NBTBase> entry : this.customDataTags.entrySet()) {
            tag.a(entry.getKey(), entry.getValue());
        }
        return tag;
    }

    public void put(String key, NBTBase base) {
        this.customDataTags.put(key, base);
    }

    public void putAll(Map<String, NBTBase> map) {
        this.customDataTags.putAll(map);
    }

    public void putAll(NBTTagCompound compound) {
        for (String key : compound.e()) {
            this.customDataTags.put(key, compound.c(key));
        }
    }

    public Map<String, NBTBase> getRaw() {
        return this.customDataTags;
    }

    public CraftPersistentDataTypeRegistry getDataTagTypeRegistry() {
        return this.registry;
    }

    public int hashCode() {
        int hashCode = 3;
        return hashCode += this.customDataTags.hashCode();
    }

    public Map<String, Object> serialize() {
        return (Map)CraftNBTTagConfigSerializer.serialize(this.toTagCompound());
    }

    public void clear() {
        this.customDataTags.clear();
    }

    public boolean has(NamespacedKey key) {
        Validate.notNull((Object)key, (String)"The provided key for the custom value was null");
        return this.customDataTags.containsKey(key.toString());
    }

    public byte[] serializeToBytes() throws IOException {
        NBTTagCompound root = this.toTagCompound();
        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
        try (DataOutputStream dataOutput = new DataOutputStream(byteArrayOutput);){
            NBTCompressedStreamTools.a(root, (DataOutput)dataOutput);
            byte[] byArray = byteArrayOutput.toByteArray();
            return byArray;
        }
    }

    public void readFromBytes(byte[] bytes, boolean clear) throws IOException {
        if (clear) {
            this.clear();
        }
        try (DataInputStream dataInput = new DataInputStream(new ByteArrayInputStream(bytes));){
            NBTTagCompound compound = NBTCompressedStreamTools.a(dataInput);
            this.putAll(compound);
        }
    }
}

