/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.potion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.papermc.paper.potion.PotionMix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.alchemy.PotionRegistry;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_19_R3.potion.CraftPotionUtil;
import org.bukkit.potion.PotionBrewer;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class CraftPotionBrewer
implements PotionBrewer {
    private static final Map<Integer, Collection<PotionEffect>> cache = Maps.newHashMap();

    public Collection<PotionEffect> getEffects(PotionType damage, boolean upgraded, boolean extended) {
        int key = damage.ordinal() << 2;
        key |= (upgraded ? 1 : 0) << 1;
        if (cache.containsKey(key |= extended ? 1 : 0)) {
            return cache.get(key);
        }
        List<MobEffect> mcEffects = PotionRegistry.a(CraftPotionUtil.fromBukkit(new PotionData(damage, extended, upgraded))).a();
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (MobEffect effect : mcEffects) {
            builder.add((Object)CraftPotionUtil.toBukkit(effect));
        }
        cache.put(key, (Collection<PotionEffect>)builder.build());
        return cache.get(key);
    }

    public Collection<PotionEffect> getEffectsFromDamage(int damage) {
        return new ArrayList<PotionEffect>();
    }

    public PotionEffect createEffect(PotionEffectType potion, int duration, int amplifier) {
        return new PotionEffect(potion, potion.isInstant() ? 1 : (int)((double)duration * potion.getDurationModifier()), amplifier);
    }

    public void addPotionMix(PotionMix potionMix) {
        net.minecraft.world.item.alchemy.PotionBrewer.addPotionMix(potionMix);
    }

    public void removePotionMix(NamespacedKey key) {
        net.minecraft.world.item.alchemy.PotionBrewer.removePotionMix(key);
    }

    public void resetPotionMixes() {
        net.minecraft.world.item.alchemy.PotionBrewer.reload();
    }
}

