/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.scoreboard;

import io.papermc.paper.adventure.PaperAdventure;
import net.kyori.adventure.text.Component;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import org.apache.commons.lang.Validate;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_19_R3.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_19_R3.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_19_R3.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_19_R3.scoreboard.CraftScoreboardComponent;
import org.bukkit.craftbukkit.v1_19_R3.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftChatMessage;
import org.bukkit.entity.Entity;
import org.bukkit.scoreboard.Criteria;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;

final class CraftObjective
extends CraftScoreboardComponent
implements Objective {
    private final ScoreboardObjective objective;
    private final CraftCriteria criteria;

    CraftObjective(CraftScoreboard scoreboard, ScoreboardObjective objective) {
        super(scoreboard);
        this.objective = objective;
        this.criteria = CraftCriteria.getFromNMS(objective);
    }

    ScoreboardObjective getHandle() {
        return this.objective;
    }

    public String getName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.objective.b();
    }

    public Component displayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return PaperAdventure.asAdventure(this.objective.d());
    }

    public void displayName(Component displayName) throws IllegalStateException, IllegalArgumentException {
        if (displayName == null) {
            displayName = Component.empty();
        }
        CraftScoreboard scoreboard = this.checkState();
        this.objective.a(PaperAdventure.asVanilla(displayName));
    }

    public String getDisplayName() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftChatMessage.fromComponent(this.objective.d());
    }

    public void setDisplayName(String displayName) throws IllegalStateException, IllegalArgumentException {
        Validate.notNull((Object)displayName, (String)"Display name cannot be null");
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("Display name '" + displayName + "' is longer than the limit of 128 characters"));
        CraftScoreboard scoreboard = this.checkState();
        this.objective.a(CraftChatMessage.fromString(displayName)[0]);
    }

    public String getCriteria() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.criteria.bukkitName;
    }

    public Criteria getTrackedCriteria() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return this.criteria;
    }

    public boolean isModifiable() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return !this.criteria.criteria.e();
    }

    public void setDisplaySlot(DisplaySlot slot) throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        ScoreboardObjective objective = this.objective;
        for (int i2 = 0; i2 < CraftScoreboardTranslations.MAX_DISPLAY_SLOT; ++i2) {
            if (board.a(i2) != objective) continue;
            board.a(i2, null);
        }
        if (slot != null) {
            int slotNumber = CraftScoreboardTranslations.fromBukkitSlot(slot);
            board.a(slotNumber, this.getHandle());
        }
    }

    public DisplaySlot getDisplaySlot() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        Scoreboard board = scoreboard.board;
        ScoreboardObjective objective = this.objective;
        for (int i2 = 0; i2 < CraftScoreboardTranslations.MAX_DISPLAY_SLOT; ++i2) {
            if (board.a(i2) != objective) continue;
            return CraftScoreboardTranslations.toBukkitSlot(i2);
        }
        return null;
    }

    public void setRenderType(RenderType renderType) throws IllegalStateException {
        Validate.notNull((Object)renderType, (String)"RenderType cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        this.objective.a(CraftScoreboardTranslations.fromBukkitRender(renderType));
    }

    public RenderType getRenderType() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        return CraftScoreboardTranslations.toBukkitRender(this.objective.f());
    }

    public Score getScore(OfflinePlayer player) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)player, (String)"Player cannot be null");
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, player.getName());
    }

    public Score getScore(String entry) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        Validate.isTrue((entry.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("Score '" + entry + "' is longer than the limit of 32767 characters"));
        CraftScoreboard scoreboard = this.checkState();
        return new CraftScore(this, entry);
    }

    public Score getScoreFor(Entity entity) throws IllegalArgumentException, IllegalStateException {
        Validate.notNull((Object)entity, (String)"Entity cannot be null");
        return this.getScore(((CraftEntity)entity).getHandle().cu());
    }

    @Override
    public void unregister() throws IllegalStateException {
        CraftScoreboard scoreboard = this.checkState();
        scoreboard.board.j(this.objective);
    }

    @Override
    CraftScoreboard checkState() throws IllegalStateException {
        if (this.getScoreboard().board.d(this.objective.b()) == null) {
            throw new IllegalStateException("Unregistered scoreboard component");
        }
        return this.getScoreboard();
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (this.objective != null ? this.objective.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftObjective other = (CraftObjective)obj;
        return this.objective == other.objective || this.objective != null && this.objective.equals(other.objective);
    }
}

