/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R3.tag;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityTypes;
import org.bukkit.Registry;
import org.bukkit.craftbukkit.v1_19_R3.tag.CraftTag;
import org.bukkit.craftbukkit.v1_19_R3.util.CraftNamespacedKey;
import org.bukkit.entity.EntityType;

public class CraftEntityTag
extends CraftTag<EntityTypes<?>, EntityType> {
    private static final Map<EntityType, ResourceKey<EntityTypes<?>>> KEY_CACHE = Collections.synchronizedMap(new EnumMap(EntityType.class));

    public CraftEntityTag(IRegistry<EntityTypes<?>> registry, TagKey<EntityTypes<?>> tag) {
        super(registry, tag);
    }

    public boolean isTagged(EntityType entity) {
        return this.registry.f(KEY_CACHE.computeIfAbsent(entity, type -> ResourceKey.a(Registries.r, CraftNamespacedKey.toMinecraft(type.getKey())))).a(this.tag);
    }

    public Set<EntityType> getValues() {
        return this.getHandle().a().map(nms -> (EntityType)Registry.ENTITY_TYPE.get(CraftNamespacedKey.fromMinecraft(EntityTypes.a((EntityTypes)nms.a())))).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
    }
}

