/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves;

import com.destroystokyo.paper.util.SneakyThrow;
import com.google.common.base.Throwables;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.bot.BotCommand;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.profile.LeavesMinecraftSessionService;
import top.leavesmc.leaves.protocol.syncmatica.SyncmaticaProtocol;
import top.leavesmc.leaves.util.MathUtils;

public final class LeavesConfig {
    public static final String CONFIG_HEADER = "Configuration file for Leaves.";
    public static final int CURRENT_CONFIG_VERSION = 2;
    private static final Object[] EMPTY = new Object[0];
    private static File configFile;
    public static YamlConfiguration config;
    private static int configVersion;
    public static boolean createWorldSections;
    static Map<String, Command> commands;
    public static boolean playerCanEditSign;
    public static boolean snowballAndEggCanKnockback;
    public static boolean fakeplayerSupport;
    public static List<String> unableFakeplayerNames;
    public static int fakeplayerLimit;
    public static String fakeplayerPrefix;
    public static String fakeplayerSuffix;
    public static boolean alwaysSendFakeplayerData;
    public static boolean fakeplayerResident;
    public static boolean openFakeplayerInventory;
    public static boolean fakeplayerSkipSleep;
    public static boolean shearsInDispenserCanZeroAmount;
    public static boolean redstoneShearsWrench;
    public static boolean buddingAmethystCanPushByPiston;
    public static boolean spectatorDontGetAdvancement;
    public static boolean stickChangeArmorStandArmStatus;
    public static boolean noChatSign;
    public static boolean asyncMobSpawning;
    private static boolean asyncMobSpawningLock;
    public static boolean dontSendUselessEntityPackets;
    public static boolean asyncEntityTracker;
    private static boolean asyncEntityTrackerLock;
    public static boolean fixPaper6045;
    public static boolean optimizeEntityCoordinateKey;
    public static boolean enableSuffocationOptimization;
    public static boolean entityStripRaytracing;
    public static boolean checkSpookySeasonOnceAnHour;
    public static boolean optimizeChunkTicking;
    private static boolean optimizeChunkTickingLock;
    public static boolean skipPOIFindingInVehicle;
    public static boolean entityTargetFindingOptimization;
    public static boolean useMoreThreadUnsafeRandom;
    public static boolean disableMethodProfiler;
    public static boolean throttleInactiveGoalSelectorTick;
    public static boolean skipCloneLootParameters;
    public static boolean reduceEntityAllocations;
    public static boolean removeTickGuardLambda;
    public static boolean removeInventoryContainsIterators;
    public static boolean removeGetNearPlayerStreams;
    public static boolean removeRangeCheckStreams;
    public static boolean asyncPathfinding;
    private static boolean asyncPathfindingLock;
    public static boolean cacheClimbCheck;
    public static boolean biomeTemperaturesUseAgingCache;
    private static boolean biomeTemperaturesUseAgingCacheLock;
    public static boolean reduceEntityFluidLookup;
    public static boolean reduceChuckLoadAndLookup;
    public static boolean simplerVanillaShapelessRecipes;
    public static boolean pcaSyncProtocol;
    public static String pcaSyncPlayerEntity;
    private static final List<String> pcaSyncPlayerEntityList;
    public static boolean bborProtocol;
    public static boolean instantBlockUpdaterReintroduced;
    private static boolean instantBlockUpdaterReintroducedLock;
    public static boolean flattenTriangularDistribution;
    public static boolean jadeProtocol;
    public static boolean carpetAlternativeBlockPlacement;
    public static boolean playerOperationLimiter;
    public static double renewableElytra;
    public static int shulkerBoxStackSize;
    private static String stackableShulkerBoxes;
    public static boolean improveFluidDirectionCaching;
    private static boolean improveFluidDirectionCachingLock;
    public static boolean mcTechnicalMode;
    public static boolean netherPortalFix;
    public static boolean appleskinProtocol;
    public static boolean xaeroMapProtocol;
    public static int xaeroMapServerID;
    public static boolean extraYggdrasilService;
    public static List<String> extraYggdrasilServiceList;
    public static boolean useVanillaRandom;
    private static boolean useVanillaRandomLock;
    public static boolean updateSuppressionCrashFix;
    public static boolean bedrockBreakList;
    private static boolean bedrockBreakListLock;
    public static boolean syncmaticaProtocol;
    public static boolean syncmaticaQuota;
    public static int syncmaticaQuotaLimit;
    public static boolean disableDistanceCheckForUseItem;
    public static boolean noFeatherFallingTrample;
    public static boolean sharedVillagerDiscounts;

    public static void init(File file) {
        configFile = file;
        config = new YamlConfiguration();
        config.options().header(CONFIG_HEADER);
        config.options().copyDefaults(true);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failure to create leaves config", ex);
            }
        } else {
            try {
                config.load(file);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Failure to load leaves config", ex);
                SneakyThrow.sneaky((Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        if (config.contains("config-version-please-do-not-modify-me")) {
            LeavesConfig.set("config-version-please-do-not-modify-me", null);
        }
        configVersion = LeavesConfig.getInt("config-version", 2);
        LeavesConfig.set("config-version", 2);
        LeavesConfig.updateConfigVersion(config);
        LeavesConfig.load(config);
        commands = new HashMap<String, Command>();
        if (fakeplayerSupport) {
            commands.put("bot", new BotCommand("bot"));
            Actions.registerAll();
        }
    }

    public static void load(YamlConfiguration config) {
        for (Method method : LeavesConfig.class.getDeclaredMethods()) {
            if (!Modifier.isPrivate(method.getModifiers()) || method.getParameterTypes().length != 0 || method.getReturnType() != Void.TYPE) continue;
            try {
                method.setAccessible(true);
                method.invoke(null, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                throw Throwables.propagate((Throwable)ex.getCause());
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Error invoking " + method, ex);
            }
        }
        try {
            config.save(configFile);
        }
        catch (Exception ex) {
            Bukkit.getLogger().log(Level.SEVERE, "Unable to save leaves config", ex);
        }
    }

    private static void updateConfigVersion(YamlConfiguration config) {
        if (configVersion < 2) {
            playerCanEditSign = config.getBoolean("settings.player-can-edit-sign", playerCanEditSign);
            snowballAndEggCanKnockback = config.getBoolean("settings.snowball-and-egg-can-knockback-player", snowballAndEggCanKnockback);
            fakeplayerSupport = config.getBoolean("settings.fakeplayer.enable", fakeplayerSupport);
            unableFakeplayerNames = config.getList("settings.fakeplayer.unable-fakeplayer-names", unableFakeplayerNames);
            shearsInDispenserCanZeroAmount = config.getBoolean("settings.shears-in-dispenser-can-zero-amount", shearsInDispenserCanZeroAmount);
            redstoneShearsWrench = config.getBoolean("settings.redstone-shears-wrench", redstoneShearsWrench);
            buddingAmethystCanPushByPiston = config.getBoolean("settings.budding-amethyst-can-push-by-piston", buddingAmethystCanPushByPiston);
            spectatorDontGetAdvancement = config.getBoolean("settings.spectator-dont-get-advancement", spectatorDontGetAdvancement);
            stickChangeArmorStandArmStatus = config.getBoolean("settings.stick-change-armorstand-arm-status", stickChangeArmorStandArmStatus);
            noChatSign = config.getBoolean("settings.no-chat-sign", noChatSign);
            config.set("settings.snowball-and-egg-can-knockback-player", null);
            config.set("settings.player-can-edit-sign", null);
            config.set("settings.fakeplayer", null);
            config.set("settings.shears-in-dispenser-can-zero-amount", null);
            config.set("settings.redstone-shears-wrench", null);
            config.set("settings.budding-amethyst-can-push-by-piston", null);
            config.set("settings.spectator-dont-get-advancement", null);
            config.set("settings.stick-change-armorstand-arm-status", null);
            config.set("settings.no-chat-sign", null);
        }
    }

    static void set(String path, Object value) {
        config.set(path, value);
    }

    public static void registerCommands() {
        for (Map.Entry<String, Command> entry : commands.entrySet()) {
            MinecraftServer.getServer().server.getCommandMap().register(entry.getKey(), "Leaves", entry.getValue());
        }
    }

    static boolean getBoolean(String path, boolean dfl) {
        config.addDefault(path, (Object)dfl);
        return config.getBoolean(path, dfl);
    }

    static int getInt(String path, int dfl) {
        config.addDefault(path, (Object)dfl);
        return config.getInt(path, dfl);
    }

    static long getLong(String path, long dfl) {
        config.addDefault(path, (Object)dfl);
        return config.getLong(path, dfl);
    }

    static double getDouble(String path, double dfl) {
        config.addDefault(path, (Object)dfl);
        return config.getDouble(path, dfl);
    }

    static String getString(String path, String dfl) {
        config.addDefault(path, (Object)dfl);
        return config.getString(path, dfl);
    }

    static <T> List<T> getList(String path, List<T> def) {
        config.addDefault(path, def);
        return config.getList(path, config.getList(path));
    }

    private static void playerCanEditSign() {
        playerCanEditSign = LeavesConfig.getBoolean("settings.modify.player-can-edit-sign", playerCanEditSign);
    }

    private static void snowballAndEggCanKnockback() {
        snowballAndEggCanKnockback = LeavesConfig.getBoolean("settings.modify.snowball-and-egg-can-knockback-player", snowballAndEggCanKnockback);
    }

    private static void fakeplayer() {
        fakeplayerSupport = LeavesConfig.getBoolean("settings.modify.fakeplayer.enable", fakeplayerSupport);
        unableFakeplayerNames = LeavesConfig.getList("settings.modify.fakeplayer.unable-fakeplayer-names", unableFakeplayerNames);
        fakeplayerLimit = LeavesConfig.getInt("settings.modify.fakeplayer.limit", fakeplayerLimit);
        fakeplayerPrefix = LeavesConfig.getString("settings.modify.fakeplayer.prefix", fakeplayerPrefix);
        fakeplayerSuffix = LeavesConfig.getString("settings.modify.fakeplayer.suffix", fakeplayerSuffix);
        alwaysSendFakeplayerData = LeavesConfig.getBoolean("settings.modify.fakeplayer.always-send-data", alwaysSendFakeplayerData);
        fakeplayerResident = LeavesConfig.getBoolean("settings.modify.fakeplayer.resident-fakeplayer", fakeplayerResident);
        openFakeplayerInventory = LeavesConfig.getBoolean("settings.modify.fakeplayer.open-fakeplayer-inventory", openFakeplayerInventory);
        fakeplayerSkipSleep = LeavesConfig.getBoolean("settings.modify.fakeplayer.skip-sleep-check", fakeplayerSkipSleep);
    }

    private static void shearsInDispenserCanZeroAmount() {
        shearsInDispenserCanZeroAmount = LeavesConfig.getBoolean("settings.modify.shears-in-dispenser-can-zero-amount", shearsInDispenserCanZeroAmount);
    }

    private static void redstoneShearsWrench() {
        redstoneShearsWrench = LeavesConfig.getBoolean("settings.modify.redstone-shears-wrench", redstoneShearsWrench);
    }

    private static void buddingAmethystCanPushByPiston() {
        buddingAmethystCanPushByPiston = LeavesConfig.getBoolean("settings.modify.budding-amethyst-can-push-by-piston", buddingAmethystCanPushByPiston);
    }

    private static void spectatorDontGetAdvancement() {
        spectatorDontGetAdvancement = LeavesConfig.getBoolean("settings.modify.spectator-dont-get-advancement", spectatorDontGetAdvancement);
    }

    private static void stickChangeArmorStandHasArm() {
        stickChangeArmorStandArmStatus = LeavesConfig.getBoolean("settings.modify.stick-change-armorstand-arm-status", stickChangeArmorStandArmStatus);
    }

    private static void noChatSign() {
        if (config.contains("settings.modify.no-chat-sign")) {
            noChatSign = config.getBoolean("settings.modify.no-chat-sign");
            config.set("settings.modify.no-chat-sign", null);
        }
        noChatSign = LeavesConfig.getBoolean("settings.misc.no-chat-sign", noChatSign);
    }

    private static void asyncMobSpawning() {
        if (!asyncMobSpawningLock) {
            asyncMobSpawning = LeavesConfig.getBoolean("settings.performance.async-mob-spawning", asyncMobSpawning);
            asyncMobSpawningLock = true;
        }
        if (asyncMobSpawning) {
            asyncMobSpawning = false;
            LeavesLogger.LOGGER.severe("Async MobSpawning is updating, it can't work");
        }
    }

    private static void dontSendUselessEntityPackets() {
        dontSendUselessEntityPackets = LeavesConfig.getBoolean("settings.performance.dont-send-useless-entity-packets", dontSendUselessEntityPackets);
    }

    private static void asyncEntityTracker() {
        if (!asyncEntityTrackerLock) {
            asyncEntityTracker = LeavesConfig.getBoolean("settings.performance.async-entity-tracker", asyncEntityTracker);
            asyncEntityTrackerLock = true;
        }
        if (asyncEntityTracker) {
            asyncEntityTracker = false;
            LeavesLogger.LOGGER.severe("Async EntityTracker is updating, it can't work");
        }
    }

    private static void fixPaper6045() {
        fixPaper6045 = LeavesConfig.getBoolean("settings.performance.fix.fix-paper-6045", fixPaper6045);
    }

    private static void optimizeEntityCoordinateKey() {
        optimizeEntityCoordinateKey = LeavesConfig.getBoolean("settings.performance.optimize-entity-coordinate-key", optimizeEntityCoordinateKey);
    }

    private static void enableSuffocationOptimization() {
        enableSuffocationOptimization = LeavesConfig.getBoolean("settings.performance.enable-suffocation-optimization", enableSuffocationOptimization);
    }

    private static void entityStripRaytracing() {
        entityStripRaytracing = LeavesConfig.getBoolean("settings.performance.strip-raytracing-for-entity", entityStripRaytracing);
    }

    private static void checkSpookySeasonOnceAnHour() {
        checkSpookySeasonOnceAnHour = LeavesConfig.getBoolean("settings.performance.check-spooky-season-once-an-hour", checkSpookySeasonOnceAnHour);
    }

    private static void optimizeChunkTicking() {
        if (!optimizeChunkTickingLock) {
            optimizeChunkTicking = LeavesConfig.getBoolean("settings.performance.optimize-chunk-ticking", optimizeChunkTicking);
            optimizeChunkTickingLock = true;
        }
    }

    private static void skipPOIFindingInVehicle() {
        skipPOIFindingInVehicle = LeavesConfig.getBoolean("settings.performance.skip-poi-find-in-vehicle", skipPOIFindingInVehicle);
    }

    private static void entityTargetFindingOptimization() {
        entityTargetFindingOptimization = LeavesConfig.getBoolean("settings.performance.entity-target-find-optimization", entityTargetFindingOptimization);
    }

    private static void useMoreThreadUnsafeRandom() {
        useMoreThreadUnsafeRandom = LeavesConfig.getBoolean("settings.performance.use-more-thread-unsafe-random", useMoreThreadUnsafeRandom);
    }

    private static void disableMethodProfiler() {
        disableMethodProfiler = LeavesConfig.getBoolean("settings.misc.disable-method-profiler", disableMethodProfiler);
    }

    private static void throttleInactiveGoalSelectorTick() {
        throttleInactiveGoalSelectorTick = LeavesConfig.getBoolean("settings.performance.inactive-goal-selector-disable", throttleInactiveGoalSelectorTick);
    }

    private static void skipCloneLootParameters() {
        skipCloneLootParameters = LeavesConfig.getBoolean("settings.performance.skip-clone-loot-parameters", skipCloneLootParameters);
    }

    private static void reduceEntityAllocations() {
        reduceEntityAllocations = LeavesConfig.getBoolean("settings.performance.reduce-entity-allocations", reduceEntityAllocations);
    }

    private static void removeTickGuardLambda() {
        removeTickGuardLambda = LeavesConfig.getBoolean("settings.performance.remove.tick-guard-lambda", removeTickGuardLambda);
    }

    private static void removeInventoryContainsIterators() {
        removeInventoryContainsIterators = LeavesConfig.getBoolean("settings.performance.remove.inventory-contains-iterators", removeInventoryContainsIterators);
    }

    private static void removeGetNearPlayerStreams() {
        removeGetNearPlayerStreams = LeavesConfig.getBoolean("settings.performance.remove.get-nearby-players-streams", removeGetNearPlayerStreams);
    }

    private static void removeRangeCheckStreams() {
        removeRangeCheckStreams = LeavesConfig.getBoolean("settings.performance.remove.range-check-streams-and-iterators", removeRangeCheckStreams);
    }

    private static void asyncPathfinding() {
        if (!asyncPathfindingLock) {
            asyncPathfinding = LeavesConfig.getBoolean("settings.performance.async-pathfinding", asyncPathfinding);
            asyncPathfindingLock = true;
        }
        if (asyncPathfinding) {
            asyncPathfinding = false;
            LeavesLogger.LOGGER.severe("Async Pathfinding is updating, it can't work");
        }
    }

    private static void cacheClimbCheck() {
        cacheClimbCheck = LeavesConfig.getBoolean("settings.performance.cache-climb-check", cacheClimbCheck);
    }

    private static void biomeTemperaturesUseAgingCache() {
        if (!biomeTemperaturesUseAgingCacheLock) {
            biomeTemperaturesUseAgingCache = LeavesConfig.getBoolean("settings.performance.biome-temperatures-use-aging-cache", biomeTemperaturesUseAgingCache);
            biomeTemperaturesUseAgingCacheLock = true;
        }
    }

    private static void reduceEntityFluidLookup() {
        reduceEntityFluidLookup = LeavesConfig.getBoolean("settings.performance.reduce-entity-fluid-lookup", reduceEntityFluidLookup);
    }

    private static void reduceChuckLoadAndLookup() {
        reduceChuckLoadAndLookup = LeavesConfig.getBoolean("settings.performance.reduce-chuck-load-and-lookup", reduceChuckLoadAndLookup);
    }

    private static void simplerVanillaShapelessRecipes() {
        simplerVanillaShapelessRecipes = LeavesConfig.getBoolean("settings.performance.simpler-vanilla-shapeless-recipes", simplerVanillaShapelessRecipes);
    }

    private static void pcaSyncProtocol() {
        pcaSyncProtocol = LeavesConfig.getBoolean("settings.protocol.pca-sync-protocol", pcaSyncProtocol);
    }

    private static void pcaSyncPlayerEntity() {
        if (!pcaSyncPlayerEntityList.contains(pcaSyncPlayerEntity = LeavesConfig.getString("settings.protocol.pca-sync-player-entity", pcaSyncPlayerEntity))) {
            pcaSyncPlayerEntity = "OPS";
            LeavesLogger.LOGGER.severe("pca-sync-player-entity value error, reset to OPS");
        }
    }

    private static void bborProtocol() {
        bborProtocol = LeavesConfig.getBoolean("settings.protocol.bbor-protocol", bborProtocol);
    }

    private static void instantBlockUpdaterReintroduced() {
        if (!instantBlockUpdaterReintroducedLock) {
            instantBlockUpdaterReintroduced = LeavesConfig.getBoolean("settings.modify.instant-block-updater-reintroduced", instantBlockUpdaterReintroduced);
            instantBlockUpdaterReintroducedLock = true;
        }
    }

    private static void flattenTriangularDistribution() {
        flattenTriangularDistribution = LeavesConfig.getBoolean("settings.modify.flatten-triangular-distribution", flattenTriangularDistribution);
    }

    private static void jadeProtocol() {
        jadeProtocol = LeavesConfig.getBoolean("settings.protocol.jade-protocol", jadeProtocol);
    }

    private static void carpetAlternativeBlockPlacement() {
        carpetAlternativeBlockPlacement = LeavesConfig.getBoolean("settings.protocol.carpet-alternative-block-placement", carpetAlternativeBlockPlacement);
    }

    private static void playerOperationLimiter() {
        playerOperationLimiter = LeavesConfig.getBoolean("settings.modify.player-operation-limiter", playerOperationLimiter);
    }

    private static void renewableElytra() {
        renewableElytra = LeavesConfig.getDouble("settings.modify.renewable-elytra", renewableElytra);
    }

    private static void stackableShulkerBoxes() {
        stackableShulkerBoxes = MathUtils.isNumeric(stackableShulkerBoxes = LeavesConfig.getString("settings.modify.stackable-shulker-boxes", stackableShulkerBoxes)) ? stackableShulkerBoxes : (stackableShulkerBoxes.equals("true") ? "2" : "1");
        shulkerBoxStackSize = Integer.parseInt(stackableShulkerBoxes);
    }

    private static void improveFluidDirectionCaching() {
        if (!improveFluidDirectionCachingLock) {
            improveFluidDirectionCaching = LeavesConfig.getBoolean("settings.performance.improve-fluid-direction-caching", improveFluidDirectionCaching);
            improveFluidDirectionCachingLock = true;
        }
    }

    private static void mcTechnicalMode() {
        mcTechnicalMode = LeavesConfig.getBoolean("settings.modify.mc-technical-survival-mode", mcTechnicalMode);
        LeavesConfig.doMcTechnicalMode();
    }

    public static void doMcTechnicalMode() {
        if (mcTechnicalMode) {
            GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication = true;
            GlobalConfiguration.get().unsupportedSettings.allowHeadlessPistons = true;
            GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits = true;
            GlobalConfiguration.get().packetLimiter.allPackets = new GlobalConfiguration.PacketLimiter.PacketLimit(GlobalConfiguration.get().packetLimiter.allPackets.interval(), 5000.0, GlobalConfiguration.get().packetLimiter.allPackets.action());
            GlobalConfiguration.get().packetLimiter.overrides = Map.of();
            GlobalConfiguration.get().unsupportedSettings.allowGrindstoneOverstacking = true;
        }
    }

    private static void netherPortalFix() {
        netherPortalFix = LeavesConfig.getBoolean("settings.modify.return-nether-portal-fix", netherPortalFix);
    }

    private static void appleskinProtocol() {
        appleskinProtocol = LeavesConfig.getBoolean("settings.protocol.appleskin-protocol", appleskinProtocol);
    }

    private static void xaeroMapProtocol() {
        xaeroMapProtocol = LeavesConfig.getBoolean("settings.protocol.xaero-map-protocol", xaeroMapProtocol);
        xaeroMapServerID = LeavesConfig.getInt("settings.protocol.xaero-map-server-id", xaeroMapServerID);
    }

    private static void extraYggdrasilService() {
        extraYggdrasilService = LeavesConfig.getBoolean("settings.misc.extra-yggdrasil-service.enable", extraYggdrasilService);
        extraYggdrasilServiceList = LeavesConfig.getList("settings.misc.extra-yggdrasil-service.urls", extraYggdrasilServiceList);
        if (extraYggdrasilService) {
            LeavesLogger.LOGGER.warning("extra-yggdrasil-service is an unofficial support. Enabling it may cause data security problems!");
            GlobalConfiguration.get().unsupportedSettings.performUsernameValidation = true;
            LeavesMinecraftSessionService.initExtraYggdrasilList();
        }
    }

    private static void useVanillaRandom() {
        if (!useVanillaRandomLock) {
            useVanillaRandom = LeavesConfig.getBoolean("settings.modify.use-vanilla-random", useVanillaRandom);
            useVanillaRandomLock = true;
        }
    }

    private static void updateSuppressionCrashFix() {
        updateSuppressionCrashFix = LeavesConfig.getBoolean("settings.modify.fix-update-suppression-crash", updateSuppressionCrashFix);
    }

    private static void bedrockBreakList() {
        if (!bedrockBreakListLock) {
            bedrockBreakList = LeavesConfig.getBoolean("settings.modify.bedrock-break-list", bedrockBreakList);
            bedrockBreakListLock = true;
        }
    }

    private static void syncmaticaProtocol() {
        syncmaticaProtocol = LeavesConfig.getBoolean("settings.protocol.syncmatica.enable", syncmaticaProtocol);
        syncmaticaQuota = LeavesConfig.getBoolean("settings.protocol.syncmatica.quota", syncmaticaQuota);
        syncmaticaQuotaLimit = LeavesConfig.getInt("settings.protocol.syncmatica.quota-limit", syncmaticaQuotaLimit);
        if (syncmaticaProtocol) {
            SyncmaticaProtocol.init();
        }
    }

    private static void disableDistanceCheckForUseItem() {
        disableDistanceCheckForUseItem = LeavesConfig.getBoolean("settings.modify.disable-distance-check-for-use-item", disableDistanceCheckForUseItem);
        if (carpetAlternativeBlockPlacement) {
            disableDistanceCheckForUseItem = true;
        }
    }

    private static void noFeatherFallingTrample() {
        noFeatherFallingTrample = LeavesConfig.getBoolean("settings.modify.no-feather-falling-trample", noFeatherFallingTrample);
    }

    private static void sharedVillagerDiscounts() {
        sharedVillagerDiscounts = LeavesConfig.getBoolean("settings.modify.shared-villager-discounts", sharedVillagerDiscounts);
    }

    static {
        createWorldSections = true;
        playerCanEditSign = true;
        snowballAndEggCanKnockback = true;
        fakeplayerSupport = true;
        unableFakeplayerNames = List.of("player-name");
        fakeplayerLimit = 10;
        fakeplayerPrefix = "";
        fakeplayerSuffix = "";
        alwaysSendFakeplayerData = true;
        fakeplayerResident = false;
        openFakeplayerInventory = false;
        fakeplayerSkipSleep = false;
        shearsInDispenserCanZeroAmount = false;
        redstoneShearsWrench = true;
        buddingAmethystCanPushByPiston = false;
        spectatorDontGetAdvancement = false;
        stickChangeArmorStandArmStatus = true;
        noChatSign = true;
        asyncMobSpawning = false;
        asyncMobSpawningLock = false;
        dontSendUselessEntityPackets = true;
        asyncEntityTracker = false;
        asyncEntityTrackerLock = false;
        fixPaper6045 = true;
        optimizeEntityCoordinateKey = true;
        enableSuffocationOptimization = true;
        entityStripRaytracing = true;
        checkSpookySeasonOnceAnHour = true;
        optimizeChunkTicking = true;
        optimizeChunkTickingLock = false;
        skipPOIFindingInVehicle = true;
        entityTargetFindingOptimization = true;
        useMoreThreadUnsafeRandom = true;
        disableMethodProfiler = true;
        throttleInactiveGoalSelectorTick = false;
        skipCloneLootParameters = true;
        reduceEntityAllocations = true;
        removeTickGuardLambda = true;
        removeInventoryContainsIterators = true;
        removeGetNearPlayerStreams = true;
        removeRangeCheckStreams = true;
        asyncPathfinding = false;
        asyncPathfindingLock = false;
        cacheClimbCheck = true;
        biomeTemperaturesUseAgingCache = true;
        biomeTemperaturesUseAgingCacheLock = false;
        reduceEntityFluidLookup = true;
        reduceChuckLoadAndLookup = true;
        simplerVanillaShapelessRecipes = true;
        pcaSyncProtocol = false;
        pcaSyncPlayerEntity = "OPS";
        pcaSyncPlayerEntityList = List.of("NOBODY", "BOT", "OPS", "OPS_AND_SELF", "EVERYONE");
        bborProtocol = false;
        instantBlockUpdaterReintroduced = false;
        instantBlockUpdaterReintroducedLock = false;
        flattenTriangularDistribution = false;
        jadeProtocol = false;
        carpetAlternativeBlockPlacement = false;
        playerOperationLimiter = false;
        renewableElytra = -1.0;
        shulkerBoxStackSize = 1;
        stackableShulkerBoxes = "false";
        improveFluidDirectionCaching = true;
        improveFluidDirectionCachingLock = false;
        mcTechnicalMode = true;
        netherPortalFix = false;
        appleskinProtocol = false;
        xaeroMapProtocol = false;
        xaeroMapServerID = new Random().nextInt();
        extraYggdrasilService = false;
        extraYggdrasilServiceList = List.of("https://url.with.authlib-injector-yggdrasil");
        useVanillaRandom = false;
        useVanillaRandomLock = false;
        updateSuppressionCrashFix = true;
        bedrockBreakList = false;
        bedrockBreakListLock = false;
        syncmaticaProtocol = false;
        syncmaticaQuota = false;
        syncmaticaQuotaLimit = 40000000;
        disableDistanceCheckForUseItem = false;
        noFeatherFallingTrample = false;
        sharedVillagerDiscounts = false;
    }

    public static final class WorldConfig {
        public final String worldName;
        public String configPath;
        ConfigurationSection worldDefaults;

        public WorldConfig(String worldName) {
            this.worldName = worldName;
            this.init();
        }

        public void init() {
            this.worldDefaults = config.getConfigurationSection("world-settings.default");
            if (this.worldDefaults == null) {
                this.worldDefaults = config.createSection("world-settings.default");
            }
            String worldSectionPath = configVersion < 2 ? this.worldName : "world-settings.".concat(this.worldName);
            ConfigurationSection section = config.getConfigurationSection(worldSectionPath);
            this.configPath = worldSectionPath;
            if (createWorldSections) {
                if (section == null) {
                    section = config.createSection(worldSectionPath);
                }
                config.set(worldSectionPath, (Object)section);
            }
            this.load();
        }

        public void load() {
            for (Method method : WorldConfig.class.getDeclaredMethods()) {
                if (method.getReturnType() != Void.TYPE || method.getParameterCount() != 0 || !Modifier.isPrivate(method.getModifiers()) || Modifier.isStatic(method.getModifiers())) continue;
                try {
                    method.setAccessible(true);
                    method.invoke((Object)this, EMPTY);
                }
                catch (Exception ex) {
                    SneakyThrow.sneaky((Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            if (configVersion < 2) {
                ConfigurationSection oldSection = config.getConfigurationSection(this.worldName);
                config.set("world-settings.".concat(this.worldName), (Object)oldSection);
                config.set(this.worldName, null);
            }
            try {
                config.save(configFile);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "Unable to save leaves config", ex);
            }
        }

        void set(String path, Object val) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.set(path, val);
            if (config != null && config.get(path) != null) {
                config.set(path, val);
            }
        }

        boolean getBoolean(String path, boolean dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.addDefault(path, (Object)dfl);
            if (configVersion < 2 && config != null && config.getBoolean(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getBoolean(path) : config.getBoolean(path, this.worldDefaults.getBoolean(path));
        }

        boolean getBooleanRaw(String path, boolean dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            if (configVersion < 2 && config != null && config.getBoolean(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getBoolean(path, dfl) : config.getBoolean(path, this.worldDefaults.getBoolean(path, dfl));
        }

        int getInt(String path, int dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.addDefault(path, (Object)dfl);
            if (configVersion < 2 && config != null && config.getInt(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getInt(path) : config.getInt(path, this.worldDefaults.getInt(path));
        }

        int getIntRaw(String path, int dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            if (configVersion < 2 && config != null && config.getInt(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getInt(path, dfl) : config.getInt(path, this.worldDefaults.getInt(path, dfl));
        }

        long getLong(String path, long dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.addDefault(path, (Object)dfl);
            if (configVersion < 2 && config != null && config.getLong(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getLong(path) : config.getLong(path, this.worldDefaults.getLong(path));
        }

        long getLongRaw(String path, long dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            if (configVersion < 2 && config != null && config.getLong(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getLong(path, dfl) : config.getLong(path, this.worldDefaults.getLong(path, dfl));
        }

        double getDouble(String path, double dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.addDefault(path, (Object)dfl);
            if (configVersion < 2 && config != null && config.getDouble(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getDouble(path) : config.getDouble(path, this.worldDefaults.getDouble(path));
        }

        double getDoubleRaw(String path, double dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            if (configVersion < 2 && config != null && config.getDouble(path) == dfl) {
                config.set(path, null);
            }
            return config == null ? this.worldDefaults.getDouble(path, dfl) : config.getDouble(path, this.worldDefaults.getDouble(path, dfl));
        }

        String getString(String path, String dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.addDefault(path, (Object)dfl);
            return config == null ? this.worldDefaults.getString(path) : config.getString(path, this.worldDefaults.getString(path));
        }

        String getStringRaw(String path, String dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            return config == null ? this.worldDefaults.getString(path, dfl) : config.getString(path, this.worldDefaults.getString(path, dfl));
        }

        List getList(String path, List dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            this.worldDefaults.addDefault(path, (Object)dfl);
            return config == null ? this.worldDefaults.getList(path) : config.getList(path, this.worldDefaults.getList(path));
        }

        List getListRaw(String path, List dfl) {
            ConfigurationSection config = LeavesConfig.config.getConfigurationSection(this.configPath);
            return config == null ? this.worldDefaults.getList(path, dfl) : config.getList(path, this.worldDefaults.getList(path, dfl));
        }
    }
}

