/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.generator.WorldInfo;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.Actions;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.entity.Bot;

public class BotCommand
extends Command {
    public BotCommand(String name) {
        super(name);
        this.description = "FakePlayer Command";
        this.usageMessage = "/bot [create | remove | action | list]";
        this.setPermission("bukkit.command.bot");
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String @NotNull [] args, Location location) throws IllegalArgumentException {
        BotAction action;
        ArrayList<String> list = new ArrayList<String>();
        if (args.length <= 1) {
            list.add("create");
            list.add("remove");
            list.add("action");
            list.add("list");
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "create": {
                    list.add("<BotName>");
                    break;
                }
                case "remove": 
                case "action": {
                    list.addAll(ServerBot.getBots().stream().map(e2 -> e2.Z().getString()).toList());
                    break;
                }
                case "list": {
                    list.addAll(Bukkit.getWorlds().stream().map(WorldInfo::getName).toList());
                }
            }
        }
        if (args.length == 3) {
            switch (args[0]) {
                case "action": {
                    list.addAll(Actions.getNames());
                    break;
                }
                case "create": {
                    list.add("<BotSkinName>");
                }
            }
        }
        if (args.length >= 4 && args[0].equals("action") && (action = Actions.getForName(args[2])) != null) {
            list.addAll(action.getArgument().tabComplete(args.length - 4));
        }
        return list;
    }

    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
            return false;
        }
        switch (args[0]) {
            case "create": {
                this.onCreate(sender, args);
                break;
            }
            case "remove": {
                this.onRemove(sender, args);
                break;
            }
            case "action": {
                this.onAction(sender, args);
                break;
            }
            case "list": {
                this.onList(sender, args);
                break;
            }
            default: {
                sender.sendMessage(ChatColor.RED + "Usage: " + this.usageMessage);
                return false;
            }
        }
        return true;
    }

    private void onCreate(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /bot create <name> to create a fakeplayer");
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command only can use by player");
            return;
        }
        if (!args[1].matches("^[a-zA-Z0-9_]{4,16}$")) {
            sender.sendMessage(ChatColor.RED + "This name is unable");
            return;
        }
        if (Bukkit.getPlayer((String)args[1]) != null || ServerBot.getBot(args[1]) != null) {
            sender.sendMessage(ChatColor.RED + "This player is in server");
            return;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(args[1])) {
            sender.sendMessage(ChatColor.RED + "This name is unable");
            return;
        }
        if (ServerBot.getBots().size() >= LeavesConfig.fakeplayerLimit) {
            sender.sendMessage(ChatColor.RED + "Fakeplayer limit is full");
        }
        ServerBot.createBot(((Player)sender).getLocation(), args[1], args.length > 2 ? args[2] : null, null);
    }

    private void onRemove(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            sender.sendMessage(ChatColor.RED + "Use /bot remove <name> to remove a fakeplayer");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is null");
            return;
        }
        bot.a(bot.dG().m());
    }

    private void onAction(CommandSender sender, String @NotNull [] args) {
        if (args.length < 3) {
            sender.sendMessage(ChatColor.RED + "Use /bot action <name> <action> to make fakeplayer do action");
            return;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "This command only can use by player");
            return;
        }
        BotAction action = Actions.getForName(args[2]);
        if (action == null) {
            sender.sendMessage(ChatColor.RED + "This action is null");
            return;
        }
        ServerBot bot = ServerBot.getBot(args[1]);
        if (bot == null) {
            sender.sendMessage(ChatColor.RED + "This fakeplayer is null");
            return;
        }
        BotAction newAction = action.getNew(((CraftPlayer)sender).getHandle(), action.getArgument().parse(3, args));
        if (newAction == null) {
            sender.sendMessage(ChatColor.RED + "Action create error, check your arguments");
            return;
        }
        bot.setBotAction(newAction);
        sender.sendMessage("Action " + action.getName() + " has been issued to " + bot.Z().getString());
    }

    private void onList(CommandSender sender, String @NotNull [] args) {
        if (args.length < 2) {
            HashMap botMap = new HashMap();
            for (World world : Bukkit.getWorlds()) {
                botMap.put(world, new ArrayList());
            }
            for (ServerBot bot : ServerBot.getBots()) {
                Bot bukkitBot = bot.getBukkitPlayer();
                ((List)botMap.get(bukkitBot.getWorld())).add(bukkitBot.getName());
            }
            sender.sendMessage("Total number: (" + ServerBot.getBots().size() + "/" + LeavesConfig.fakeplayerLimit + ")");
            for (World world : botMap.keySet()) {
                sender.sendMessage(world.getName() + "(" + ((List)botMap.get(world)).size() + "): " + BotCommand.formatPlayerNameList((List)botMap.get(world)));
            }
        } else {
            World world = Bukkit.getWorld((String)args[2]);
            if (world == null) {
                sender.sendMessage(ChatColor.RED + "Unknown world");
                return;
            }
            ArrayList<String> botList = new ArrayList<String>();
            for (ServerBot bot : ServerBot.getBots()) {
                Bot bukkitBot = bot.getBukkitPlayer();
                if (bukkitBot.getWorld() != world) continue;
                botList.add(bukkitBot.getName());
            }
            sender.sendMessage(world.getName() + "(" + botList.size() + "): " + BotCommand.formatPlayerNameList(botList));
        }
    }

    @NotNull
    private static String formatPlayerNameList(@NotNull List<String> list) {
        if (list.isEmpty()) {
            return "";
        }
        String string = list.toString();
        return string.substring(1, string.length() - 1);
    }
}

