/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.InventorySubcontainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import top.leavesmc.leaves.bot.ServerBot;

public class BotInventoryContainer
extends InventorySubcontainer {
    public final NonNullList<ItemStack> items;
    public final NonNullList<ItemStack> armor;
    public final NonNullList<ItemStack> offhand;
    private final List<NonNullList<ItemStack>> compartments;
    private final NonNullList<ItemStack> buttons = NonNullList.a(13, ItemStack.b);
    private final ServerBot player;

    public BotInventoryContainer(ServerBot player) {
        super(new ItemStack[0]);
        this.player = player;
        this.items = this.player.fJ().i;
        this.armor = this.player.fJ().j;
        this.offhand = this.player.fJ().k;
        this.compartments = ImmutableList.of(this.items, this.armor, this.offhand, this.buttons);
        this.createButton();
    }

    @Override
    public int b() {
        return this.items.size() + this.armor.size() + this.offhand.size() + this.buttons.size();
    }

    @Override
    public boolean aa_() {
        for (ItemStack itemStack : this.items) {
            if (itemStack.b()) continue;
            return false;
        }
        for (ItemStack itemStack : this.armor) {
            if (itemStack.b()) continue;
            return false;
        }
        for (ItemStack itemStack : this.offhand) {
            if (itemStack.b()) continue;
            return false;
        }
        return true;
    }

    @Override
    @Nonnull
    public ItemStack a(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        if (pair != null) {
            return (ItemStack)((NonNullList)pair.getFirst()).get((Integer)pair.getSecond());
        }
        return ItemStack.b;
    }

    public Pair<NonNullList<ItemStack>, Integer> getItemSlot(int slot) {
        switch (slot) {
            case 0: {
                return new Pair(this.buttons, (Object)0);
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new Pair(this.armor, (Object)(4 - slot));
            }
            case 5: 
            case 6: {
                return new Pair(this.buttons, (Object)(slot - 4));
            }
            case 7: {
                return new Pair(this.offhand, (Object)0);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return new Pair(this.buttons, (Object)(slot - 5));
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return new Pair(this.items, (Object)(slot - 9));
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                return new Pair(this.items, (Object)(slot - 45));
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public ItemStack a(int slot, int amount) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        ItemStack itemStack = ItemStack.b;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).b()) {
            itemStack = ContainerUtil.a(list, slot, amount);
            this.player.z();
        }
        return itemStack;
    }

    @Override
    @Nonnull
    public ItemStack b(int slot) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null && !((ItemStack)list.get(slot)).b()) {
            ItemStack itemStack = (ItemStack)list.get(slot);
            list.set(slot, ItemStack.b);
            return itemStack;
        }
        return ItemStack.b;
    }

    @Override
    public void a(int slot, @Nonnull ItemStack stack) {
        Pair<NonNullList<ItemStack>, Integer> pair = this.getItemSlot(slot);
        NonNullList list = null;
        if (pair != null) {
            list = (NonNullList)pair.getFirst();
            slot = (Integer)pair.getSecond();
        }
        if (list != null) {
            list.set(slot, stack);
            this.player.z();
        }
    }

    @Override
    public void e() {
    }

    @Override
    public boolean a(@Nonnull EntityHuman player) {
        if (this.player.dB()) {
            return false;
        }
        return !(player.f((Entity)this.player) > 64.0);
    }

    @Override
    public void a() {
        for (List list : this.compartments) {
            list.clear();
        }
    }

    private void createButton() {
        for (int i2 = 0; i2 < 13; ++i2) {
            ItemStack button = new ItemStack(Items.iD);
            button.a(IChatBaseComponent.h());
            button.v().a("Leaves.Gui.Placeholder", true);
            this.buttons.set(i2, button);
        }
    }
}

