/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.util.Pair;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.stats.ServerStatisticManager;
import net.minecraft.util.MathHelper;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.TileInventory;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_19_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_19_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_19_R3.scheduler.MinecraftInternalPlugin;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.BotInventoryContainer;
import top.leavesmc.leaves.bot.BotStatsCounter;
import top.leavesmc.leaves.bot.BotUtil;
import top.leavesmc.leaves.bot.MojangAPI;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.entity.Bot;
import top.leavesmc.leaves.entity.CraftBot;
import top.leavesmc.leaves.event.bot.BotCreateEvent;
import top.leavesmc.leaves.event.bot.BotJoinEvent;
import top.leavesmc.leaves.util.MathUtils;

public class ServerBot
extends EntityPlayer {
    private Vector velocity;
    private Vector oldVelocity;
    private BotAction action;
    private BotAction newAction;
    private final boolean removeOnDeath;
    private int fireTicks;
    private int groundTicks;
    private int jumpTicks;
    private int noFallTicks;
    private int noActionTicks;
    private int doActionNumber;
    private final ItemStack defaultItem;
    private final ServerStatisticManager stats;
    public final String skinName;
    private final BotInventoryContainer container;
    private static final List<ServerBot> bots = new ArrayList<ServerBot>();
    private static final Plugin MINECRAFT_PLUGIN = new MinecraftInternalPlugin();
    private ItemStack lastItem = new ItemStack(Material.AIR);

    private ServerBot(MinecraftServer server, WorldServer world, GameProfile profile) {
        this(server, world, profile, null);
    }

    private ServerBot(MinecraftServer server, WorldServer world, GameProfile profile, String skinName) {
        super(server, world, profile);
        this.am.b(new DataWatcherObject<Integer>(16, DataWatcherRegistry.b), 255);
        this.velocity = new Vector(0, 0, 0);
        this.oldVelocity = this.velocity.clone();
        this.noFallTicks = 60;
        this.fireTicks = 0;
        this.noActionTicks = 0;
        this.doActionNumber = -1;
        this.defaultItem = new ItemStack(Material.AIR);
        this.removeOnDeath = true;
        this.stats = new BotStatsCounter(server);
        this.skinName = skinName;
        this.container = new BotInventoryContainer(this);
        server.ac().addNewBot(this);
        this.fauxSleeping = LeavesConfig.fakeplayerSkipSleep;
    }

    public static void createBot(Location loc, String name, String skinName, NBTTagList inv) {
        String realName = LeavesConfig.fakeplayerPrefix + name + LeavesConfig.fakeplayerSuffix;
        if (!ServerBot.isCreateLegal(realName)) {
            return;
        }
        if (skinName != null) {
            Bukkit.getScheduler().runTaskAsynchronously(MINECRAFT_PLUGIN, () -> {
                String[] skin = MojangAPI.getSkin(skinName);
                Bukkit.getScheduler().runTask(MINECRAFT_PLUGIN, () -> ServerBot.createBot(loc, realName, skin, skinName, inv));
            });
        } else {
            ServerBot.createBot(loc, realName, null, null, inv);
        }
    }

    @Nullable
    public static ServerBot createBot(@NotNull Location loc, @NotNull String name, String[] skin, String skinName, NBTTagList inv) {
        if (!ServerBot.isCreateLegal(name)) {
            return null;
        }
        MinecraftServer server = MinecraftServer.getServer();
        BotCreateEvent event = new BotCreateEvent(name, skinName, loc, ChatColor.YELLOW + name + " joined the game");
        server.server.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            loc = event.getCreateLocation();
            WorldServer world = ((CraftWorld)Objects.requireNonNull(loc.getWorld())).getHandle();
            UUID uuid = UUID.randomUUID();
            CustomGameProfile profile = new CustomGameProfile(uuid, name.length() > 16 ? name.substring(0, 16) : name, skin);
            ServerBot bot = new ServerBot(server, world, profile, skinName);
            bot.b = new PlayerConnection(server, new NetworkManager(EnumProtocolDirection.b){

                @Override
                public void a(@NotNull Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
                }
            }, bot);
            bot.isRealPlayer = true;
            if (event.getJoinMessage() != null) {
                Bukkit.broadcastMessage((String)event.getJoinMessage());
            }
            if (inv != null) {
                bot.fJ().b(inv);
            }
            bot.b(loc.getX(), loc.getY(), loc.getZ());
            bot.a(loc.getYaw(), loc.getPitch());
            bot.getBukkitEntity().setRotation(loc.getYaw(), loc.getPitch());
            world.addFreshEntity(bot, CreatureSpawnEvent.SpawnReason.COMMAND);
            bot.renderAll();
            bots.add(bot);
            BotJoinEvent event1 = new BotJoinEvent(bot.getBukkitPlayer());
            server.server.getPluginManager().callEvent((Event)event1);
            return bot;
        }
        return null;
    }

    public static boolean isCreateLegal(@NotNull String name) {
        if (!name.matches("^[a-zA-Z0-9_]{4,16}$")) {
            return false;
        }
        if (Bukkit.getPlayer((String)name) != null || ServerBot.getBot(name) != null) {
            return false;
        }
        if (LeavesConfig.unableFakeplayerNames.contains(name)) {
            return false;
        }
        return ServerBot.getBots().size() < LeavesConfig.fakeplayerLimit;
    }

    private void renderAll() {
        Packet[] packets = this.getRenderPackets();
        Bukkit.getOnlinePlayers().forEach(p2 -> this.render(((CraftPlayer)p2).getHandle().b, packets, false, p2.getWorld() == this.getBukkitPlayer().getWorld()));
    }

    public void render(ServerPlayerConnection connection, boolean login, boolean all) {
        this.render(connection, this.getRenderPackets(), login, all && LeavesConfig.alwaysSendFakeplayerData);
    }

    private void render(@NotNull ServerPlayerConnection connection, Packet<?> @NotNull [] packets, boolean login, boolean all) {
        connection.a(packets[0]);
        if (all) {
            connection.a(packets[1]);
            if (login) {
                connection.a(packets[2]);
            } else {
                connection.a(packets[2]);
            }
        }
    }

    @Contract(value=" -> new")
    private Packet<?> @NotNull [] getRenderPackets() {
        return new Packet[]{new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.a, ClientboundPlayerInfoUpdatePacket.a.d, ClientboundPlayerInfoUpdatePacket.a.f), List.of(this)), new PacketPlayOutNamedEntitySpawn(this), new PacketPlayOutEntityHeadRotation(this, (byte)(this.dw() * 256.0f / 360.0f))};
    }

    private void sendPacket(Packet<?> packet) {
        Bukkit.getOnlinePlayers().forEach(p2 -> ((CraftPlayer)p2).getHandle().b.a(packet));
    }

    @Override
    public void a(@NotNull DamageSource damageSource) {
        super.a(damageSource);
        this.dieCheck();
    }

    private void dieCheck() {
        if (this.removeOnDeath) {
            bots.remove(this);
            this.c.ac().removeBot(this);
            this.a(Entity.RemovalReason.a);
            this.setDead();
            this.removeTab();
            Bukkit.broadcastMessage((String)(ChatColor.YELLOW + this.Z().getString() + " leaved the game"));
        }
    }

    private void removeTab() {
        this.sendPacket(new ClientboundPlayerInfoRemovePacket(List.of(this.cs())));
    }

    private void setDead() {
        this.sendPacket(new PacketPlayOutEntityDestroy(this.af()));
        this.aZ = true;
        this.bO.b(this);
        this.bP.b(this);
    }

    @Override
    @Nullable
    public Entity b(WorldServer destination) {
        return null;
    }

    @Override
    public boolean ax() {
        return this.groundTicks != 0;
    }

    public static boolean solidAt(@NotNull Location loc) {
        Block block = loc.getBlock();
        BoundingBox box = block.getBoundingBox();
        Vector position = loc.toVector();
        double x2 = position.getX();
        double y2 = position.getY();
        double z2 = position.getZ();
        double minX = box.getMinX();
        double minY = box.getMinY();
        double minZ = box.getMinZ();
        double maxX = box.getMaxX();
        double maxY = box.getMaxY();
        double maxZ = box.getMaxZ();
        return x2 > minX && x2 < maxX && y2 > minY && y2 < maxY && z2 > minZ && z2 < maxZ;
    }

    public boolean checkGround() {
        double vy = this.velocity.getY();
        if (vy > 0.0) {
            return false;
        }
        World world = this.getBukkitPlayer().getWorld();
        AxisAlignedBB box = this.cD();
        double[] xVals = new double[]{box.a, box.d};
        double[] zVals = new double[]{box.c, box.f};
        for (double x2 : xVals) {
            for (double z2 : zVals) {
                Location loc = new Location(world, x2, this.dn() - 0.01, z2);
                Block block = world.getBlockAt(loc);
                if (!block.getType().isSolid() || !ServerBot.solidAt(loc)) continue;
                return true;
            }
        }
        return false;
    }

    public Bot getBukkitPlayer() {
        return this.getBukkitEntity();
    }

    @Override
    @NotNull
    public CraftBot getBukkitEntity() {
        return (CraftBot)super.getBukkitEntity();
    }

    @Override
    public boolean aT() {
        Location loc = this.getLocation();
        for (int i2 = 0; i2 <= 2; ++i2) {
            Material type = loc.getBlock().getType();
            if (type == Material.WATER || type == Material.LAVA) {
                return true;
            }
            loc.add(0.0, 0.9, 0.0);
        }
        return false;
    }

    @Override
    public void l() {
        super.l();
        this.m();
        if (!this.bq()) {
            return;
        }
        if (this.fireTicks > 0) {
            --this.fireTicks;
        }
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
        if (this.noFallTicks > 0) {
            --this.noFallTicks;
        }
        if (this.noActionTicks > 0) {
            --this.noActionTicks;
        }
        if (this.bU > 0) {
            --this.bU;
        }
        if (this.checkGround()) {
            if (this.groundTicks < 5) {
                ++this.groundTicks;
            }
        } else {
            this.groundTicks = 0;
        }
        this.updateLocation();
        float health = this.eo();
        float maxHealth = this.eE();
        float regenAmount = 0.01f;
        float amount = health < maxHealth - regenAmount ? health + regenAmount : maxHealth;
        this.c(amount);
        this.fallDamageCheck();
        this.ap();
        ++this.aO;
        if (this.eo() > 0.0f) {
            AxisAlignedBB axisalignedbb = this.bL() && !this.cV().dB() ? this.cD().b(this.cV().cD()).c(1.0, 0.0, 1.0) : this.cD().c(1.0, 0.5, 1.0);
            List<Entity> list = this.H.a_(this, axisalignedbb);
            ArrayList list1 = Lists.newArrayList();
            for (Entity entity : list) {
                if (entity.ae() == EntityTypes.J) {
                    list1.add(entity);
                    continue;
                }
                if (entity.dB()) continue;
                this.touch(entity);
            }
            if (!list1.isEmpty()) {
                this.touch((Entity)SystemUtils.a(list1, this.af));
            }
        }
        this.oldVelocity = this.velocity.clone();
        if (this.newAction != null) {
            this.action = this.newAction;
            this.newAction = null;
            this.noActionTicks = 0;
            this.doActionNumber = this.action.getNumber();
        }
        if (this.action != null && this.noActionTicks <= 0) {
            if (this.action.isCancel()) {
                this.action = null;
            } else if (this.doActionNumber != 0) {
                if (this.action.doTick(this)) {
                    --this.doActionNumber;
                }
                this.noActionTicks = this.action.getTickDelay();
            } else {
                this.action = null;
            }
        }
    }

    private void touch(@NotNull Entity entity) {
        entity.b_(this);
    }

    @Override
    public void a(@NotNull EntityItem item) {
        super.a(item);
        this.updateItemInMainHand();
    }

    public void updateItemInMainHand() {
        ItemStack item = this.fJ().f().asBukkitCopy();
        this.tryReplenishOrReplaceInMainHand();
        if (!this.lastItem.isSimilar(item)) {
            this.setItem(item, EnumItemSlot.a);
            this.lastItem = item;
        }
        if (item.getAmount() == 0) {
            this.setItem(this.defaultItem, EnumItemSlot.a);
            this.lastItem = this.defaultItem;
        }
    }

    public void tryReplenishOrReplaceInMainHand() {
        net.minecraft.world.item.ItemStack mainHand = this.eK();
        if (!mainHand.b()) {
            BotUtil.replenishment(mainHand, this.fJ().i);
            if (BotUtil.isDamage(mainHand, 10)) {
                BotUtil.replaceTool(EnumItemSlot.a, this);
            }
        }
    }

    @Override
    public void m() {
        if (this.aJ > 0) {
            --this.aJ;
        }
        this.ao();
        this.bm = (int)this.bl;
        this.bd = this.bc;
        this.L = this.dw();
        this.M = this.dy();
    }

    @Override
    public void g(@NotNull Entity entity) {
        double d1;
        double d0;
        double d2;
        if (!this.v(entity) && !entity.ae && !this.ae && (d2 = MathHelper.a(d0 = entity.dl() - this.dl(), d1 = entity.dr() - this.dr())) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (!this.bM()) {
                this.velocity.add(new Vector(-d0 * 3.0, 0.0, -d1 * 3.0));
            }
            if (!entity.bM()) {
                entity.j(d0, 0.0, d1);
            }
        }
    }

    public Location getLocation() {
        return this.getBukkitPlayer().getLocation();
    }

    public void setOnFirePackets(boolean onFire) {
        this.am.b(new DataWatcherObject<Byte>(0, DataWatcherRegistry.a), onFire ? (byte)1 : 0);
        List<DataWatcher.b<?>> list = this.am.b();
        if (list != null) {
            this.sendPacket(new PacketPlayOutEntityMetadata(this.af(), list));
        }
    }

    private void fallDamageCheck() {
        if (this.groundTicks != 0 && this.noFallTicks == 0 && !(this.oldVelocity.getY() >= -0.8)) {
            this.a(this.dG().k(), (float)Math.pow(3.6, -this.oldVelocity.getY()));
        }
    }

    public void addFriction(double factor) {
        double frictionMin = 0.01;
        double x2 = this.velocity.getX();
        double z2 = this.velocity.getZ();
        this.velocity.setX(Math.abs(x2) < frictionMin ? 0.0 : x2 * factor);
        this.velocity.setZ(Math.abs(z2) < frictionMin ? 0.0 : z2 * factor);
    }

    private void updateLocation() {
        double y2;
        MathUtils.clean(this.velocity);
        if (this.aT()) {
            y2 = Math.min(this.velocity.getY() + 0.1, 0.1);
            this.addFriction(0.8);
            this.velocity.setY(y2);
        } else if (this.groundTicks != 0) {
            this.velocity.setY(0);
            this.addFriction(0.5);
            y2 = 0.0;
        } else {
            y2 = this.velocity.getY();
            this.velocity.setY(Math.max(y2 - 0.1, -3.5));
        }
        this.a(EnumMoveType.a, new Vec3D(this.velocity.getX(), y2, this.velocity.getZ()));
    }

    public void faceLocation(@NotNull Location loc) {
        this.look(loc.toVector().subtract(this.getLocation().toVector()), false);
    }

    public void look(Vector dir, boolean keepYaw) {
        float pitch;
        float yaw;
        if (keepYaw) {
            yaw = this.ck();
            pitch = MathUtils.fetchPitch(dir);
        } else {
            float[] vals = MathUtils.fetchYawPitch(dir);
            yaw = vals[0];
            pitch = vals[1];
            this.sendPacket(new PacketPlayOutEntityHeadRotation(this, (byte)(yaw * 256.0f / 360.0f)));
        }
        this.a(yaw, pitch);
        this.getBukkitEntity().setRotation(yaw, pitch);
    }

    public void punch() {
        this.a(EnumHand.a);
    }

    @Override
    public void d(@NotNull Entity target) {
        super.d(target);
        this.punch();
    }

    @Override
    public void eS() {
        double jumpPower = (double)this.eQ() + this.eR();
        Vec3D vec3d = this.dj();
        this.o(vec3d.c, jumpPower, vec3d.e);
    }

    public void setItem(ItemStack item, EnumItemSlot slot) {
        if (item == null) {
            item = this.defaultItem;
        }
        this.z();
        if (slot == EnumItemSlot.a) {
            this.getBukkitPlayer().getInventory().setItemInMainHand(item);
            this.a(EnumHand.a, CraftItemStack.asNMSCopy(item));
        } else if (slot == EnumItemSlot.b) {
            this.getBukkitPlayer().getInventory().setItemInOffHand(item);
            this.a(EnumHand.b, CraftItemStack.asNMSCopy(item));
        }
        this.sendPacket(new PacketPlayOutEntityEquipment(this.af(), new ArrayList<Pair<EnumItemSlot, net.minecraft.world.item.ItemStack>>(Collections.singletonList(new Pair((Object)slot, (Object)CraftItemStack.asNMSCopy(item))))));
    }

    public void dropAll() {
        this.fJ().k();
        for (EnumItemSlot slot : EnumItemSlot.values()) {
            this.setItem(null, slot);
        }
    }

    public void setBotAction(BotAction botAction) {
        this.newAction = botAction;
    }

    @Override
    @NotNull
    public ServerStatisticManager D() {
        return this.stats;
    }

    public BotInventoryContainer getContainer() {
        return this.container;
    }

    @Override
    @NotNull
    public EnumInteractionResult a(@NotNull EntityHuman player, @NotNull EnumHand hand) {
        if (LeavesConfig.openFakeplayerInventory && player.eK().b()) {
            player.a(new TileInventory((i2, inventory, p2) -> ContainerChest.b(i2, inventory, this.container), this.G_()));
            return EnumInteractionResult.a;
        }
        return super.a(player, hand);
    }

    public static ServerBot getBot(EntityPlayer player) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (b2.af() != player.af()) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static ServerBot getBot(String name) {
        ServerBot bot = null;
        for (ServerBot b2 : bots) {
            if (!b2.Z().getString().equals(name)) continue;
            bot = b2;
            break;
        }
        return bot;
    }

    public static void saveOrRemoveAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            bots.forEach(bot -> {
                String name = bot.Z().getString();
                fakePlayerList.add(name, (JsonElement)BotUtil.saveBot(bot));
            });
            File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                try {
                    file.createNewFile();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
            try (BufferedWriter bfw = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                bfw.write(new Gson().toJson((JsonElement)fakePlayerList));
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        } else {
            ServerBot.removeAllBot();
        }
    }

    public static void loadAllBot() {
        if (LeavesConfig.fakeplayerSupport && LeavesConfig.fakeplayerResident) {
            JsonObject fakePlayerList = new JsonObject();
            File file = MinecraftServer.getServer().a(SavedFile.l).resolve("fake_player.leaves.json").toFile();
            if (!file.isFile()) {
                return;
            }
            try (BufferedReader bfr = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                fakePlayerList = (JsonObject)new Gson().fromJson((Reader)bfr, JsonObject.class);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            for (Map.Entry entry : fakePlayerList.entrySet()) {
                BotUtil.loadBot(entry);
            }
            file.delete();
        }
    }

    public static boolean removeAllBot() {
        Iterator<ServerBot> iterator = bots.iterator();
        while (iterator.hasNext()) {
            ServerBot bot = iterator.next();
            iterator.remove();
            bot.a(bot.dG().m());
        }
        return true;
    }

    public static List<ServerBot> getBots() {
        return bots;
    }

    public static class CustomGameProfile
    extends GameProfile {
        public CustomGameProfile(UUID uuid, String name, String[] skin) {
            super(uuid, name);
            this.setSkin(skin);
        }

        public void setSkin(String[] skin) {
            if (skin != null) {
                this.getProperties().put((Object)"textures", (Object)new Property("textures", skin[0], skin[1]));
            }
        }
    }
}

