/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot.agent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.bot.agent.actions.AttackAction;
import top.leavesmc.leaves.bot.agent.actions.BreakBlockAction;
import top.leavesmc.leaves.bot.agent.actions.DropAction;
import top.leavesmc.leaves.bot.agent.actions.FishAction;
import top.leavesmc.leaves.bot.agent.actions.JumpAction;
import top.leavesmc.leaves.bot.agent.actions.LookAction;
import top.leavesmc.leaves.bot.agent.actions.RotateAction;
import top.leavesmc.leaves.bot.agent.actions.SneakAction;
import top.leavesmc.leaves.bot.agent.actions.StopAction;
import top.leavesmc.leaves.bot.agent.actions.UseItemAction;
import top.leavesmc.leaves.bot.agent.actions.UseItemOnAction;
import top.leavesmc.leaves.bot.agent.actions.UseItemToAction;

public class Actions {
    private static final Map<String, BotAction> actions = new HashMap<String, BotAction>();

    public static void registerAll() {
        Actions.register(new AttackAction());
        Actions.register(new BreakBlockAction());
        Actions.register(new DropAction());
        Actions.register(new JumpAction());
        Actions.register(new RotateAction());
        Actions.register(new SneakAction());
        Actions.register(new StopAction());
        Actions.register(new UseItemAction());
        Actions.register(new UseItemOnAction());
        Actions.register(new UseItemToAction());
        Actions.register(new LookAction());
        Actions.register(new FishAction());
    }

    public static void register(@NotNull BotAction action) {
        if (!actions.containsKey(action.getName())) {
            actions.put(action.getName(), action);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static Collection<BotAction> getAll() {
        return actions.values();
    }

    @NotNull
    public static Set<String> getNames() {
        return actions.keySet();
    }

    public static BotAction getForName(String name) {
        return actions.get(name);
    }
}

