/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.bot.agent.actions;

import java.util.List;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFishingHook;
import net.minecraft.world.item.ItemFishingRod;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.bot.agent.BotAction;
import top.leavesmc.leaves.command.CommandArgument;
import top.leavesmc.leaves.command.CommandArgumentResult;
import top.leavesmc.leaves.command.CommandArgumentType;

public class FishAction
extends BotAction {
    private int delay = 0;
    private int nowDelay = 0;

    public FishAction() {
        super("fish", new CommandArgument(CommandArgumentType.INTEGER, CommandArgumentType.INTEGER));
        this.setTabComplete(0, List.of("[TickDelay]"));
        this.setTabComplete(1, List.of("[DoNumber]"));
    }

    @Override
    public BotAction getNew(@NotNull EntityPlayer player, @NotNull CommandArgumentResult result) {
        return new FishAction().setTickDelay(result.readInt(20)).setNumber(result.readInt(-1));
    }

    @Override
    public BotAction setTickDelay(int tickDelay) {
        super.setTickDelay(0);
        this.delay = tickDelay;
        return this;
    }

    @Override
    public boolean doTick(@NotNull ServerBot bot) {
        if (this.nowDelay > 0) {
            --this.nowDelay;
            return false;
        }
        ItemStack mainHand = bot.eK();
        if (mainHand == ItemStack.b || mainHand.c().getClass() != ItemFishingRod.class) {
            return false;
        }
        EntityFishingHook fishingHook = bot.ch;
        if (fishingHook != null) {
            if (fishingHook.p == EntityFishingHook.HookState.b) {
                mainHand.a((World)bot.x(), (EntityHuman)bot, EnumHand.a);
                this.nowDelay = 20;
                return false;
            }
            if (fishingHook.j > 0) {
                mainHand.a((World)bot.x(), (EntityHuman)bot, EnumHand.a);
                this.nowDelay = this.delay;
                return true;
            }
        } else {
            mainHand.a((World)bot.x(), (EntityHuman)bot, EnumHand.a);
        }
        return false;
    }
}

