/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.profile;

import com.destroystokyo.paper.profile.PaperAuthenticationService;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.exceptions.InsufficientPrivilegesException;
import com.mojang.authlib.exceptions.InvalidCredentialsException;
import com.mojang.authlib.exceptions.UserBannedException;
import com.mojang.authlib.exceptions.UserMigratedException;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import com.mojang.authlib.yggdrasil.response.ProfileSearchResultsResponse;
import com.mojang.util.UUIDTypeAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import top.leavesmc.leaves.profile.LeavesMinecraftSessionService;

public class LeavesAuthenticationService
extends PaperAuthenticationService {
    protected final Gson gson;

    public LeavesAuthenticationService(Proxy proxy) {
        super(proxy);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(GameProfile.class, (Object)new GameProfileSerializer());
        builder.registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer());
        builder.registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter());
        builder.registerTypeAdapter(ProfileSearchResultsResponse.class, (Object)new ProfileSearchResultsResponse.Serializer());
        this.gson = builder.create();
    }

    @Override
    public MinecraftSessionService createMinecraftSessionService() {
        return new LeavesMinecraftSessionService(this, this.environment);
    }

    public HasJoinedMinecraftServerResponse makeHasJoinResponse(URL url) throws AuthenticationException {
        try {
            String jsonResult = this.performGetRequest(url, null);
            HasJoinedMinecraftServerResponse result = (HasJoinedMinecraftServerResponse)this.gson.fromJson(jsonResult, HasJoinedMinecraftServerResponse.class);
            if (result == null) {
                return null;
            }
            if (StringUtils.isNotBlank((CharSequence)result.getError())) {
                if ("UserMigratedException".equals(result.getCause())) {
                    throw new UserMigratedException(result.getErrorMessage());
                }
                if ("ForbiddenOperationException".equals(result.getError())) {
                    throw new InvalidCredentialsException(result.getErrorMessage());
                }
                if ("InsufficientPrivilegesException".equals(result.getError())) {
                    throw new InsufficientPrivilegesException(result.getErrorMessage());
                }
                if ("multiplayer.access.banned".equals(result.getError())) {
                    throw new UserBannedException();
                }
                throw new AuthenticationException(result.getErrorMessage());
            }
            return result;
        }
        catch (JsonParseException | IOException | IllegalStateException var7) {
            throw new AuthenticationUnavailableException("Cannot contact authentication server", var7);
        }
    }

    public static class GameProfileSerializer
    implements JsonSerializer<GameProfile>,
    JsonDeserializer<GameProfile> {
        private GameProfileSerializer() {
        }

        public GameProfile deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = (JsonObject)json;
            UUID id = object.has("id") ? (UUID)context.deserialize(object.get("id"), UUID.class) : null;
            String name = object.has("name") ? object.getAsJsonPrimitive("name").getAsString() : null;
            return new GameProfile(id, name);
        }

        public JsonElement serialize(GameProfile src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject result = new JsonObject();
            if (src.getId() != null) {
                result.add("id", context.serialize((Object)src.getId()));
            }
            if (src.getName() != null) {
                result.addProperty("name", src.getName());
            }
            return result;
        }
    }
}

