/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.profile;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.google.common.collect.Multimap;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.yggdrasil.response.HasJoinedMinecraftServerResponse;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.profile.LeavesAuthenticationService;

public class LeavesMinecraftSessionService
extends PaperMinecraftSessionService {
    private static List<URL> extraYggdrasilList = List.of();

    protected LeavesMinecraftSessionService(LeavesAuthenticationService authenticationService, Environment environment) {
        super(authenticationService, environment);
    }

    public static void initExtraYggdrasilList() {
        ArrayList<URL> list = new ArrayList<URL>();
        for (String str : LeavesConfig.extraYggdrasilServiceList) {
            list.add(HttpAuthenticationService.constantURL((String)(str + "/sessionserver/session/minecraft/hasJoined")));
        }
        extraYggdrasilList = Collections.unmodifiableList(list);
    }

    public LeavesAuthenticationService getAuthenticationService() {
        return (LeavesAuthenticationService)super.getAuthenticationService();
    }

    public GameProfile hasJoinedServer(GameProfile user, String serverId, InetAddress address) throws AuthenticationUnavailableException {
        GameProfile result = super.hasJoinedServer(user, serverId, address);
        EntityPlayer player = MinecraftServer.getServer().ac().a(user.getName());
        if (player != null && !(player instanceof ServerBot)) {
            return null;
        }
        if (LeavesConfig.extraYggdrasilService && result == null) {
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("username", user.getName());
            arguments.put("serverId", serverId);
            if (address != null) {
                arguments.put("ip", address.getHostAddress());
            }
            for (URL checkUrl : extraYggdrasilList) {
                URL url = HttpAuthenticationService.concatenateURL((URL)checkUrl, (String)HttpAuthenticationService.buildQuery(arguments));
                try {
                    HasJoinedMinecraftServerResponse response = this.getAuthenticationService().makeHasJoinResponse(url);
                    if (response == null || response.getId() == null) continue;
                    result = new GameProfile(response.getId(), user.getName());
                    if (response.getProperties() != null) {
                        result.getProperties().putAll((Multimap)response.getProperties());
                    }
                    return result;
                }
                catch (AuthenticationUnavailableException var8) {
                    throw var8;
                }
                catch (AuthenticationException authenticationException) {
                }
            }
        }
        return result;
    }
}

