/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.food.FoodMetaData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ProtocolUtils;

public class AppleSkinProtocol {
    public static final String PROTOCOL_ID = "appleskin";
    private static final MinecraftKey SATURATION_KEY = AppleSkinProtocol.id("saturation_sync");
    private static final MinecraftKey EXHAUSTION_KEY = AppleSkinProtocol.id("exhaustion_sync");
    private static final Map<UUID, Float> previousSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> previousExhaustionLevels = new HashMap<UUID, Float>();
    private static final float MINIMUM_EXHAUSTION_CHANGE_THRESHOLD = 0.01f;
    private static final Set<EntityPlayer> players = new HashSet<EntityPlayer>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void enableAllPlayer() {
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            AppleSkinProtocol.onPlayerLoggedIn(player);
        }
    }

    public static void disableAllPlayer() {
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            AppleSkinProtocol.onPlayerLoggedOut(player);
        }
    }

    public static void onPlayerLoggedIn(@NotNull EntityPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            players.add(player);
            AppleSkinProtocol.resetPlayerData(player);
        }
    }

    public static void onPlayerLoggedOut(@NotNull EntityPlayer player) {
        if (LeavesConfig.appleskinProtocol) {
            players.remove(player);
            AppleSkinProtocol.resetPlayerData(player);
        }
    }

    private static void resetPlayerData(@NotNull EntityPlayer player) {
        previousExhaustionLevels.remove(player.cs());
        previousSaturationLevels.remove(player.cs());
    }

    public static void tick() {
        if (LeavesConfig.appleskinProtocol) {
            for (EntityPlayer player : players) {
                FoodMetaData data = player.fT();
                float saturation = data.e();
                Float previousSaturation = previousSaturationLevels.get(player.cs());
                if (previousSaturation == null || saturation != previousSaturation.floatValue()) {
                    PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                    buf.writeFloat(saturation);
                    ProtocolUtils.sendPayloadPacket(player, SATURATION_KEY, buf);
                    previousSaturationLevels.put(player.cs(), Float.valueOf(saturation));
                }
                float exhaustion = data.d();
                Float previousExhaustion = previousExhaustionLevels.get(player.cs());
                if (previousExhaustion != null && !(Math.abs(exhaustion - previousExhaustion.floatValue()) >= 0.01f)) continue;
                PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
                buf.writeFloat(exhaustion);
                ProtocolUtils.sendPayloadPacket(player, EXHAUSTION_KEY, buf);
                previousExhaustionLevels.put(player.cs(), Float.valueOf(exhaustion));
            }
        }
    }
}

