/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.BlockRedstoneComparator;
import net.minecraft.world.level.block.BlockRepeater;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyComparatorMode;
import net.minecraft.world.level.block.state.properties.BlockPropertyHalf;
import net.minecraft.world.level.block.state.properties.BlockPropertySlabType;
import net.minecraft.world.level.block.state.properties.BlockStateDirection;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.phys.Vec3D;
import org.jetbrains.annotations.NotNull;

public class CarpetAlternativeBlockPlacement {
    @Nullable
    public static IBlockData alternativeBlockPlacement(@NotNull Block block, @NotNull BlockActionContext context) {
        Vec3D hitPos = context.l();
        BlockPosition blockPos = context.a();
        double relativeHitX = hitPos.c - (double)blockPos.u();
        IBlockData state = block.a(context);
        if (relativeHitX < 2.0 || state == null) {
            return null;
        }
        BlockStateDirection directionProp = CarpetAlternativeBlockPlacement.getFirstDirectionProperty(state);
        int protocolValue = ((int)relativeHitX - 2) / 2;
        if (directionProp != null) {
            EnumDirection origFacing;
            EnumDirection facing = origFacing = state.c(directionProp);
            int facingIndex = protocolValue & 0xF;
            if (facingIndex == 6) {
                facing = facing.g();
            } else if (facingIndex <= 5) {
                facing = EnumDirection.a(facingIndex);
            }
            if (!directionProp.a().contains(facing)) {
                facing = context.o().cA().g();
            }
            if (facing != origFacing && directionProp.a().contains(facing)) {
                if (state.b() instanceof BlockBed) {
                    BlockPosition headPos = blockPos.a(facing);
                    if (!context.q().a_(headPos).a(context)) {
                        return null;
                    }
                }
                state = (IBlockData)state.a(directionProp, facing);
            }
        } else if (state.b(BlockProperties.I)) {
            EnumDirection.EnumAxis axis = EnumDirection.EnumAxis.d[protocolValue % 3];
            state = (IBlockData)state.a(BlockProperties.I, axis);
        }
        if ((protocolValue &= 0xFFFFFFF0) >= 16) {
            if (block instanceof BlockRepeater) {
                Integer delay = protocolValue / 16;
                if (BlockRepeater.d.a().contains(delay)) {
                    state = (IBlockData)state.a(BlockRepeater.d, delay);
                }
            } else if (protocolValue == 16) {
                if (block instanceof BlockRedstoneComparator) {
                    state = (IBlockData)state.a(BlockRedstoneComparator.a, BlockPropertyComparatorMode.b);
                } else if (state.b(BlockProperties.af) && state.c(BlockProperties.af) == BlockPropertyHalf.b) {
                    state = (IBlockData)state.a(BlockProperties.af, BlockPropertyHalf.a);
                } else if (state.b(BlockProperties.bh) && state.c(BlockProperties.bh) == BlockPropertySlabType.b) {
                    state = (IBlockData)state.a(BlockProperties.bh, BlockPropertySlabType.a);
                }
            }
        }
        return state;
    }

    @Nullable
    public static BlockStateDirection getFirstDirectionProperty(@NotNull IBlockData state) {
        for (IBlockState<?> prop : state.x()) {
            if (!(prop instanceof BlockStateDirection)) continue;
            return (BlockStateDirection)prop;
        }
        return null;
    }
}

