/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.ChestLock;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInfo;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.EntityChicken;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.animal.frog.Tadpole;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntityBrewingStand;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityComparator;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.entity.TileEntityEnderChest;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import net.minecraft.world.level.block.entity.TileEntityHopper;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityLectern;
import net.minecraft.world.level.block.entity.TileEntityLootable;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.util.ProtocolUtils;

public class JadeProtocol {
    public static final String PROTOCOL_ID = "jade";
    public static final MinecraftKey PACKET_SERVER_PING = JadeProtocol.id("server_ping");
    public static final MinecraftKey PACKET_RECEIVE_DATA = JadeProtocol.id("receive_data");
    public static final MinecraftKey PACKET_REQUEST_ENTITY = JadeProtocol.id("request_entity");
    public static final MinecraftKey PACKET_REQUEST_TILE = JadeProtocol.id("request_tile");
    private static final HierarchyLookup<IJadeProvider<Entity>> entityDataProviders = new HierarchyLookup(Entity.class);
    private static final HierarchyLookup<IJadeProvider<TileEntity>> tileDataProviders = new HierarchyLookup(TileEntity.class);
    public static final int MAX_DISTANCE_SQR = 900;
    private static final Map<MinecraftKey, TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>> globalReceivers = new HashMap<MinecraftKey, TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void onPlayerJoin(EntityPlayer player) {
        if (LeavesConfig.jadeProtocol) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.a("{}");
            ProtocolUtils.sendPayloadPacket(player, PACKET_SERVER_PING, buf);
        }
    }

    public static void enableAllPlayer() {
        for (EntityPlayer player : MinecraftServer.getServer().ac().k) {
            JadeProtocol.onPlayerJoin(player);
        }
    }

    private static void registerGlobalReceiver(MinecraftKey identifier, TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer> consumer) {
        globalReceivers.put(identifier, consumer);
    }

    public static void handlePacket(MinecraftServer server, EntityPlayer player, @NotNull PacketPlayInCustomPayload packet) {
        globalReceivers.getOrDefault(packet.c, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)(server1, player1, buf) -> LeavesLogger.LOGGER.severe("NullPotion"))).accept((Object)server, (Object)player, (Object)packet.d);
    }

    public static void init() {
        entityDataProviders.register(Entity.class, (data, player, world, entity, showDetails) -> {
            UUID ownerUUID = null;
            if (entity instanceof OwnableEntity) {
                ownerUUID = ((OwnableEntity)((Object)entity)).T_();
            } else if (entity instanceof EntityHorseAbstract) {
                ownerUUID = ((EntityHorseAbstract)entity).T_();
            }
            if (ownerUUID != null) {
                MinecraftServer.getServer().ap().a(ownerUUID).map(GameProfile::getName).ifPresent(name -> data.a("OwnerName", (String)name));
            }
        });
        entityDataProviders.register(EntityLiving.class, (data, player, world, entity, showDetails) -> {
            EntityLiving living = (EntityLiving)entity;
            Collection<MobEffect> effects = living.el();
            if (effects.isEmpty()) {
                return;
            }
            NBTTagList list = new NBTTagList();
            for (MobEffect effect : effects) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.a("Name", effect.i());
                compound.a("Amplifier", effect.e());
                int duration = Math.min(Short.MAX_VALUE, effect.d());
                compound.a("Duration", duration);
                compound.a("Bad", effect.c().f() == MobEffectInfo.b);
                list.add(compound);
            }
            data.a("Potions", list);
        });
        entityDataProviders.register(EntityAgeable.class, (data, player, world, entity, showDetails) -> {
            int time = -((EntityAgeable)entity).h();
            if (time > 0) {
                data.a("GrowingTime", time);
            }
        });
        entityDataProviders.register(Tadpole.class, (data, player, world, entity, showDetails) -> {
            int time = ((Tadpole)entity).fX();
            if (time > 0) {
                data.a("GrowingTime", time);
            }
        });
        entityDataProviders.register(EntityAnimal.class, (data, player, world, entity, showDetails) -> {
            int time = ((EntityAnimal)entity).h();
            if (time > 0) {
                data.a("BreedingCD", time);
            }
        });
        entityDataProviders.register(Allay.class, (data, player, world, entity, showDetails) -> {
            int time = 0;
            Allay allay = (Allay)entity;
            if (allay.ci > 0L && allay.ci < Integer.MAX_VALUE) {
                time = (int)allay.ci;
            }
            if (time > 0) {
                data.a("BreedingCD", time);
            }
        });
        entityDataProviders.register(EntityChicken.class, (data, player, world, entity, showDetails) -> data.a("NextEgg", ((EntityChicken)entity).bY / 20));
        entityDataProviders.register(Entity.class, (tag, player, world, object, showDetails) -> {
            List groups = JadeProtocol.getGroups(player, (WorldServer)world, object, showDetails);
            if (groups != null) {
                ContainerEntity containerEntity;
                if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                    NBTTagCompound itemTag = new NBTTagCompound();
                    int count = item.K();
                    if (count > 64) {
                        item.f(1);
                    }
                    item.b(itemTag);
                    if (count > 64) {
                        itemTag.a("NewCount", count);
                    }
                    return itemTag;
                })) {
                    tag.a("JadeItemStorageUid", EntityTypes.a(object.ae()).toString());
                } else if (object instanceof ContainerEntity && (containerEntity = (ContainerEntity)((Object)object)).z() != null) {
                    tag.a("Loot", true);
                }
            }
        });
        tileDataProviders.register(TileEntityBrewingStand.class, (data, player, world, object, showDetails) -> {
            if (object instanceof TileEntityBrewingStand) {
                TileEntityBrewingStand brewingStand = (TileEntityBrewingStand)object;
                NBTTagCompound compound = new NBTTagCompound();
                compound.a("Time", brewingStand.n);
                compound.a("Fuel", brewingStand.t);
                data.a("BrewingStand", compound);
            }
        });
        tileDataProviders.register(TileEntityBeehive.class, (data, player, world, object, showDetails) -> {
            data.e().clear();
            TileEntityBeehive beehive = (TileEntityBeehive)object;
            data.a("Bees", (byte)beehive.g());
            data.a("Full", beehive.f());
        });
        tileDataProviders.register(TileEntityCommand.class, (data, player, world, object, showDetails) -> {
            if (object == null || !player.gg()) {
                return;
            }
            CommandBlockListenerAbstract logic = ((TileEntityCommand)object).c();
            Object command = logic.l();
            if (((String)command).isEmpty()) {
                return;
            }
            if (((String)command).length() > 40) {
                command = ((String)command).substring(0, 37) + "...";
            }
            data.a("Command", (String)command);
        });
        tileDataProviders.register(TileEntityJukeBox.class, (data, player, world, object, showDetails) -> {
            TileEntityJukeBox jukebox;
            ItemStack stack;
            if (object instanceof TileEntityJukeBox && !(stack = (jukebox = (TileEntityJukeBox)object).at_()).b()) {
                data.a("Record", stack.b(new NBTTagCompound()));
            }
        });
        tileDataProviders.register(TileEntityLectern.class, (data, player, world, object, showDetails) -> {
            ItemStack stack = ((TileEntityLectern)object).c();
            if (!stack.b() && (stack.z() || stack.c() != Items.tc)) {
                data.a("Book", stack.b(new NBTTagCompound()));
            }
        });
        tileDataProviders.register(TileEntityComparator.class, (data, player, world, object, showDetails) -> data.a("Signal", ((TileEntityComparator)object).c()));
        tileDataProviders.register(TileEntityHopper.class, (data, player, world, object, showDetails) -> {
            IBlockData state = object.q();
            if (state.b(BlockProperties.f) && !state.c(BlockProperties.f).booleanValue()) {
                data.a("HopperLocked", true);
            }
        });
        tileDataProviders.register(TileEntityFurnace.class, (data, player, world, object, showDetails) -> {
            TileEntityFurnace furnace = (TileEntityFurnace)object;
            NBTTagList items = new NBTTagList();
            for (int i2 = 0; i2 < 3; ++i2) {
                items.add(furnace.a(i2).b(new NBTTagCompound()));
            }
            data.a("furnace", items);
            NBTTagCompound furnaceTag = furnace.o();
            data.a("progress", furnaceTag.h("CookTime"));
            data.a("total", furnaceTag.h("CookTimeTotal"));
        });
        tileDataProviders.register(TileEntity.class, (data, player, world, object, showDetails) -> {
            INamableTileEntity nameable;
            if (object instanceof INamableTileEntity && (nameable = (INamableTileEntity)((Object)object)).aa()) {
                data.a("givenName", IChatBaseComponent.ChatSerializer.a(nameable.ab()));
            }
        });
        tileDataProviders.register(TileEntity.class, (tag, player, world, object, showDetails) -> {
            if (object instanceof TileEntityFurnace) {
                return;
            }
            List groups = JadeProtocol.getGroups(player, (WorldServer)world, object, showDetails);
            if (groups != null) {
                if (ViewGroup.saveList(tag, "JadeItemStorage", groups, item -> {
                    NBTTagCompound itemTag = new NBTTagCompound();
                    int count = item.K();
                    if (count > 64) {
                        item.f(1);
                    }
                    item.b(itemTag);
                    if (count > 64) {
                        itemTag.a("NewCount", count);
                    }
                    return itemTag;
                })) {
                    tag.a("JadeItemStorageUid", TileEntityTypes.a(object.u()).toString());
                } else {
                    TileEntityContainer te;
                    if (object instanceof TileEntityLootable) {
                        te = (TileEntityLootable)object;
                        if (te.h != null) {
                            tag.a("Loot", true);
                            return;
                        }
                    }
                    if (!player.f() && !player.F_() && object instanceof TileEntityContainer) {
                        te = (TileEntityContainer)object;
                        if (te.c != ChestLock.a) {
                            tag.a("Locked", true);
                        }
                    }
                }
            }
        });
        JadeProtocol.registerGlobalReceiver(PACKET_REQUEST_TILE, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)JadeProtocol::requestTileData));
        JadeProtocol.registerGlobalReceiver(PACKET_REQUEST_ENTITY, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)JadeProtocol::requestEntityData));
    }

    public static void requestEntityData(MinecraftServer server, EntityPlayer player, PacketDataSerializer buf) {
        if (!LeavesConfig.jadeProtocol) {
            return;
        }
        World world = player.H;
        Entity entity = world.a(buf.m());
        boolean showDetails = buf.readBoolean();
        if (entity == null || player.f(entity) > 900.0) {
            return;
        }
        server.execute(() -> {
            List<IJadeProvider<Entity>> providers = entityDataProviders.get(entity);
            if (providers.isEmpty()) {
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            for (IJadeProvider<Entity> provider : providers) {
                try {
                    provider.saveData(tag, player, world, entity, showDetails);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            tag.a("WailaEntityID", entity.af());
            PacketDataSerializer buf1 = new PacketDataSerializer(Unpooled.buffer());
            buf1.a(tag);
            ProtocolUtils.sendPayloadPacket(player, PACKET_RECEIVE_DATA, buf1);
        });
    }

    public static void requestTileData(MinecraftServer server, EntityPlayer player, PacketDataSerializer buf) {
        if (!LeavesConfig.jadeProtocol) {
            return;
        }
        BlockPosition pos = buf.f();
        boolean showDetails = buf.readBoolean();
        World world = player.H;
        if (pos.j(player.dg()) > 900.0 || !world.o(pos)) {
            return;
        }
        server.execute(() -> {
            TileEntity tile = world.c_(pos);
            if (tile == null) {
                return;
            }
            List<IJadeProvider<TileEntity>> providers = tileDataProviders.get(tile);
            if (providers.isEmpty()) {
                return;
            }
            NBTTagCompound tag = new NBTTagCompound();
            for (IJadeProvider<TileEntity> provider : providers) {
                try {
                    provider.saveData(tag, player, world, tile, showDetails);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            tag.a("x", pos.u());
            tag.a("y", pos.v());
            tag.a("z", pos.w());
            tag.a("id", BuiltInRegistries.l.b(tile.u()).toString());
            PacketDataSerializer buf1 = new PacketDataSerializer(Unpooled.buffer());
            buf1.a(tag);
            ProtocolUtils.sendPayloadPacket(player, PACKET_RECEIVE_DATA, buf1);
        });
    }

    public static List<ViewGroup<ItemStack>> getGroups(EntityPlayer player, WorldServer world, Object target, boolean showDetails) {
        ContainerEntity containerEntity;
        TileEntityContainer te;
        if (target instanceof TileEntityLootable) {
            te = (TileEntityLootable)target;
            if (te.h != null) {
                return List.of();
            }
        }
        if (target instanceof ContainerEntity && (containerEntity = (ContainerEntity)target).z() != null) {
            return List.of();
        }
        if (!player.f() && !player.F_() && target instanceof TileEntityContainer) {
            te = (TileEntityContainer)target;
            if (te.c != ChestLock.a) {
                return List.of();
            }
        }
        return JadeProtocol.wrapItemStorage(target, player);
    }

    public static List<ViewGroup<ItemStack>> wrapItemStorage(Object target, EntityPlayer player) {
        int size = 54;
        if (target instanceof EntityHorseAbstract) {
            EntityHorseAbstract horse = (EntityHorseAbstract)target;
            return List.of(JadeProtocol.fromContainer(horse.cn, size, 2));
        }
        if (target instanceof IInventory) {
            BlockChest chestBlock;
            IInventory compound;
            TileEntityChest be;
            Block block;
            IInventory container = (IInventory)target;
            if (target instanceof TileEntityChest && (block = (be = (TileEntityChest)target).q().b()) instanceof BlockChest && (compound = BlockChest.a(chestBlock = (BlockChest)block, be.q(), be.k(), be.p(), false)) != null) {
                container = compound;
            }
            return List.of(JadeProtocol.fromContainer(container, size, 0));
        }
        if (player != null && target instanceof TileEntityEnderChest) {
            return List.of(JadeProtocol.fromContainer(player.fW(), size, 0));
        }
        return null;
    }

    public static ViewGroup<ItemStack> fromContainer(IInventory container, int maxSize, int startIndex) {
        return JadeProtocol.compacted(IntStream.range(startIndex, container.b()).limit((long)maxSize * 3L).mapToObj(container::a), maxSize);
    }

    public static ViewGroup<ItemStack> compacted(Stream<ItemStack> stream, int maxSize) {
        ArrayList stacks = Lists.newArrayList();
        MutableInt start = new MutableInt();
        stream.filter(stack -> !stack.b()).filter(stack -> {
            if (stack.t() && stack.u().e("CustomModelData")) {
                for (String key : stack.u().e()) {
                    if (!key.toLowerCase(Locale.ENGLISH).endsWith("clear") || !stack.u().q(key)) continue;
                    return false;
                }
            }
            return true;
        }).forEach(stack -> {
            int size = stacks.size();
            if (size > maxSize) {
                return;
            }
            for (int i2 = 0; i2 < size; ++i2) {
                int j2 = (i2 + start.intValue()) % size;
                if (!ItemStack.d(stack, (ItemStack)stacks.get(j2))) continue;
                ((ItemStack)stacks.get(j2)).g(stack.K());
                start.setValue(j2);
                return;
            }
            stacks.add(stack.o());
        });
        if (stacks.size() > maxSize) {
            stacks.remove(maxSize);
        }
        return new ViewGroup<ItemStack>(stacks);
    }

    public static class HierarchyLookup<T extends IJadeProvider<?>> {
        private final Class<?> baseClass;
        private final ListMultimap<Class<?>, T> objects = ArrayListMultimap.create();
        private final Cache<Class<?>, List<T>> resultCache = CacheBuilder.newBuilder().build();
        private final boolean singleton;

        public HierarchyLookup(Class<?> baseClass) {
            this(baseClass, false);
        }

        public HierarchyLookup(Class<?> baseClass, boolean singleton) {
            this.baseClass = baseClass;
            this.singleton = singleton;
        }

        public void register(Class<?> clazz, T provider) {
            Objects.requireNonNull(clazz);
            this.objects.put(clazz, provider);
        }

        public List<T> get(Object obj) {
            if (obj == null) {
                return List.of();
            }
            return this.get(obj.getClass());
        }

        public List<T> get(Class<?> clazz) {
            try {
                return (List)this.resultCache.get(clazz, () -> {
                    ArrayList list = Lists.newArrayList();
                    this.getInternal(clazz, list);
                    if (this.singleton && !list.isEmpty()) {
                        return ImmutableList.of((Object)((IJadeProvider)list.get(0)));
                    }
                    return list;
                });
            }
            catch (ExecutionException e2) {
                e2.printStackTrace();
                return List.of();
            }
        }

        private void getInternal(Class<?> clazz, List<T> list) {
            if (clazz != this.baseClass && clazz != Object.class) {
                this.getInternal(clazz.getSuperclass(), list);
            }
            list.addAll(this.objects.get(clazz));
        }
    }

    public static interface IJadeProvider<T> {
        public void saveData(NBTTagCompound var1, EntityPlayer var2, World var3, T var4, boolean var5);
    }

    public static class ViewGroup<T> {
        public final List<T> views;
        @Nullable
        public String id;
        @Nullable
        protected NBTTagCompound extraData;

        public ViewGroup(List<T> views) {
            this.views = views;
        }

        public void save(NBTTagCompound tag, Function<T, NBTTagCompound> writer) {
            NBTTagList list = new NBTTagList();
            for (T view : this.views) {
                list.add((NBTBase)writer.apply(view));
            }
            tag.a("Views", list);
            if (this.id != null) {
                tag.a("Id", this.id);
            }
            if (this.extraData != null) {
                tag.a("Data", this.extraData);
            }
        }

        public static <T> boolean saveList(NBTTagCompound tag, String key, List<ViewGroup<T>> groups, Function<T, NBTTagCompound> writer) {
            if (groups == null || groups.isEmpty()) {
                return false;
            }
            NBTTagList groupList = new NBTTagList();
            for (ViewGroup<T> group : groups) {
                if (group.views.isEmpty()) continue;
                NBTTagCompound groupTag = new NBTTagCompound();
                group.save(groupTag, writer);
                groupList.add(groupTag);
            }
            if (!groupList.isEmpty()) {
                tag.a(key, groupList);
                return true;
            }
            return false;
        }

        public NBTTagCompound getExtraData() {
            if (this.extraData == null) {
                this.extraData = new NBTTagCompound();
            }
            return this.extraData;
        }

        public void setProgress(float progress) {
            this.getExtraData().a("Progress", progress);
        }
    }
}

