/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.PacketPlayInCustomPayload;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.util.TriConsumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.LeavesLogger;
import top.leavesmc.leaves.bot.ServerBot;
import top.leavesmc.leaves.util.ProtocolUtils;

public class PcaSyncProtocol {
    public static final String PROTOCOL_ID = "pca";
    public static final ReentrantLock lock = new ReentrantLock(true);
    public static final ReentrantLock pairLock = new ReentrantLock(true);
    private static final MinecraftKey ENABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("enable_pca_sync_protocol");
    private static final MinecraftKey DISABLE_PCA_SYNC_PROTOCOL = PcaSyncProtocol.id("disable_pca_sync_protocol");
    private static final MinecraftKey UPDATE_ENTITY = PcaSyncProtocol.id("update_entity");
    private static final MinecraftKey UPDATE_BLOCK_ENTITY = PcaSyncProtocol.id("update_block_entity");
    private static final MinecraftKey SYNC_BLOCK_ENTITY = PcaSyncProtocol.id("sync_block_entity");
    private static final MinecraftKey SYNC_ENTITY = PcaSyncProtocol.id("sync_entity");
    private static final MinecraftKey CANCEL_SYNC_BLOCK_ENTITY = PcaSyncProtocol.id("cancel_sync_block_entity");
    private static final MinecraftKey CANCEL_SYNC_ENTITY = PcaSyncProtocol.id("cancel_sync_entity");
    private static final Map<EntityPlayer, Pair<MinecraftKey, BlockPosition>> playerWatchBlockPos = new HashMap<EntityPlayer, Pair<MinecraftKey, BlockPosition>>();
    private static final Map<EntityPlayer, Pair<MinecraftKey, Entity>> playerWatchEntity = new HashMap<EntityPlayer, Pair<MinecraftKey, Entity>>();
    private static final Map<Pair<MinecraftKey, BlockPosition>, Set<EntityPlayer>> blockPosWatchPlayerSet = new HashMap<Pair<MinecraftKey, BlockPosition>, Set<EntityPlayer>>();
    private static final Map<Pair<MinecraftKey, Entity>, Set<EntityPlayer>> entityWatchPlayerSet = new HashMap<Pair<MinecraftKey, Entity>, Set<EntityPlayer>>();
    private static final MutablePair<MinecraftKey, Entity> ResourceLocationEntityPair = new MutablePair();
    private static final MutablePair<MinecraftKey, BlockPosition> ResourceLocationBlockPosPair = new MutablePair();
    private static final Map<MinecraftKey, TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>> globalReceivers = new HashMap<MinecraftKey, TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>>();

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey id(String path) {
        return new MinecraftKey(PROTOCOL_ID, path);
    }

    public static void enablePcaSyncProtocol(@NotNull EntityPlayer player) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        ProtocolUtils.sendPayloadPacket(player, ENABLE_PCA_SYNC_PROTOCOL, buf);
        lock.lock();
        lock.unlock();
    }

    public static void disablePcaSyncProtocol(@NotNull EntityPlayer player) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        ProtocolUtils.sendPayloadPacket(player, DISABLE_PCA_SYNC_PROTOCOL, buf);
    }

    public static void updateEntity(@NotNull EntityPlayer player, @NotNull Entity entity) {
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(entity.Y().ab().a());
        buf.writeInt(entity.af());
        buf.a(entity.f(new NBTTagCompound()));
        ProtocolUtils.sendPayloadPacket(player, UPDATE_ENTITY, buf);
    }

    public static void updateBlockEntity(@NotNull EntityPlayer player, @NotNull TileEntity blockEntity) {
        World world = blockEntity.k();
        if (world == null) {
            return;
        }
        PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
        buf.a(world.ab().a());
        buf.a(blockEntity.p());
        buf.a(blockEntity.n());
        ProtocolUtils.sendPayloadPacket(player, UPDATE_BLOCK_ENTITY, buf);
    }

    private static void registerGlobalReceiver(MinecraftKey identifier, TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer> consumer) {
        globalReceivers.put(identifier, consumer);
    }

    public static void handlePacket(MinecraftServer server, EntityPlayer player, @NotNull PacketPlayInCustomPayload packet) {
        globalReceivers.getOrDefault(packet.c, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)(server1, player1, buf) -> LeavesLogger.LOGGER.severe("NullPotion"))).accept((Object)server, (Object)player, (Object)packet.d);
    }

    public static void init() {
        PcaSyncProtocol.registerGlobalReceiver(SYNC_BLOCK_ENTITY, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)PcaSyncProtocol::syncBlockEntityHandler));
        PcaSyncProtocol.registerGlobalReceiver(SYNC_ENTITY, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)PcaSyncProtocol::syncEntityHandler));
        PcaSyncProtocol.registerGlobalReceiver(CANCEL_SYNC_BLOCK_ENTITY, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)PcaSyncProtocol::cancelSyncBlockEntityHandler));
        PcaSyncProtocol.registerGlobalReceiver(CANCEL_SYNC_ENTITY, (TriConsumer<MinecraftServer, EntityPlayer, PacketDataSerializer>)((TriConsumer)PcaSyncProtocol::cancelSyncEntityHandler));
    }

    public static void onJoin(EntityPlayer player) {
        if (LeavesConfig.pcaSyncProtocol) {
            PcaSyncProtocol.enablePcaSyncProtocol(player);
        }
    }

    private static void cancelSyncBlockEntityHandler(MinecraftServer server, EntityPlayer player, PacketDataSerializer buf) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        PcaSyncProtocol.clearPlayerWatchBlock(player);
    }

    private static void cancelSyncEntityHandler(MinecraftServer server, EntityPlayer player, PacketDataSerializer buf) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        PcaSyncProtocol.clearPlayerWatchEntity(player);
    }

    private static void syncBlockEntityHandler(MinecraftServer server, EntityPlayer player, PacketDataSerializer buf) {
        TileEntity blockEntity;
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        BlockPosition pos = buf.f();
        WorldServer world = player.x();
        IBlockData blockState = world.a_(pos);
        PcaSyncProtocol.clearPlayerWatchData(player);
        TileEntity blockEntityAdj = null;
        if (blockState.b() instanceof BlockChest && blockState.c(BlockChest.c) != BlockPropertyChestType.a) {
            BlockPosition posAdj = pos.a(BlockChest.h(blockState).q());
            blockEntityAdj = world.A(posAdj).c_(posAdj);
        }
        if (blockEntityAdj != null) {
            PcaSyncProtocol.updateBlockEntity(player, blockEntityAdj);
        }
        if ((blockEntity = world.A(pos).c_(pos)) != null) {
            PcaSyncProtocol.updateBlockEntity(player, blockEntity);
        }
        ImmutablePair pair = new ImmutablePair((Object)player.x().ab().a(), (Object)pos);
        lock.lock();
        playerWatchBlockPos.put(player, (Pair<MinecraftKey, BlockPosition>)pair);
        if (!blockPosWatchPlayerSet.containsKey(pair)) {
            blockPosWatchPlayerSet.put((Pair<MinecraftKey, BlockPosition>)pair, new HashSet());
        }
        blockPosWatchPlayerSet.get(pair).add(player);
        lock.unlock();
    }

    private static void syncEntityHandler(MinecraftServer server, EntityPlayer player, PacketDataSerializer buf) {
        if (!LeavesConfig.pcaSyncProtocol) {
            return;
        }
        int entityId = buf.readInt();
        WorldServer world = player.x();
        Entity entity = world.a(entityId);
        if (entity != null) {
            PcaSyncProtocol.clearPlayerWatchData(player);
            if (entity instanceof EntityHuman) {
                if (LeavesConfig.pcaSyncPlayerEntity.equals("NOBODY")) {
                    return;
                }
                if (LeavesConfig.pcaSyncPlayerEntity.equals("BOT")) {
                    if (!(entity instanceof ServerBot)) {
                        return;
                    }
                } else if (LeavesConfig.pcaSyncPlayerEntity.equals("OPS")) {
                    if (!(entity instanceof ServerBot) && server.c(player.fI()) < 2) {
                        return;
                    }
                } else if (LeavesConfig.pcaSyncPlayerEntity.equals("OPS_AND_SELF")) {
                    if (!(entity instanceof ServerBot) && server.c(player.fI()) < 2 && entity != player) {
                        return;
                    }
                } else if (!LeavesConfig.pcaSyncPlayerEntity.equals("EVERYONE")) {
                    LeavesLogger.LOGGER.warning("pcaSyncPlayerEntity wtf???");
                    return;
                }
            }
            PcaSyncProtocol.updateEntity(player, entity);
            ImmutablePair pair = new ImmutablePair((Object)entity.Y().ab().a(), (Object)entity);
            lock.lock();
            playerWatchEntity.put(player, (Pair<MinecraftKey, Entity>)pair);
            if (!entityWatchPlayerSet.containsKey(pair)) {
                entityWatchPlayerSet.put((Pair<MinecraftKey, Entity>)pair, new HashSet());
            }
            entityWatchPlayerSet.get(pair).add(player);
            lock.unlock();
        }
    }

    private static MutablePair<MinecraftKey, Entity> getResourceLocationEntityPair(MinecraftKey ResourceLocation, Entity entity) {
        pairLock.lock();
        ResourceLocationEntityPair.setLeft((Object)ResourceLocation);
        ResourceLocationEntityPair.setRight((Object)entity);
        pairLock.unlock();
        return ResourceLocationEntityPair;
    }

    private static MutablePair<MinecraftKey, BlockPosition> getResourceLocationBlockPosPair(MinecraftKey ResourceLocation, BlockPosition pos) {
        pairLock.lock();
        ResourceLocationBlockPosPair.setLeft((Object)ResourceLocation);
        ResourceLocationBlockPosPair.setRight((Object)pos);
        pairLock.unlock();
        return ResourceLocationBlockPosPair;
    }

    @Nullable
    private static Set<EntityPlayer> getWatchPlayerList(@NotNull Entity entity) {
        return entityWatchPlayerSet.get(PcaSyncProtocol.getResourceLocationEntityPair(entity.Y().ab().a(), entity));
    }

    @Nullable
    private static Set<EntityPlayer> getWatchPlayerList(@NotNull World world, @NotNull BlockPosition blockPos) {
        return blockPosWatchPlayerSet.get(PcaSyncProtocol.getResourceLocationBlockPosPair(world.ab().a(), blockPos));
    }

    public static boolean syncEntityToClient(@NotNull Entity entity) {
        if (entity.Y().k_()) {
            return false;
        }
        lock.lock();
        Set<EntityPlayer> playerList = PcaSyncProtocol.getWatchPlayerList(entity);
        boolean ret = false;
        if (playerList != null) {
            for (EntityPlayer player : playerList) {
                PcaSyncProtocol.updateEntity(player, entity);
                ret = true;
            }
        }
        lock.unlock();
        return ret;
    }

    public static boolean syncBlockEntityToClient(@NotNull TileEntity blockEntity) {
        boolean ret = false;
        World world = blockEntity.k();
        BlockPosition pos = blockEntity.p();
        if (world != null) {
            if (world.k_()) {
                return false;
            }
            IBlockData blockState = world.a_(pos);
            lock.lock();
            Set<EntityPlayer> playerList = PcaSyncProtocol.getWatchPlayerList(world, blockEntity.p());
            Set<EntityPlayer> playerListAdj = null;
            if (blockState.b() instanceof BlockChest && blockState.c(BlockChest.c) != BlockPropertyChestType.a) {
                BlockPosition posAdj = pos.a(BlockChest.h(blockState).q());
                playerListAdj = PcaSyncProtocol.getWatchPlayerList(world, posAdj);
            }
            if (playerListAdj != null) {
                if (playerList == null) {
                    playerList = playerListAdj;
                } else {
                    playerList.addAll(playerListAdj);
                }
            }
            if (playerList != null) {
                for (EntityPlayer player : playerList) {
                    PcaSyncProtocol.updateBlockEntity(player, blockEntity);
                    ret = true;
                }
            }
            lock.unlock();
        }
        return ret;
    }

    private static void clearPlayerWatchEntity(EntityPlayer player) {
        lock.lock();
        Pair<MinecraftKey, Entity> pair = playerWatchEntity.get(player);
        if (pair != null) {
            Set<EntityPlayer> playerSet = entityWatchPlayerSet.get(pair);
            playerSet.remove(player);
            if (playerSet.isEmpty()) {
                entityWatchPlayerSet.remove(pair);
            }
            playerWatchEntity.remove(player);
        }
        lock.unlock();
    }

    private static void clearPlayerWatchBlock(EntityPlayer player) {
        lock.lock();
        Pair<MinecraftKey, BlockPosition> pair = playerWatchBlockPos.get(player);
        if (pair != null) {
            Set<EntityPlayer> playerSet = blockPosWatchPlayerSet.get(pair);
            playerSet.remove(player);
            if (playerSet.isEmpty()) {
                blockPosWatchPlayerSet.remove(pair);
            }
            playerWatchBlockPos.remove(player);
        }
        lock.unlock();
    }

    public static void disablePcaSyncProtocolGlobal() {
        lock.lock();
        playerWatchBlockPos.clear();
        playerWatchEntity.clear();
        blockPosWatchPlayerSet.clear();
        entityWatchPlayerSet.clear();
        lock.unlock();
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            PcaSyncProtocol.disablePcaSyncProtocol(player);
        }
    }

    public static void enablePcaSyncProtocolGlobal() {
        for (EntityPlayer player : MinecraftServer.getServer().ac().t()) {
            PcaSyncProtocol.enablePcaSyncProtocol(player);
        }
    }

    public static void clearPlayerWatchData(EntityPlayer player) {
        PcaSyncProtocol.clearPlayerWatchBlock(player);
        PcaSyncProtocol.clearPlayerWatchEntity(player);
    }
}

