/*
 * Decompiled with CFR 0.152.
 */
package top.leavesmc.leaves.protocol;

import io.netty.buffer.Unpooled;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.EntityPlayer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import top.leavesmc.leaves.LeavesConfig;
import top.leavesmc.leaves.util.ProtocolUtils;

public class XaeroMapProtocol {
    public static final String PROTOCOL_ID_MINI = "xaerominimap";
    public static final String PROTOCOL_ID_WORLD = "xaeroworldmap";
    private static final MinecraftKey MINIMAP_KEY = XaeroMapProtocol.idMini("main");
    private static final MinecraftKey WORLDMAP_KEY = XaeroMapProtocol.idWorld("main");

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey idMini(String path) {
        return new MinecraftKey(PROTOCOL_ID_MINI, path);
    }

    @Contract(value="_ -> new")
    @NotNull
    public static MinecraftKey idWorld(String path) {
        return new MinecraftKey(PROTOCOL_ID_WORLD, path);
    }

    public static void onSendWorldInfo(@NotNull EntityPlayer player) {
        if (LeavesConfig.xaeroMapProtocol) {
            PacketDataSerializer buf = new PacketDataSerializer(Unpooled.buffer());
            buf.writeByte(0);
            buf.writeInt(LeavesConfig.xaeroMapServerID);
            ProtocolUtils.sendPayloadPacket(player, MINIMAP_KEY, buf);
            ProtocolUtils.sendPayloadPacket(player, WORLDMAP_KEY, buf);
        }
    }
}

